/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ecore.design.service;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.sirius.ecore.design.service.EcoreService;

public class EOperationServices {
    private static final String TYPE_SEPARATOR = ":";
    private static final String PARAMETERS_SEPARATOR = ",";

    public String render(EOperation op) {
        StringBuilder sb = new StringBuilder();
        this.renderName(op, sb);
        this.renderParameters(op, sb, true);
        this.renderType(op, sb);
        return sb.toString();
    }

    public String renderTooltip(EOperation op) {
        StringBuilder sb = new StringBuilder();
        this.renderName(op, sb);
        this.renderParameters(op, sb, false);
        this.renderType(op, sb);
        return sb.toString();
    }

    public EOperation performEdit(EOperation op, String editString) {
        this.editName(op, editString);
        this.editParameters(op, editString);
        this.editType(op, editString);
        return op;
    }

    private void renderName(EOperation op, StringBuilder sb) {
        if (op.getName() != null) {
            sb.append(op.getName());
        }
    }

    private void renderParameters(EOperation op, StringBuilder sb, boolean includeParameterType) {
        sb.append("(");
        boolean first = true;
        for (EParameter param : op.getEParameters()) {
            if (!first) {
                sb.append(PARAMETERS_SEPARATOR).append(" ");
            } else {
                first = false;
            }
            sb.append(this.renderParameter(param, includeParameterType));
        }
        sb.append(")");
    }

    private String renderParameter(EParameter parameter, boolean includeParameterType) {
        String name = parameter.getName();
        EClassifier type = parameter.getEType();
        if (name != null && type != null && includeParameterType) {
            return String.valueOf(parameter.getName()) + " " + type.getName();
        }
        if (name != null) {
            return parameter.getName();
        }
        return "";
    }

    private void renderType(EOperation op, StringBuilder sb) {
        if (op.getEType() != null) {
            sb.append(" ").append(TYPE_SEPARATOR).append(" ");
            sb.append(op.getEType().getName());
        }
    }

    private void editName(EOperation op, String editString) {
        String namePart;
        int paramStart;
        int nameEnd = editString.length();
        int typeStart = editString.indexOf(TYPE_SEPARATOR);
        if (typeStart != -1) {
            nameEnd = Math.min(nameEnd, typeStart);
        }
        if ((paramStart = editString.indexOf("(")) != -1) {
            nameEnd = Math.min(nameEnd, paramStart);
        }
        if ((namePart = editString.substring(0, nameEnd)).trim().length() > 0) {
            op.setName(namePart.trim());
        } else if (typeStart == -1 && paramStart == -1) {
            op.setName(null);
        }
    }

    private void editParameters(EOperation op, String editString) {
        int paramStart = editString.indexOf("(");
        int paramEnd = editString.lastIndexOf(")");
        if (paramStart != -1 && paramEnd != -1 && paramStart < paramEnd) {
            List<String[]> spec = this.parseParameters(editString.substring(paramStart + 1, paramEnd));
            int nbParam = spec.size();
            int i = op.getEParameters().size() - 1;
            while (i >= nbParam) {
                op.getEParameters().remove(i);
                --i;
            }
            i = 0;
            while (i < nbParam) {
                EParameter param = null;
                if (i < op.getEParameters().size()) {
                    param = (EParameter)op.getEParameters().get(i);
                } else {
                    param = EcoreFactory.eINSTANCE.createEParameter();
                    op.getEParameters().add((Object)param);
                }
                this.updateParameter(op, param, spec.get(i));
                ++i;
            }
        }
    }

    private void updateParameter(EOperation op, EParameter param, String[] paramSpec) {
        EClassifier type;
        if (paramSpec[0] != null) {
            param.setName(paramSpec[0]);
        }
        if (paramSpec[1] != null && (type = new EcoreService().findTypeByName((EObject)op, paramSpec[1])) != null) {
            param.setEType(type);
        }
    }

    private List<String[]> parseParameters(String spec) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        if (spec.contains(PARAMETERS_SEPARATOR)) {
            String[] params;
            String[] stringArray = params = spec.split(PARAMETERS_SEPARATOR);
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String paramSpec = stringArray[n2];
                result.add(this.parseParameter(paramSpec));
                ++n2;
            }
        } else if (spec.trim().length() > 0) {
            result.add(this.parseParameter(spec));
        }
        return result;
    }

    public String[] parseParameter(String paramSpec) {
        String[] type = null;
        int typeStart = paramSpec.indexOf(TYPE_SEPARATOR);
        if (typeStart != -1) {
            type = this.splitParameterSpec(paramSpec, typeStart);
        } else {
            typeStart = (paramSpec = paramSpec.trim()).lastIndexOf(" ");
            if (typeStart != -1) {
                type = this.splitParameterSpec(paramSpec, typeStart);
            } else {
                typeStart = paramSpec.lastIndexOf("\t");
                if (typeStart != -1) {
                    type = this.splitParameterSpec(paramSpec, typeStart);
                }
            }
        }
        if (type == null) {
            String name = paramSpec.trim();
            if (name.length() == 0) {
                name = null;
            }
            String[] stringArray = new String[2];
            stringArray[0] = name;
            type = stringArray;
        }
        return type;
    }

    public List<ENamedElement> getAllAssociatedElements(EOperation op) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)(1 + op.getEParameters().size()));
        result.add(op);
        result.addAll(op.getEParameters());
        Collections.sort(result, Ordering.natural().onResultOf((Function)new Function<ENamedElement, String>(){

            public String apply(ENamedElement input) {
                return input.getName();
            }
        }));
        return result;
    }

    private String[] splitParameterSpec(String paramSpec, int typeStart) {
        String name = paramSpec.substring(0, typeStart).trim();
        String typeName = typeStart != paramSpec.length() - 1 ? paramSpec.substring(typeStart + 1).trim() : null;
        if (name.length() == 0) {
            name = null;
        }
        if (typeName != null && typeName.length() == 0) {
            typeName = null;
        }
        String[] type = new String[]{name, typeName};
        return type;
    }

    private void editType(EOperation op, String editString) {
        EClassifier type = this.getSpecifiedType((ETypedElement)op, editString);
        if (type != null) {
            op.setEType(type);
        } else {
            int typeStart = editString.lastIndexOf(TYPE_SEPARATOR);
            if (typeStart != -1 && !editString.substring(typeStart).contains(")")) {
                op.setEType(null);
            }
        }
    }

    private EClassifier getSpecifiedType(ETypedElement receiver, String editString) {
        String typeName;
        int typeStart = editString.lastIndexOf(TYPE_SEPARATOR);
        if (typeStart != -1 && editString.length() > typeStart + 1 && !(typeName = editString.substring(typeStart + 1).trim()).contains(")")) {
            return new EcoreService().findTypeByName((EObject)receiver, typeName);
        }
        return null;
    }
}

