/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.render;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.anim.dom.SVGOMDefsElement;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.anim.dom.SVGOMGElement;
import org.apache.batik.anim.dom.SVGOMImageElement;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.svggen.DOMTreeManager;
import org.apache.batik.svggen.GenericImageHandler;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderInfo;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.SVGColorConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.SVGImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.DrawableRenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.RenderingListener;
import org.eclipse.sirius.common.tools.api.util.ReflectionHelper;
import org.eclipse.sirius.diagram.ui.tools.internal.render.AnnotatedSVGShape;
import org.eclipse.sirius.diagram.ui.tools.internal.render.SVGImageRegistry;
import org.eclipse.sirius.diagram.ui.tools.internal.render.SiriusDiagramSVGGenerator;
import org.eclipse.sirius.diagram.ui.tools.internal.render.SiriusGraphicsToGraphics2DAdaptor;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SiriusGraphicsSVG
extends SiriusGraphicsToGraphics2DAdaptor
implements DrawableRenderedImage {
    private Document doc;

    public static SiriusGraphicsSVG getInstance(Rectangle viewPort, boolean svgTraceability) {
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        String svgNameSpace = "http://www.w3.org/2000/svg";
        Document doc = impl.createDocument(svgNameSpace, "svg", null);
        CustomSVGGraphics2D svgGraphics = new CustomSVGGraphics2D(doc, svgTraceability);
        svgGraphics.getGeneratorContext().setPrecision(3);
        svgGraphics.setSVGCanvasSize(new Dimension(viewPort.width, viewPort.height));
        svgGraphics.setupCustomShapeConverter();
        return new SiriusGraphicsSVG((SVGGraphics2D)svgGraphics, doc, svgNameSpace, viewPort);
    }

    public SVGGraphics2D getSVGGraphics2D() {
        return (SVGGraphics2D)this.getGraphics2D();
    }

    public void setCurrentId(String id) {
        ((CustomSVGGraphics2D)this.getSVGGraphics2D()).setCurrentId(id);
    }

    private SiriusGraphicsSVG(SVGGraphics2D graphics, Document doc, String svgNameSpace, Rectangle viewPort) {
        this(graphics, doc, svgNameSpace, new org.eclipse.swt.graphics.Rectangle(viewPort.x, viewPort.y, viewPort.width, viewPort.height));
    }

    private SiriusGraphicsSVG(SVGGraphics2D graphics, Document doc, String svgNameSpace, org.eclipse.swt.graphics.Rectangle viewPort) {
        super((Graphics2D)graphics, viewPort);
        this.doc = doc;
        this.paintNotCompatibleStringsAsBitmaps = false;
    }

    public Document getDocument() {
        return this.doc;
    }

    public Element getRoot() {
        return this.getSVGGraphics2D().getRoot();
    }

    @Override
    public org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage drawRenderedImage(org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage srcImage, Rectangle rect, RenderingListener listener) {
        this.checkState();
        DOMTreeManager treeManager = this.getSVGGraphics2D().getDOMTreeManager();
        Point trans = this.getTranslationOffset();
        if (srcImage instanceof SVGImage) {
            RenderInfo info;
            Document document = ((SVGImage)srcImage).getDocument();
            DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
            if ((document = DOMUtilities.deepCloneDocument((Document)document, (DOMImplementation)impl)) instanceof SVGOMDocument && (info = srcImage.getRenderInfo()) != null && info.getBackgroundColor() != null && info.getForegroundColor() != null) {
                SVGColorConverter.getInstance().replaceDocumentColors((SVGOMDocument)document, new Color(info.getBackgroundColor().red, info.getBackgroundColor().green, info.getBackgroundColor().blue), new Color(info.getForegroundColor().red, info.getForegroundColor().green, info.getForegroundColor().blue));
            }
            Element root = document.getDocumentElement();
            Element toAppend = (Element)this.doc.importNode(root, true);
            toAppend.setAttributeNS(null, "x", String.valueOf(rect.x + trans.x));
            toAppend.setAttributeNS(null, "y", String.valueOf(rect.y + trans.y));
            toAppend.setAttributeNS(null, "width", String.valueOf(rect.width));
            toAppend.setAttributeNS(null, "height", String.valueOf(rect.height));
            treeManager.appendGroup(toAppend, null);
            return srcImage;
        }
        return super.drawRenderedImage(srcImage, rect, listener);
    }

    public void drawSVGReference(String uri, int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        Point trans = this.getTranslationOffset();
        this.checkState();
        ((CustomSVGGraphics2D)((Object)this.getGraphics2D())).drawSVGReference(uri, x2 += trans.x, y2 += trans.y, w2, h2);
    }

    public void drawSymbolSVGImage(String uri, String uuid) {
        DOMTreeManager treeManager = this.getSVGGraphics2D().getDOMTreeManager();
        SVGGeneratorContext generatorContext = this.getSVGGraphics2D().getGeneratorContext();
        Element symbolElement = generatorContext.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "symbol");
        symbolElement.setAttributeNS(null, "id", uuid);
        Optional<Element> referencedImage = SVGImageRegistry.getReferencedImage(uri);
        List<Element> cloneDefElements = this.getDefElement(treeManager);
        if (referencedImage.isPresent()) {
            Element toAppend = (Element)((AbstractDocument)this.doc).importNode((Node)referencedImage.get(), true, true);
            symbolElement.appendChild(toAppend);
        }
        treeManager.appendGroup(symbolElement, null);
        this.moveDefinitionSet(treeManager, cloneDefElements);
    }

    protected void moveDefinitionSet(DOMTreeManager treeManager, List<Element> cloneDefElements) {
        Optional toplevelGroup;
        if (!cloneDefElements.isEmpty() && (toplevelGroup = ReflectionHelper.getFieldValueWithoutException((Object)treeManager, (String)"topLevelGroup")).isPresent() && toplevelGroup.get() instanceof Element && !this.hasDefinitionSet((Element)toplevelGroup.get())) {
            cloneDefElements.forEach(def -> treeManager.appendGroup(def, null));
        }
    }

    protected List<Element> getDefElement(DOMTreeManager treeManager) {
        List definitionSet = treeManager.getGraphicContextConverter().getDefinitionSet();
        ArrayList<Element> result = new ArrayList<Element>();
        definitionSet.forEach(def -> {
            Node cloneNode;
            if (def instanceof Element && (cloneNode = ((Element)def).cloneNode(true)) instanceof Element) {
                result.add((Element)cloneNode);
            }
        });
        if (!result.isEmpty()) {
            treeManager.getDefinitionSet();
        }
        return result;
    }

    protected boolean hasDefinitionSet(Element topLevelGroup) {
        int i = 0;
        while (i < topLevelGroup.getChildNodes().getLength()) {
            Node node = topLevelGroup.getChildNodes().item(i);
            if (node instanceof SVGOMDefsElement) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static class CustomSVGGraphics2D
    extends SVGGraphics2D {
        private boolean svgTraceability;
        private String currentId;

        public CustomSVGGraphics2D(Document doc, boolean svgTraceability) {
            super(doc);
            this.svgTraceability = svgTraceability;
        }

        public void setupCustomShapeConverter() {
            this.shapeConverter = new AnnotatedSVGShape(this.generatorCtx, "http://www.eclipse.org/sirius/diagram/1.1.0", this.svgTraceability);
            final GenericImageHandler handler = this.getGenericImageHandler();
            this.getGeneratorContext().setGenericImageHandler(new GenericImageHandler(){

                public void setDOMTreeManager(DOMTreeManager domTreeManager) {
                    handler.setDOMTreeManager(domTreeManager);
                }

                public AffineTransform handleImage(RenderableImage image, Element imageElement, double x, double y, double width, double height, SVGGeneratorContext generatorContext) {
                    return handler.handleImage(image, imageElement, x, y, width, height, generatorContext);
                }

                public AffineTransform handleImage(RenderedImage image, Element imageElement, int x, int y, int width, int height, SVGGeneratorContext generatorContext) {
                    return handler.handleImage(image, imageElement, x, y, width, height, generatorContext);
                }

                public AffineTransform handleImage(Image image, Element imageElement, int x, int y, int width, int height, SVGGeneratorContext generatorContext) {
                    return handler.handleImage(image, imageElement, x, y, width, height, generatorContext);
                }

                public Element createElement(SVGGeneratorContext generatorContext) {
                    Element result = handler.createElement(generatorContext);
                    if (svgTraceability) {
                        result.setAttributeNS("http://www.eclipse.org/sirius/diagram/1.1.0", "diagram:semanticTargetId", currentId);
                    }
                    return result;
                }
            });
        }

        public void setCurrentId(String id) {
            ((AnnotatedSVGShape)this.shapeConverter).setCurrentId(id);
            this.currentId = id;
        }

        public void drawString(String s, float x, float y) {
            Element group;
            Optional currentGroup;
            super.drawString(s, x, y);
            if (this.svgTraceability && (currentGroup = ReflectionHelper.getFieldValueWithoutException((Object)this.domGroupManager, (String)"currentGroup")).isPresent() && currentGroup.get() instanceof Element && (group = (Element)currentGroup.get()).getLastChild() instanceof Element) {
                ((Element)group.getLastChild()).setAttributeNS("http://www.eclipse.org/sirius/diagram/1.1.0", "diagram:semanticTargetId", this.currentId);
            }
        }

        public void drawSVGReference(String uri, int x, int y, int width, int height) {
            Element useElement = this.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "use");
            UUID uuid = SVGImageRegistry.registerUUID(uri);
            useElement.setAttributeNS(null, "fill", "black");
            useElement.setAttributeNS(null, "stroke", "black");
            useElement.setAttributeNS(null, "stroke-width", "0");
            useElement.setAttributeNS(null, "x", this.getGeneratorContext().doubleString((double)x));
            useElement.setAttributeNS(null, "y", this.getGeneratorContext().doubleString((double)y));
            useElement.setAttributeNS(null, "width", this.getGeneratorContext().doubleString((double)width));
            useElement.setAttributeNS(null, "height", this.getGeneratorContext().doubleString((double)height));
            useElement.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "#" + uuid.toString());
            if (this.svgTraceability) {
                useElement.setAttributeNS("http://www.eclipse.org/sirius/diagram/1.1.0", "diagram:semanticTargetId", this.currentId);
            }
            this.domGroupManager.addElement(useElement);
            String attributeNS = useElement.getAttributeNS(null, "clip-path");
            if (!attributeNS.isEmpty()) {
                useElement.removeAttributeNS(null, "clip-path");
            }
        }

        public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
            String attributeNS;
            Optional<SVGOMImageElement> lastImageElement;
            boolean drawImage = super.drawImage(img, x, y, width, height, observer);
            if (drawImage && SiriusDiagramSVGGenerator.isEmbeddedSVGinSVGExportEnabled() && (lastImageElement = this.getLastSVGOMGElement()).isPresent() && !(attributeNS = lastImageElement.get().getAttributeNS(null, "clip-path")).isEmpty()) {
                lastImageElement.get().removeAttributeNS(null, "clip-path");
            }
            return drawImage;
        }

        private Optional<SVGOMImageElement> getLastSVGOMGElement() {
            Optional toplevelGroup = ReflectionHelper.getFieldValueWithoutException((Object)this.domTreeManager, (String)"topLevelGroup");
            if (toplevelGroup.isPresent() && toplevelGroup.get() instanceof Element) {
                return this.getLastSVGOMGElement((Element)toplevelGroup.get());
            }
            return Optional.empty();
        }

        private Optional<SVGOMImageElement> getLastSVGOMGElement(Element element) {
            Node n = element.getLastChild();
            while (n != null) {
                if (n instanceof SVGOMGElement) {
                    Node child = n.getLastChild();
                    while (child != null) {
                        if (child instanceof SVGOMImageElement) {
                            return Optional.of((SVGOMImageElement)child);
                        }
                        child = child.getPreviousSibling();
                    }
                }
                n = n.getPreviousSibling();
            }
            return Optional.empty();
        }
    }
}

