/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.rcptt.properties.propertiestests;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TestEnum implements Enumerator
{
    LITERAL1(0, "Literal1", "Literal1"),
    LITERAL2(1, "Literal2", "Literal2"),
    LITERAL3(2, "Literal3", "Literal3");

    public static final int LITERAL1_VALUE = 0;
    public static final int LITERAL2_VALUE = 1;
    public static final int LITERAL3_VALUE = 2;
    private static final TestEnum[] VALUES_ARRAY;
    public static final List<TestEnum> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TestEnum[]{LITERAL1, LITERAL2, LITERAL3};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TestEnum get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TestEnum result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TestEnum getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TestEnum result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TestEnum get(int value) {
        switch (value) {
            case 0: {
                return LITERAL1;
            }
            case 1: {
                return LITERAL2;
            }
            case 2: {
                return LITERAL3;
            }
        }
        return null;
    }

    private TestEnum(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

