/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p4nodes;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.math.DoubleMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.eclipse.elk.alg.common.networksimplex.NEdge;
import org.eclipse.elk.alg.common.networksimplex.NGraph;
import org.eclipse.elk.alg.common.networksimplex.NNode;
import org.eclipse.elk.alg.common.networksimplex.NetworkSimplex;
import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphElement;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.LShape;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.options.GraphProperties;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.NodeFlexibility;
import org.eclipse.elk.alg.layered.options.Spacings;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.ILayoutProcessorFactory;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.math.ElkMargin;
import org.eclipse.elk.core.options.NodeLabelPlacement;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class NetworkSimplexPlacer
implements ILayoutPhase<LayeredPhases, LGraph> {
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> HIERARCHY_PROCESSING_ADDITIONS = LayoutProcessorConfiguration.create().addBefore((Enum)LayeredPhases.P5_EDGE_ROUTING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.HIERARCHICAL_PORT_POSITION_PROCESSOR);
    private LGraph lGraph;
    private Spacings spacings;
    private NGraph nGraph;
    private NodeRep[] nodeReps;
    private EdgeRep[] edgeReps;
    private Map<LGraphElement, NNode> portMap = Maps.newHashMap();
    private int nodeCount;
    private int edgeCount;
    private int[] nodeState;
    private List<Path> twoPaths;
    private boolean[] crossing;
    private Set<NEdge> flexibleWhereSpacePermitsEdges = Sets.newHashSet();
    private static final double EDGE_WEIGHT_BASE = 4.0;
    private static final double SMALL_EDGE_WEIGHT = 0.1;
    private static final double LONG_EDGE_VS_PATH_FACTOR = 2.0;
    private static final double NODE_SIZE_WEIGHT_STATIC = 10000.0;
    private static final double NODE_SIZE_WEIGHT_FLEXIBLE = 1.0;
    private static final double EPSILON = 1.0E-5;
    private static final int VISITED = -1;
    private static final int OTHER = 0;
    private static final int JUNCTION = 2;

    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        if (((Set)graph.getProperty(InternalProperties.GRAPH_PROPERTIES)).contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            return HIERARCHY_PROCESSING_ADDITIONS;
        }
        return null;
    }

    public void process(LGraph layeredGraph, IElkProgressMonitor progressMonitor) {
        IElkProgressMonitor pm;
        progressMonitor.begin("Network simplex node placement", 1.0f);
        this.lGraph = layeredGraph;
        this.spacings = (Spacings)layeredGraph.getProperty(InternalProperties.SPACINGS);
        this.prepare();
        this.buildInitialAuxiliaryGraph();
        this.insertNorthSouthAuxiliaryEdges();
        this.insertInLayerEdgeAuxiliaryEdges();
        if (((Boolean)this.lGraph.getProperty(LayeredOptions.NODE_PLACEMENT_FAVOR_STRAIGHT_EDGES)).booleanValue()) {
            IElkProgressMonitor pm2 = progressMonitor.subTask(1.0f);
            pm2.begin("Straight Edges Pre-Processing", 1.0f);
            this.preferStraightEdges();
            pm2.done();
        }
        this.nGraph.makeConnected();
        int iterLimit = (Integer)layeredGraph.getProperty(LayeredOptions.THOROUGHNESS) * this.nGraph.nodes.size();
        NetworkSimplex.forGraph((NGraph)this.nGraph).withIterationLimit(iterLimit).withBalancing(false).execute(progressMonitor.subTask(1.0f));
        if (!this.flexibleWhereSpacePermitsEdges.isEmpty()) {
            pm = progressMonitor.subTask(1.0f);
            pm.begin("Flexible Where Space Processing", 1.0f);
            this.insertFlexibleWhereSpaceAuxiliaryEdges();
            for (NEdge edge : this.flexibleWhereSpacePermitsEdges) {
                edge.weight = 1.0;
            }
            NetworkSimplex.forGraph((NGraph)this.nGraph).withIterationLimit(iterLimit).withBalancing(false).execute(pm.subTask(1.0f));
            pm.done();
        }
        if (((Boolean)layeredGraph.getProperty(LayeredOptions.NODE_PLACEMENT_FAVOR_STRAIGHT_EDGES)).booleanValue()) {
            pm = progressMonitor.subTask(1.0f);
            pm.begin("Straight Edges Post-Processing", 1.0f);
            this.postProcessTwoPaths();
            pm.done();
        }
        this.applyPositions();
        this.cleanup();
        progressMonitor.done();
    }

    private void prepare() {
        this.nGraph = new NGraph();
        int nodeIdx = 0;
        int edgeIdx = 0;
        for (Layer l : this.lGraph) {
            for (LNode lNode : l) {
                lNode.id = nodeIdx++;
                for (LEdge e : lNode.getOutgoingEdges()) {
                    e.id = edgeIdx++;
                }
                boolean anchorMustBeInteger = NetworkSimplexPlacer.isFlexibleNode(lNode);
                for (LPort p : lNode.getPorts()) {
                    double offset;
                    double y;
                    if (anchorMustBeInteger && (y = p.getAnchor().y) != Math.floor(y)) {
                        offset = y - (double)Math.round(y);
                        p.getAnchor().y -= offset;
                    }
                    if ((y = p.getPosition().y + p.getAnchor().y) == Math.floor(y)) continue;
                    offset = y - (double)Math.round(y);
                    p.getPosition().y -= offset;
                }
            }
        }
        this.nodeCount = nodeIdx;
        this.edgeCount = edgeIdx;
        this.nodeReps = new NodeRep[nodeIdx];
        this.edgeReps = new EdgeRep[edgeIdx];
        this.flexibleWhereSpacePermitsEdges.clear();
    }

    private void cleanup() {
        this.lGraph = null;
        this.nGraph = null;
        this.nodeReps = null;
        this.edgeReps = null;
        this.portMap.clear();
        this.nodeState = null;
        this.crossing = null;
        this.twoPaths = null;
        this.flexibleWhereSpacePermitsEdges.clear();
    }

    private void buildInitialAuxiliaryGraph() {
        for (Layer l : this.lGraph) {
            this.transformLayer(l);
        }
        this.transformEdges();
    }

    private void transformLayer(Layer layer) {
        NodeRep lastRep = null;
        for (LNode lNode : layer) {
            NodeRep nodeRep = NetworkSimplexPlacer.isFlexibleNode(lNode) ? this.transformFixedOrderNode(lNode) : this.transformFixedPosNode(lNode);
            this.nodeReps[lNode.id] = nodeRep;
            if (lastRep != null) {
                double spacing = lastRep.origin.getMargin().bottom + this.spacings.getVerticalSpacing(lastRep.origin, lNode) + lNode.getMargin().top;
                if (!lastRep.isFlexible) {
                    spacing += lastRep.origin.getSize().y;
                }
                NEdge.of().delta((int)Math.ceil(spacing)).weight(0.0).source(lastRep.tail).target(nodeRep.head).create();
            }
            lastRep = nodeRep;
        }
    }

    private NodeRep transformFixedPosNode(LNode lNode) {
        NNode singleNode = NNode.of().origin((Object)lNode).type("non-flexible").create(this.nGraph);
        lNode.getPorts().stream().filter(p -> PortSide.SIDES_EAST_WEST.contains(p.getSide())).forEach(p -> {
            NNode nNode2 = this.portMap.put((LGraphElement)((Object)p), singleNode);
        });
        return new NodeRep(lNode, false, singleNode, singleNode);
    }

    private NodeRep transformFixedOrderNode(LNode lNode) {
        NNode topLeft = NNode.of().origin((Object)lNode).type("flexible-head").create(this.nGraph);
        NNode bottomLeft = NNode.of().origin((Object)lNode).type("flexible-tail").create(this.nGraph);
        NodeRep corners = new NodeRep(lNode, true, topLeft, bottomLeft);
        double minHeight = lNode.getSize().y;
        NodeFlexibility nf = NodeFlexibility.getNodeFlexibility(lNode);
        double sizeWeight = 10000.0;
        if (nf.isFlexibleSize()) {
            sizeWeight = 1.0;
        }
        NEdge nodeSizeEdge = NEdge.of().weight(sizeWeight).delta((int)Math.ceil(minHeight)).source(topLeft).target(bottomLeft).create();
        if (nf == NodeFlexibility.NODE_SIZE_WHERE_SPACE_PERMITS) {
            this.flexibleWhereSpacePermitsEdges.add(nodeSizeEdge);
        }
        this.transformPorts(Lists.reverse(lNode.getPortSideView(PortSide.WEST)), corners);
        this.transformPorts(lNode.getPortSideView(PortSide.EAST), corners);
        return corners;
    }

    private void transformPorts(Iterable<LPort> ports, NodeRep corners) {
        if (Iterables.isEmpty(ports)) {
            return;
        }
        double portSpacing = Spacings.getIndividualOrDefault(corners.origin, LayeredOptions.SPACING_PORT_PORT);
        ElkMargin portSurrounding = Spacings.getIndividualOrDefault(corners.origin, LayeredOptions.SPACING_PORTS_SURROUNDING);
        if (portSurrounding == null) {
            portSurrounding = new ElkMargin();
        }
        NNode lastNNode = corners.head;
        LShape lastPort = null;
        for (LPort port : ports) {
            double spacing = 0.0;
            if (lastPort == null) {
                spacing = portSurrounding.top;
            } else {
                spacing = portSpacing;
                spacing += lastPort.getSize().y;
            }
            NNode nNode = NNode.of().origin((Object)port).type("port").create(this.nGraph);
            this.portMap.put(port, nNode);
            NEdge.of().weight(0.0).delta((int)Math.ceil(spacing)).source(lastNNode).target(nNode).create();
            lastPort = port;
            lastNNode = nNode;
        }
        NEdge.of().weight(0.0).delta((int)Math.ceil(portSurrounding.bottom + lastPort.getSize().y)).source(lastNNode).target(corners.tail).create();
    }

    private void transformEdges() {
        this.lGraph.getLayers().stream().flatMap(layer -> layer.getNodes().stream()).flatMap(node -> StreamSupport.stream(node.getOutgoingEdges().spliterator(), false)).filter(e -> NetworkSimplexPlacer.isHandledEdge(e)).forEach(e -> this.transformEdge((LEdge)((Object)e)));
    }

    private void transformEdge(LEdge lEdge) {
        EdgeRep edgeRep;
        NNode dummy = NNode.of().type("edge").create(this.nGraph);
        NodeRep srcRep = this.nodeReps[lEdge.getSource().getNode().id];
        NodeRep tgtRep = this.nodeReps[lEdge.getTarget().getNode().id];
        LPort srcPort = lEdge.getSource();
        LPort tgtPort = lEdge.getTarget();
        double srcOffset = srcPort.getAnchor().y;
        double tgtOffset = tgtPort.getAnchor().y;
        if (!srcRep.isFlexible) {
            srcOffset += srcPort.getPosition().y;
        }
        if (!tgtRep.isFlexible) {
            tgtOffset += tgtPort.getPosition().y;
        }
        assert (DoubleMath.fuzzyEquals((double)(srcOffset - tgtOffset), (double)Math.round(srcOffset - tgtOffset), (double)1.0E-5)) : "Port positions must be integral";
        int tgtDelta = (int)Math.max(0.0, srcOffset - tgtOffset);
        int srcDelta = (int)Math.max(0.0, tgtOffset - srcOffset);
        double weight = this.getEdgeWeight(lEdge);
        NEdge left = NEdge.of((Object)((Object)lEdge)).weight(weight).delta(srcDelta).source(dummy).target(this.portMap.get((Object)lEdge.getSource())).create();
        NEdge right = NEdge.of((Object)((Object)lEdge)).weight(weight).delta(tgtDelta).source(dummy).target(this.portMap.get((Object)lEdge.getTarget())).create();
        this.edgeReps[lEdge.id] = edgeRep = new EdgeRep(lEdge, dummy, left, right);
    }

    private void insertInLayerEdgeAuxiliaryEdges() {
        this.lGraph.getLayers().stream().flatMap(l -> l.getNodes().stream()).filter(n -> n.getType() == LNode.NodeType.NORMAL).flatMap(n -> StreamSupport.stream(n.getConnectedEdges().spliterator(), false)).filter(e -> e.isInLayerEdge()).forEach(inLayerEdge -> {
            NNode tgt;
            NNode src;
            boolean srcIsDummy = inLayerEdge.getSource().getNode().getType() != LNode.NodeType.NORMAL;
            LPort thePort = srcIsDummy ? inLayerEdge.getTarget() : inLayerEdge.getSource();
            LNode dummyNode = inLayerEdge.getOther(thePort).getNode();
            NNode portRep = this.portMap.get((Object)thePort);
            NNode dummyRep = this.nodeReps[dummyNode.id].head;
            if (thePort.getNode().getIndex() < dummyNode.getIndex()) {
                src = portRep;
                tgt = dummyRep;
            } else {
                src = dummyRep;
                tgt = portRep;
            }
            NEdge.of().delta(0).weight(4.0).source(src).target(tgt).create();
        });
    }

    private void insertNorthSouthAuxiliaryEdges() {
        this.lGraph.getLayers().stream().flatMap(l -> l.getNodes().stream()).forEach(n -> {
            LNode other;
            for (LPort sp : n.getPortSideView(PortSide.SOUTH)) {
                other = (LNode)((Object)((Object)sp.getProperty(InternalProperties.PORT_DUMMY)));
                if (other == null) continue;
                NEdge.of().delta(0).weight(0.1).source(this.nodeReps[n.id].tail).target(this.nodeReps[other.id].head).create();
            }
            for (LPort sp : n.getPortSideView(PortSide.NORTH)) {
                other = (LNode)((Object)((Object)sp.getProperty(InternalProperties.PORT_DUMMY)));
                if (other == null) continue;
                NEdge.of().delta(0).weight(0.1).source(this.nodeReps[other.id].tail).target(this.nodeReps[n.id].head).create();
            }
        });
    }

    private void insertFlexibleWhereSpaceAuxiliaryEdges() {
        int minLayer = this.nGraph.nodes.stream().map(n -> n.layer).min(Integer::compare).get();
        int maxLayer = this.nGraph.nodes.stream().map(n -> n.layer).max(Integer::compare).get();
        int usedLayers = maxLayer - minLayer;
        NNode globalSource = NNode.of().create(this.nGraph);
        NNode globalSink = NNode.of().create(this.nGraph);
        NEdge.of().weight(20000.0).delta(usedLayers).source(globalSource).target(globalSink).create();
        Arrays.stream(this.nodeReps).filter(nr -> nr.origin.getType() == LNode.NodeType.NORMAL).filter(nr -> nr.origin.getPorts().size() > 1).forEach(nr -> {
            NEdge.of().weight(0.0).delta(nr.tail.layer - minLayer).source(globalSource).target(nr.tail).create();
            NEdge.of().weight(0.0).delta(usedLayers - nr.head.layer).source(nr.head).target(globalSink).create();
        });
    }

    private void applyPositions() {
        for (Layer l : this.lGraph) {
            for (LNode lNode : l) {
                NodeRep nodeRep = this.nodeReps[lNode.id];
                double minY = nodeRep.head.layer;
                double maxY = nodeRep.tail.layer;
                lNode.getPosition().y = minY;
                double sizeDelta = maxY - minY - lNode.getSize().y;
                boolean flexibleNode = NetworkSimplexPlacer.isFlexibleNode(lNode);
                NodeFlexibility nf = NodeFlexibility.getNodeFlexibility(lNode);
                if (flexibleNode && nf.isFlexibleSizeWhereSpacePermits()) {
                    lNode.getSize().y += sizeDelta;
                }
                if (!flexibleNode || !nf.isFlexiblePorts()) continue;
                for (LPort p2 : lNode.getPorts()) {
                    if (!PortSide.SIDES_EAST_WEST.contains(p2.getSide())) continue;
                    NNode nNode = this.portMap.get((Object)p2);
                    p2.getPosition().y = (double)nNode.layer - minY;
                }
                for (LLabel label : lNode.getLabels()) {
                    this.adjustLabelPosition(lNode, label, sizeDelta);
                }
                if (!nf.isFlexibleSizeWhereSpacePermits()) continue;
                lNode.getPortSideView(PortSide.SOUTH).forEach(p -> {
                    double d2 = p.getPosition().y = p.getPosition().y + sizeDelta;
                });
            }
        }
    }

    private void adjustLabelPosition(LNode node, LLabel label, double sizeDelta) {
        Set placement = (Set)node.getProperty(LayeredOptions.NODE_LABELS_PLACEMENT);
        if (placement.contains(NodeLabelPlacement.V_BOTTOM)) {
            label.getPosition().y += sizeDelta;
        } else if (placement.contains(NodeLabelPlacement.V_CENTER)) {
            label.getPosition().y += sizeDelta / 2.0;
        }
    }

    private double getEdgeWeight(LEdge edge) {
        int priority = Math.max(1, (Integer)edge.getProperty(LayeredOptions.PRIORITY_STRAIGHTNESS));
        double edgeTypeWeight = this.getEdgeWeight(edge.getSource().getNode().getType(), edge.getTarget().getNode().getType());
        return (double)priority * edgeTypeWeight;
    }

    private double getEdgeWeight(LNode.NodeType nodeType1, LNode.NodeType nodeType2) {
        if (nodeType1 == LNode.NodeType.NORMAL && nodeType2 == LNode.NodeType.NORMAL) {
            return 4.0;
        }
        if (nodeType1 == LNode.NodeType.NORMAL || nodeType2 == LNode.NodeType.NORMAL) {
            return 8.0;
        }
        return 32.0;
    }

    private static boolean isHandledEdge(LEdge edge) {
        return !edge.isSelfLoop() && !edge.isInLayerEdge();
    }

    public static boolean isFlexibleNode(LNode lNode) {
        if (lNode.getType() != LNode.NodeType.NORMAL) {
            return false;
        }
        if (lNode.getPorts().size() <= 1) {
            return false;
        }
        PortConstraints pc = (PortConstraints)lNode.getProperty(LayeredOptions.PORT_CONSTRAINTS);
        if (pc.isPosFixed()) {
            return false;
        }
        NodeFlexibility nf = NodeFlexibility.getNodeFlexibility(lNode);
        if (nf == NodeFlexibility.NONE) {
            return false;
        }
        if (!nf.isFlexibleSizeWhereSpacePermits()) {
            List<LPort> westPorts;
            double requiredWestHeight;
            double portSpacing = Spacings.getIndividualOrDefault(lNode, LayeredOptions.SPACING_PORT_PORT);
            ElkMargin additionalPortSpacing = (ElkMargin)lNode.getProperty(LayeredOptions.SPACING_PORTS_SURROUNDING);
            if (additionalPortSpacing == null) {
                additionalPortSpacing = new ElkMargin(portSpacing, portSpacing, portSpacing, portSpacing);
            }
            if ((requiredWestHeight = additionalPortSpacing.top + additionalPortSpacing.bottom + (double)((westPorts = lNode.getPortSideView(PortSide.WEST)).size() - 1) * portSpacing) > lNode.getSize().y) {
                return false;
            }
            List<LPort> eastPorts = lNode.getPortSideView(PortSide.EAST);
            double requiredEastHeight = additionalPortSpacing.top + additionalPortSpacing.bottom + (double)(eastPorts.size() - 1) * portSpacing;
            if (requiredEastHeight > lNode.getSize().y) {
                return false;
            }
        }
        return true;
    }

    private void preferStraightEdges() {
        this.nodeState = new int[this.nodeCount];
        this.twoPaths = Lists.newArrayList();
        this.lGraph.getLayers().stream().flatMap(l -> l.getNodes().stream()).forEach(n -> {
            int n2 = NetworkSimplexPlacer.getNodeState(n);
        });
        this.markEdgeCrossings();
        List<Path> identifiedPaths = this.identifyPaths();
        for (Path path : identifiedPaths) {
            if (path.size() <= 1) continue;
            if (path.size() == 2) {
                path.orderTwoPath();
                if (path.isTwoPathCenterNodeFlexible()) continue;
                this.twoPaths.add(path);
                continue;
            }
            if (path.containsLongEdgeDummy() || path.containsFlexibleNode(nf -> nf.isFlexibleSizeWhereSpacePermits())) continue;
            Iterator pathIt = path.iterator();
            LEdge last = null;
            while (pathIt.hasNext()) {
                LEdge cur = (LEdge)((Object)pathIt.next());
                EdgeRep curRep = this.edgeReps[cur.id];
                double weight = last == null || !pathIt.hasNext() ? this.getEdgeWeight(LNode.NodeType.NORMAL, LNode.NodeType.LONG_EDGE) : this.getEdgeWeight(LNode.NodeType.LONG_EDGE, LNode.NodeType.LONG_EDGE);
                double oldLeftWeight = curRep.left.weight;
                curRep.left.weight = Math.max(oldLeftWeight, oldLeftWeight + ((weight *= 2.0) - oldLeftWeight));
                double oldRightWeight = curRep.right.weight;
                curRep.right.weight = Math.max(oldRightWeight, oldRightWeight + (weight - oldRightWeight));
                last = cur;
            }
        }
    }

    private void postProcessTwoPaths() {
        Path path;
        LinkedList q = Lists.newLinkedList();
        q.addAll(this.twoPaths);
        Stack<Path> s = new Stack<Path>();
        while (!q.isEmpty()) {
            path = (Path)q.poll();
            boolean tryAgain = this.improveTwoPath(path, true);
            if (!tryAgain) continue;
            s.add(path);
        }
        while (!s.isEmpty()) {
            path = (Path)s.pop();
            this.improveTwoPath(path, false);
        }
    }

    private boolean improveTwoPath(Path path, boolean probe) {
        EdgeRep leftEdge = this.edgeReps[((LEdge)((Object)path.get((int)0))).id];
        EdgeRep rightEdge = this.edgeReps[((LEdge)((Object)path.get((int)1))).id];
        if (leftEdge.isStraight() && rightEdge.isStraight()) {
            return false;
        }
        Object centerOrigin = leftEdge.right.target.origin;
        if (!(centerOrigin instanceof LNode)) {
            return false;
        }
        assert (centerOrigin instanceof LNode);
        LNode centerNode = (LNode)((Object)centerOrigin);
        NodeRep nNode = this.nodeReps[centerNode.id];
        int nodeIndex = centerNode.getIndex();
        double aboveDist = Double.POSITIVE_INFINITY;
        if (nodeIndex > 0) {
            LNode above = centerNode.getLayer().getNodes().get(nodeIndex - 1);
            NodeRep aboveRep = this.nodeReps[above.id];
            double spacing = Math.ceil(this.spacings.getVerticalSpacing(above, centerNode));
            aboveDist = (double)nNode.head.layer - centerNode.getMargin().top - ((double)aboveRep.head.layer + above.getSize().y + above.getMargin().bottom) - spacing;
        }
        double belowDist = Double.POSITIVE_INFINITY;
        if (nodeIndex < centerNode.getLayer().getNodes().size() - 1) {
            LNode below = centerNode.getLayer().getNodes().get(nodeIndex + 1);
            NodeRep belowRep = this.nodeReps[below.id];
            double spacing = Math.ceil(this.spacings.getVerticalSpacing(below, centerNode));
            belowDist = (double)belowRep.head.layer - below.getMargin().top - ((double)nNode.head.layer + centerNode.getSize().y + centerNode.getMargin().bottom) - spacing;
        }
        if (probe && DoubleMath.fuzzyEquals((double)aboveDist, (double)belowDist, (double)1.0E-5)) {
            return true;
        }
        int a = NetworkSimplexPlacer.length(leftEdge.left);
        int b = -NetworkSimplexPlacer.length(leftEdge.right);
        int c = -NetworkSimplexPlacer.length(rightEdge.left);
        int d = NetworkSimplexPlacer.length(rightEdge.right);
        boolean caseD = leftEdge.notStraightBy() > 0 && rightEdge.notStraightBy() < 0;
        boolean caseC = leftEdge.notStraightBy() < 0 && rightEdge.notStraightBy() > 0;
        boolean caseB = leftEdge.left.target.layer + leftEdge.right.delta < rightEdge.right.target.layer + rightEdge.left.delta;
        boolean caseA = leftEdge.left.target.layer + leftEdge.right.delta > rightEdge.right.target.layer + rightEdge.left.delta;
        int move = 0;
        if (!caseD && !caseC) {
            if (caseA) {
                if (aboveDist + (double)c > 0.0) {
                    move = c;
                } else if (belowDist - (double)a > 0.0) {
                    move = a;
                }
            } else if (caseB) {
                if (aboveDist + (double)b > 0.0) {
                    move = b;
                } else if (belowDist - (double)d > 0.0) {
                    move = d;
                }
            }
        }
        nNode.head.layer += move;
        if (nNode.isFlexible) {
            nNode.tail.layer += move;
        }
        return false;
    }

    private static int length(NEdge edge) {
        return Math.abs(edge.source.layer - edge.target.layer) - edge.delta;
    }

    private List<Path> identifyPaths() {
        ArrayList paths = Lists.newArrayList();
        this.lGraph.getLayers().stream().flatMap(l -> l.getNodes().stream()).filter(n -> this.nodeState[n.id] == 2).forEach(junction -> {
            for (LEdge e : junction.getConnectedEdges()) {
                Path path;
                if (!NetworkSimplexPlacer.isHandledEdge(e) || (path = this.follow(e, (LNode)((Object)junction), new Path())).size() <= 1) continue;
                paths.add(path);
            }
        });
        return paths;
    }

    private Path follow(LEdge edge, LNode current, Path path) {
        LNode other = edge.getOther(current);
        path.add(edge);
        if (this.nodeState[other.id] == -1 || this.nodeState[other.id] == 2 || this.crossing[edge.id]) {
            return path;
        }
        this.nodeState[other.id] = -1;
        for (LEdge incident : other.getConnectedEdges()) {
            if (!NetworkSimplexPlacer.isHandledEdge(incident) || incident == edge) continue;
            return this.follow(incident, other, path);
        }
        return path;
    }

    private static int getNodeState(LNode node) {
        int inco = 0;
        int ouco = 0;
        for (LPort p : node.getPorts()) {
            inco = (int)((long)inco + p.getIncomingEdges().stream().filter(e -> !e.isSelfLoop()).count());
            ouco = (int)((long)ouco + p.getOutgoingEdges().stream().filter(e -> !e.isSelfLoop()).count());
            if (inco <= 1 && ouco <= 1) continue;
            return 2;
        }
        if (inco + ouco == 1) {
            return 2;
        }
        return 0;
    }

    private void markEdgeCrossings() {
        this.crossing = new boolean[this.edgeCount];
        this.lGraph.getLayers().stream().reduce((left, right) -> {
            this.markCrossingEdges((Layer)left, (Layer)right);
            return right;
        });
    }

    private void markCrossingEdges(Layer left, Layer right) {
        ArrayList openEdges = Lists.newArrayList();
        for (LNode node : left) {
            for (LPort port : node.getPortSideView(PortSide.EAST)) {
                for (LEdge edge : port.getOutgoingEdges()) {
                    if (edge.isInLayerEdge() || edge.isSelfLoop() || edge.getTarget().getNode().getLayer() != right) continue;
                    openEdges.add(edge);
                }
            }
        }
        for (LNode node : Lists.reverse(right.getNodes())) {
            for (LPort port : node.getPortSideView(PortSide.WEST)) {
                for (LEdge edge : port.getIncomingEdges()) {
                    if (edge.isInLayerEdge() || edge.isSelfLoop() || edge.getSource().getNode().getLayer() != left) continue;
                    ListIterator openEdgesIt = openEdges.listIterator(openEdges.size());
                    LEdge last = (LEdge)((Object)openEdgesIt.previous());
                    while (last != edge && openEdgesIt.hasPrevious()) {
                        this.crossing[last.id] = true;
                        this.crossing[edge.id] = true;
                        last = (LEdge)((Object)openEdgesIt.previous());
                    }
                    if (!openEdgesIt.hasPrevious()) continue;
                    openEdgesIt.remove();
                }
            }
        }
    }

    private static class EdgeRep {
        public LEdge origin;
        public NEdge left;
        public NEdge right;

        EdgeRep(LEdge origin, NNode dummy, NEdge left, NEdge right) {
            this.origin = origin;
            this.left = left;
            this.right = right;
        }

        public boolean isStraight() {
            return this.notStraightBy() == 0;
        }

        public int notStraightBy() {
            return this.left.target.layer - this.left.delta - (this.right.target.layer - this.right.delta);
        }
    }

    private static class NodeRep {
        public LNode origin;
        public NNode head;
        public NNode tail;
        public boolean isFlexible;

        NodeRep(LNode origin, boolean isFlexible, NNode top, NNode bottom) {
            this.origin = origin;
            this.isFlexible = isFlexible;
            this.head = top;
            this.tail = bottom;
        }
    }

    private static class Path
    extends ArrayList<LEdge> {
        private Path() {
        }

        public boolean containsLongEdgeDummy() {
            if (this.isEmpty()) {
                return false;
            }
            if (((LEdge)((Object)this.get(0))).getSource().getNode().getType() == LNode.NodeType.LONG_EDGE) {
                return true;
            }
            return this.stream().map(e -> e.getTarget().getNode().getType()).anyMatch(t -> t == LNode.NodeType.LONG_EDGE);
        }

        public boolean containsFlexibleNode(Predicate<NodeFlexibility> p) {
            if (this.isEmpty()) {
                return false;
            }
            NodeFlexibility nf = NodeFlexibility.getNodeFlexibility(((LEdge)((Object)this.get(0))).getSource().getNode());
            if (p.test(nf)) {
                return true;
            }
            return this.stream().map(e -> e.getTarget().getNode()).anyMatch(n -> p.test(NodeFlexibility.getNodeFlexibility(n)));
        }

        public void orderTwoPath() {
            if (this.size() != 2) {
                throw new IllegalStateException("Order only allowed for two paths.");
            }
            LEdge first = (LEdge)((Object)this.get(0));
            LEdge second = (LEdge)((Object)this.get(1));
            if (first.getTarget().getNode() != second.getSource().getNode()) {
                this.clear();
                this.add(second);
                this.add(first);
            }
        }

        public boolean isTwoPathCenterNodeFlexible() {
            return NetworkSimplexPlacer.isFlexibleNode(((LEdge)((Object)this.get(0))).getTarget().getNode());
        }
    }
}

