/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.util;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;

public final class BendpointsHelper {
    private BendpointsHelper() {
    }

    public static boolean areSameBendpoints(Object oldValue, Object newValue) {
        boolean isTouch = false;
        if (oldValue instanceof Collection && newValue instanceof Collection) {
            ArrayList newPoints = Lists.newArrayList((Iterable)Iterables.filter((Iterable)((Collection)newValue), RelativeBendpoint.class));
            ArrayList oldPoints = Lists.newArrayList((Iterable)Iterables.filter((Iterable)((Collection)oldValue), RelativeBendpoint.class));
            if (newPoints.size() == oldPoints.size()) {
                isTouch = true;
                int i = 0;
                while (i < newPoints.size()) {
                    boolean targetTouch;
                    RelativeBendpoint newPoint = (RelativeBendpoint)newPoints.get(i);
                    RelativeBendpoint oldPoint = (RelativeBendpoint)oldPoints.get(i);
                    boolean sourceTouch = newPoint.getSourceX() == oldPoint.getSourceX() && newPoint.getSourceY() == oldPoint.getSourceY();
                    boolean bl = targetTouch = newPoint.getTargetX() == oldPoint.getTargetX() && newPoint.getTargetY() == oldPoint.getTargetY();
                    if (!sourceTouch || !targetTouch) {
                        isTouch = false;
                        break;
                    }
                    ++i;
                }
            }
        }
        return isTouch;
    }
}

