/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.dialogs.widgets.gallery;

import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.widgets.gallery.DefaultGalleryGroupRenderer;
import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.widgets.gallery.DefaultGalleryItemRenderer;
import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.widgets.gallery.Gallery;
import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.widgets.gallery.GalleryItem;
import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.widgets.gallery.ListItemRenderer;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public final class GalleryRendererUtils {
    static final int THUMBNAIL_IMAGE_WIDTH = 80;
    static final int THUMBNAIL_IMAGE_HEIGHT = 80;
    private static final int LIST_ITEM_HEIGHT = 32;

    private GalleryRendererUtils() {
    }

    public static void setStandardGallery(Composite parent, Gallery gallery) {
        DefaultGalleryGroupRenderer gr = new DefaultGalleryGroupRenderer(){

            @Override
            protected String getGroupTitle(GalleryItem group) {
                return new String();
            }

            @Override
            protected int getGroupHeight(GalleryItem group) {
                return 0;
            }
        };
        gr.setMinMargin(2);
        gr.setItemHeight(80);
        gr.setItemWidth(80);
        gr.setAutoMargin(true);
        gr.setAlwaysExpanded(true);
        gallery.setGroupRenderer(gr);
        DefaultGalleryItemRenderer itemRenderer = new DefaultGalleryItemRenderer();
        itemRenderer.setShowLabels(true);
        gallery.setItemRenderer(itemRenderer);
        GalleryRendererUtils.configureTooltips(gallery);
    }

    public static void setListGallery(Composite parent, Gallery gallery) {
        DefaultGalleryGroupRenderer gr = new DefaultGalleryGroupRenderer(){

            @Override
            protected String getGroupTitle(GalleryItem group) {
                return new String();
            }

            @Override
            protected int getGroupHeight(GalleryItem group) {
                return 0;
            }

            @Override
            public void preLayout(GC gc) {
                this.itemWidth = this.gallery.getClientArea().width - this.margin;
                super.preLayout(gc);
            }
        };
        gr.setItemHeight(32);
        gr.setMinMargin(0);
        gr.setAutoMargin(false);
        gr.setAlwaysExpanded(true);
        gallery.setGroupRenderer(gr);
        ListItemRenderer itemRenderer = new ListItemRenderer();
        itemRenderer.setShowLabels(true);
        gallery.setItemRenderer(itemRenderer);
        GalleryRendererUtils.configureTooltips(gallery);
    }

    private static void configureTooltips(Gallery gallery) {
        gallery.setToolTipText("");
        TooltipMouseListener tableListener = new TooltipMouseListener(gallery);
        gallery.addListener(12, tableListener);
        gallery.addListener(1, tableListener);
        gallery.addListener(5, tableListener);
        gallery.addListener(32, tableListener);
    }

    private static class TooltipMouseListener
    implements Listener {
        Shell tip;
        Label label;
        private Gallery gallery;

        TooltipMouseListener(Gallery gallery) {
            this.gallery = gallery;
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 1: 
                case 5: 
                case 12: {
                    if (this.tip == null) break;
                    this.tip.dispose();
                    this.tip = null;
                    this.label = null;
                    break;
                }
                case 32: {
                    GalleryItem item = this.gallery.getItem(new Point(event.x, event.y));
                    if (item == null) break;
                    if (this.tip != null && !this.tip.isDisposed()) {
                        this.tip.dispose();
                    }
                    Shell shell = this.gallery.getShell();
                    Display display = shell.getDisplay();
                    this.tip = new Shell(shell, 540676);
                    this.tip.setBackground(display.getSystemColor(29));
                    FillLayout layout = new FillLayout();
                    layout.marginWidth = 2;
                    this.tip.setLayout((Layout)layout);
                    this.label = new Label((Composite)this.tip, 0);
                    this.label.setForeground(display.getSystemColor(28));
                    this.label.setBackground(display.getSystemColor(29));
                    this.label.setData("_TABLEITEM", (Object)item);
                    this.label.setText(item.getText());
                    Point size = this.tip.computeSize(-1, -1);
                    Point pt = this.gallery.toDisplay(event.x, event.y + 16);
                    this.tip.setBounds(pt.x, pt.y, size.x, size.y);
                    this.tip.setVisible(true);
                    break;
                }
            }
        }
    }
}

