/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.condition;

import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.SiriusNoteEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.SiriusTextEditPart;
import org.eclipse.sirius.tests.swtbot.support.api.editor.SWTBotSiriusDiagramEditor;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.waits.ICondition;

public class TextEditorAppearedCondition
implements ICondition {
    private SWTBotSiriusDiagramEditor editor;
    private Class<? extends IGraphicalEditPart> editPartClass;
    private String precondition;
    private String errorMessage;

    public TextEditorAppearedCondition(SWTBotSiriusDiagramEditor editor, Class<? extends IGraphicalEditPart> editPartClass, String precondition) {
        this.editor = editor;
        this.editPartClass = editPartClass;
        this.precondition = precondition;
    }

    public boolean test() throws Exception {
        boolean result = false;
        try {
            this.editor.bot().text();
            result = true;
        }
        catch (WidgetNotFoundException e) {
            if (this.editPartClass.equals(SiriusNoteEditPart.class) || this.editPartClass.equals(SiriusTextEditPart.class)) {
                this.errorMessage = "The selected element is expected to be in direct edit mode but was not: " + e.getMessage();
            }
            if (!"[false/]".equals(this.precondition)) {
                this.errorMessage = "The direct edit mode is not accessible while there is no precondition.";
            }
            result = true;
        }
        return result;
    }

    public void init(SWTBot bot) {
    }

    public String getFailureMessage() {
        return this.errorMessage;
    }
}

