/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.sirius.diagram.description.tool.RequestDescription;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.ui.business.internal.query.RequestQuery;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.CreationUtil;
import org.eclipse.sirius.diagram.ui.tools.api.draw2d.ui.figures.FigureUtilities;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.PaneBasedSelectionWizardDescription;
import org.eclipse.sirius.viewpoint.description.tool.SelectionWizardDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolDescription;

public class LaunchToolEditPolicy
extends AbstractEditPolicy {
    public EditPart getTargetEditPart(Request request) {
        return this.understandsRequest(request) ? this.getHost() : null;
    }

    public boolean understandsRequest(Request request) {
        return "create child".equals(request.getType());
    }

    public Command getCommand(Request request) {
        Command result = "create child".equals(request.getType()) && request instanceof CreateRequest ? this.getCreateCommand((CreateRequest)request) : super.getCommand(request);
        return result;
    }

    protected Command getCreateCommand(CreateRequest request) {
        return this.createCommandFromRequest(request, this.getRealLocation(request), this.getHost());
    }

    protected Point getRealLocation(CreateRequest request) {
        Point realLocation;
        Point location = request.getLocation().getCopy();
        if (location != null && this.getHost() instanceof GraphicalEditPart) {
            IFigure fig = ((GraphicalEditPart)this.getHost()).getFigure();
            fig.translateToRelative((Translatable)location);
            Point containerLocation = fig.getBounds().getLocation();
            location = new Point(location.x - containerLocation.x, location.y - containerLocation.y);
            if (fig instanceof ResizableCompartmentFigure) {
                Point scrollOffset = ((ResizableCompartmentFigure)fig).getScrollPane().getViewport().getViewLocation();
                IFigure hostFigure = ((IGraphicalEditPart)this.getHost()).getFigure();
                Point shiftFromMarginOffset = FigureUtilities.getShiftFromMarginOffset((ResizableCompartmentFigure)hostFigure, new RequestQuery((Request)request).isDropOrCreationOfBorderNode(), this.getHost());
                realLocation = new Point(location.x + scrollOffset.x - shiftFromMarginOffset.x, location.y + scrollOffset.y - shiftFromMarginOffset.y);
            } else {
                realLocation = location;
            }
        } else {
            realLocation = location;
        }
        return realLocation;
    }

    private Command createCommandFromRequest(CreateRequest request, Point location, EditPart editPart) {
        Command result = null;
        if (request.getNewObject() instanceof AbstractToolDescription) {
            AbstractToolDescription tool = (AbstractToolDescription)request.getNewObject();
            CreationUtil creationUtil = this.getCreationUtil(request, location, editPart, LaunchToolEditPolicy.getDiagramCommandFactory(editPart));
            if (creationUtil != null) {
                EObject containerView = ((IGraphicalEditPart)editPart).resolveSemanticElement();
                if (tool instanceof RequestDescription) {
                    result = creationUtil.getRequestToolCommand((RequestDescription)tool, editPart);
                } else if (tool instanceof SelectionWizardDescription) {
                    result = creationUtil.getSelectionWizardCommand((SelectionWizardDescription)tool, containerView);
                } else if (tool instanceof PaneBasedSelectionWizardDescription) {
                    result = creationUtil.getPaneBasedSelectionWizardCommand((PaneBasedSelectionWizardDescription)tool, containerView);
                } else if (tool instanceof ToolDescription) {
                    result = creationUtil.getGenericToolCommand(containerView, (ToolDescription)request.getNewObject());
                }
            }
        }
        return result;
    }

    protected CreationUtil getCreationUtil(CreateRequest request, Point location, EditPart editPart, IDiagramCommandFactory baseEmfCommandFactory) {
        return new CreationUtil(request, baseEmfCommandFactory, location, editPart);
    }

    private static IDiagramCommandFactory getDiagramCommandFactory(EditPart editPart) {
        IDiagramCommandFactory diagramCommandFactory = null;
        DDiagramEditor diagramEditor = (DDiagramEditor)editPart.getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((ResourceSet)diagramEditor.getEditingDomain().getResourceSet());
        if (diagramEditor != null) {
            IDiagramCommandFactoryProvider adapter = (IDiagramCommandFactoryProvider)diagramEditor.getAdapter(IDiagramCommandFactoryProvider.class);
            diagramCommandFactory = adapter.getCommandFactory(transactionalEditingDomain);
        }
        return diagramCommandFactory;
    }
}

