/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.decoration;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.query.DRepresentationElementQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.decoration.AbstractSiriusDecorationDescriptorProvider;
import org.eclipse.sirius.diagram.ui.tools.api.decoration.DecorationDescriptor;
import org.eclipse.sirius.diagram.ui.tools.api.decoration.SiriusDecorationDescriptorProvider;
import org.eclipse.sirius.diagram.ui.tools.api.figure.WorkspaceImageFigure;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.Decoration;
import org.eclipse.sirius.viewpoint.UIState;
import org.eclipse.sirius.viewpoint.description.DecorationDescription;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.swt.graphics.Image;

public class DescribedDecorationDescriptorProvider
extends AbstractSiriusDecorationDescriptorProvider
implements SiriusDecorationDescriptorProvider {
    @Override
    public boolean provides(IDiagramElementEditPart editPart) {
        return true;
    }

    @Override
    public List<DecorationDescriptor> createDecorationDescriptors(IDiagramElementEditPart editPart, Session session) {
        DRepresentation parentRepresentation;
        DDiagramElement element;
        ArrayList<DecorationDescriptor> decorationDescriptors = new ArrayList<DecorationDescriptor>();
        if (session != null && editPart != null && (element = editPart.resolveDiagramElement()) != null && (parentRepresentation = new DRepresentationElementQuery((DRepresentationElement)element).getParentRepresentation()) != null) {
            UIState uiState = parentRepresentation.getUiState();
            List decorations = Stream.concat(element.getDecorations().stream(), element.getTransientDecorations().stream()).collect(Collectors.toList());
            for (Decoration decoration : decorations) {
                DecorationDescriptor decorationDescriptor = this.initializeDecorationDescriptor(decoration, element, uiState, parentRepresentation, session);
                if (decorationDescriptor == null) continue;
                decorationDescriptors.add(decorationDescriptor);
            }
        }
        return decorationDescriptors;
    }

    private DecorationDescriptor initializeDecorationDescriptor(Decoration decoration, DDiagramElement element, UIState uiState, DRepresentation parentRepresentation, Session session) {
        DecorationDescriptorWithLazyTooltip decoDesc = new DecorationDescriptorWithLazyTooltip(decoration.getDescription(), element);
        DecorationDescription description = decoration.getDescription();
        Object imageObject = uiState.getDecorationImage().get(decoration);
        if (imageObject == null || !(imageObject instanceof Image)) {
            String imageExpression = decoration.getDescription().getImageExpression();
            IInterpreter interpreter = session.getInterpreter();
            if (interpreter.provides(imageExpression)) {
                imageObject = this.evaluateDecoration(description, element, imageExpression, parentRepresentation, session);
            }
            if (!(imageObject instanceof Image) && !(imageObject instanceof IFigure)) {
                imageObject = imageObject instanceof String ? WorkspaceImageFigure.getImageInstanceFromPath((String)imageObject) : WorkspaceImageFigure.getImageInstanceFromPath(imageExpression);
            }
            if (imageObject == null) {
                return null;
            }
            uiState.getDecorationImage().put(decoration, imageObject);
        }
        if (imageObject instanceof Image) {
            decoDesc.setDecorationAsImage((Image)imageObject);
        } else if (imageObject instanceof IFigure) {
            decoDesc.setDecorationAsFigure((IFigure)imageObject);
        }
        decoDesc.setName(description.getName());
        decoDesc.setPosition(description.getPosition());
        decoDesc.setDistributionDirection(description.getDistributionDirection());
        decoDesc.setDisplayPriority(DecorationDescriptor.DisplayPriority.NORMAL_PRIORITY.getValue());
        return decoDesc;
    }

    private Object evaluateDecoration(DecorationDescription decorationDescription, DDiagramElement element, String expression, DRepresentation parentRepresentation, Session session) {
        Object result = null;
        EObject semantic = element.getTarget();
        DSemanticDecorator container = (DSemanticDecorator)element.eContainer();
        IInterpreter interpreter = session.getInterpreter();
        if (decorationDescription != null && !decorationDescription.eIsProxy()) {
            result = true;
            if (!StringUtil.isEmpty((String)expression)) {
                interpreter.setVariable("containerView", (Object)container);
                interpreter.setVariable("container", (Object)(container != null ? container.getTarget() : null));
                interpreter.setVariable("diagram", (Object)parentRepresentation);
                try {
                    result = interpreter.evaluate(semantic, expression);
                }
                catch (EvaluationException e) {
                    RuntimeLoggerManager.INSTANCE.error((EObject)decorationDescription, (EStructuralFeature)DescriptionPackage.eINSTANCE.getDecorationDescription_PreconditionExpression(), (Throwable)e);
                }
                interpreter.unSetVariable("containerView");
                interpreter.unSetVariable("container");
                interpreter.unSetVariable("diagram");
            }
        }
        return result;
    }

    private class DecorationDescriptorWithLazyTooltip
    extends DecorationDescriptor {
        private DecorationDescription decorationDescription;
        private DDiagramElement element;
        private Session session;

        DecorationDescriptorWithLazyTooltip(DecorationDescription decorationDescription, DDiagramElement element) {
            this.decorationDescription = decorationDescription;
            this.element = element;
        }

        @Override
        public IFigure getTooltipAsFigure() {
            Object evaluated;
            DRepresentation parentRepresentation;
            if (this.tooltipAsFigure != null) {
                return this.tooltipAsFigure;
            }
            if (this.session == null) {
                this.session = new EObjectQuery((EObject)this.element).getSession();
            }
            IInterpreter interpreter = this.session.getInterpreter();
            String tooltipExpression = this.decorationDescription.getTooltipExpression();
            if (tooltipExpression != null && interpreter.provides(tooltipExpression) && (parentRepresentation = new DRepresentationElementQuery((DRepresentationElement)this.element).getParentRepresentation()) != null && (evaluated = DescribedDecorationDescriptorProvider.this.evaluateDecoration(this.decorationDescription, this.element, tooltipExpression, parentRepresentation, this.session)) instanceof IFigure) {
                this.tooltipAsFigure = (IFigure)evaluated;
            }
            return this.tooltipAsFigure;
        }

        @Override
        public String getTooltipAsString() {
            String tooltipExpression;
            if (this.tooltipAsString == null && (tooltipExpression = this.decorationDescription.getTooltipExpression()) != null) {
                IInterpreter interpreter;
                if (this.session == null) {
                    this.session = new EObjectQuery((EObject)this.element).getSession();
                }
                if (!(interpreter = this.session.getInterpreter()).provides(tooltipExpression)) {
                    this.tooltipAsString = tooltipExpression;
                } else {
                    try {
                        this.tooltipAsString = tooltipExpression = interpreter.evaluateString((EObject)this.element, tooltipExpression);
                    }
                    catch (EvaluationException evaluationException) {}
                }
            }
            return this.tooltipAsString;
        }
    }
}

