/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.graphviz.dot.serializer;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.formatting2.FormatterPreferenceKeys;
import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.formatting2.IFormatter2;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.preferences.ITypedPreferenceValues;
import org.eclipse.xtext.preferences.MapBasedPreferenceValues;
import org.eclipse.xtext.preferences.TypedPreferenceKey;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.serializer.impl.Serializer;

public class GraphvizDotSerializer
extends Serializer {
    private static final int MAX_LINE_LENGTH = 255;
    @Inject
    private Provider<IFormatter2> formatter2Provider;
    @Inject
    private Provider<FormatterRequest> formatterRequestProvider;

    protected void serialize(EObject obj, Appendable appendable, SaveOptions options) throws IOException {
        ITextRegionAccess regionAccess = this.serializeToRegions(obj);
        FormatterRequest request = (FormatterRequest)this.formatterRequestProvider.get();
        MapBasedPreferenceValues preferences = new MapBasedPreferenceValues((Map)Maps.newLinkedHashMap());
        preferences.put((TypedPreferenceKey)FormatterPreferenceKeys.maxLineWidth, (Object)255);
        request.setPreferences((ITypedPreferenceValues)preferences);
        request.setFormatUndefinedHiddenRegionsOnly(!options.isFormatting());
        request.setTextRegionAccess(regionAccess);
        IFormatter2 formatter2 = (IFormatter2)this.formatter2Provider.get();
        List replacements = formatter2.format(request);
        regionAccess.getRewriter().renderToAppendable((Iterable)replacements, appendable);
    }
}

