/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ext.gef.query;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.gef.EditPart;

public class EditPartQuery {
    private final EditPart part;

    public EditPartQuery(EditPart part) {
        this.part = Objects.requireNonNull(part);
    }

    public Set<EditPart> getAllChildren(boolean includeSelf) {
        return this.getAllChildren(includeSelf, null);
    }

    public Set<EditPart> getAllChildren(boolean includeSelf, List<Class<?>> includedKind) {
        HashSet<EditPart> result = new HashSet<EditPart>();
        if (includeSelf && (includedKind == null || this.isAssignable(this.part.getClass(), includedKind))) {
            result.add(this.part);
        }
        result.addAll(this.getAllChildren(this.part, includedKind));
        return result;
    }

    private Set<EditPart> getAllChildren(EditPart editPart, List<Class<?>> includedKind) {
        HashSet<EditPart> result = new HashSet<EditPart>();
        Stream<Object> childrenParts = editPart.getChildren().stream().filter(EditPart.class::isInstance).map(EditPart.class::cast);
        childrenParts.forEachOrdered(child -> {
            if (includedKind == null || this.isAssignable(child.getClass(), includedKind)) {
                result.add((EditPart)child);
            }
            result.addAll(this.getAllChildren((EditPart)child, includedKind));
        });
        return result;
    }

    private boolean isAssignable(Class<?> aClass, List<Class<?>> assignementTypes) {
        for (Class<?> class1 : assignementTypes) {
            if (!class1.isAssignableFrom(aClass)) continue;
            return true;
        }
        return false;
    }
}

