/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.handles;

import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.Locator;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.ConnectionHandle;
import org.eclipse.gef.tools.ConnectionEndpointTracker;

public class ConnectionEndpointHandle
extends ConnectionHandle {
    private int endPoint;

    public ConnectionEndpointHandle(ConnectionEditPart owner, int endPoint) {
        this.setOwner((GraphicalEditPart)owner);
        Assert.isTrue((endPoint == 2 || endPoint == 3 ? 1 : 0) != 0);
        this.endPoint = endPoint;
        this.setLocator((Locator)new ConnectionLocator(this.getConnection(), endPoint));
    }

    public ConnectionEndpointHandle(ConnectionEditPart owner, boolean fixed, int endPoint) {
        super(fixed);
        this.setOwner((GraphicalEditPart)owner);
        Assert.isTrue((endPoint == 2 || endPoint == 3 ? 1 : 0) != 0);
        this.endPoint = endPoint;
        this.setLocator((Locator)new ConnectionLocator(this.getConnection(), endPoint));
    }

    public ConnectionEndpointHandle(int endPoint) {
        Assert.isTrue((endPoint == 2 || endPoint == 3 ? 1 : 0) != 0);
        this.endPoint = endPoint;
    }

    protected DragTracker createDragTracker() {
        if (this.isFixed()) {
            return null;
        }
        ConnectionEndpointTracker tracker = new ConnectionEndpointTracker((ConnectionEditPart)this.getOwner());
        if (this.endPoint == 2) {
            tracker.setCommandName("Reconnection source");
        } else {
            tracker.setCommandName("Reconnection target");
        }
        tracker.setDefaultCursor(this.getCursor());
        return tracker;
    }

    public int getEndPoint() {
        return this.endPoint;
    }
}

