/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ui.business.api.query.NodeQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.ViewQuery;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.util.GMFNotationHelper;
import org.eclipse.sirius.diagram.ui.tools.internal.preferences.SiriusDiagramUiInternalPreferencesKeys;
import org.eclipse.sirius.ecore.extender.business.internal.accessor.ecore.EMFUtil;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class CanonicalSynchronizerResult {
    Set<View> createdNodes = new LinkedHashSet<View>();
    List<Edge> createdEdges = new ArrayList<Edge>();
    List<View> orphanNodes = new ArrayList<View>();
    Set<Edge> orphanEdges = new HashSet<Edge>();
    Set<Node> partialOrphanPGE = new HashSet<Node>();
    private final boolean prefRemoveAttachedPGE = DiagramUIPlugin.getPlugin().getPreferenceStore().getBoolean(SiriusDiagramUiInternalPreferencesKeys.PREF_REMOVE_HIDE_NOTE_WHEN_ANNOTED_ELEMENT_HIDDEN_OR_REMOVE.name());

    public void addCreatedNodes(Set<View> createdNodesToAdd) {
        this.createdNodes.addAll(createdNodesToAdd);
    }

    public void addCreatedEdges(List<Edge> createdEdgesToAdd) {
        this.createdEdges.addAll(createdEdgesToAdd);
    }

    public void addOrphanNodes(List<View> orphanNodesToAdd) {
        this.orphanNodes.addAll(orphanNodesToAdd);
    }

    public void addOrphanEdges(List<Edge> orphanEdgesToAdd) {
        this.orphanEdges.addAll(orphanEdgesToAdd);
    }

    public Set<View> getCreatedNodes() {
        return this.createdNodes;
    }

    public List<Edge> getCreatedEdges() {
        return this.createdEdges;
    }

    public Set<View> getCreatedViews() {
        LinkedHashSet<View> allViews = new LinkedHashSet<View>();
        allViews.addAll(this.createdNodes);
        allViews.addAll(this.createdEdges);
        return allViews;
    }

    public List<View> getOrphanNodes() {
        return this.orphanNodes;
    }

    public Set<Edge> getOrphanEdges() {
        return this.orphanEdges;
    }

    private void reconnectNoteAttachment(View fromView, View toView) {
        ArrayList sourceEdges = new ArrayList(fromView.getSourceEdges());
        ArrayList targetEdges = new ArrayList(fromView.getTargetEdges());
        sourceEdges.stream().filter(GMFNotationHelper::isNoteAttachment).forEach(edge -> edge.setSource(toView));
        targetEdges.stream().filter(GMFNotationHelper::isNoteAttachment).forEach(edge -> edge.setTarget(toView));
    }

    private void moveNotesOfView(View fromView, View toView) {
        ArrayList children = new ArrayList(fromView.getChildren());
        children.stream().filter(view -> {
            void var2_1;
            Node node;
            View view2 = view;
            if (view2 instanceof Node && (node = (Node)view2) == (Node)var2_1) {
                void node2;
                return GMFNotationHelper.isNote((Node)node2) || GMFNotationHelper.isTextNote((Node)node2);
            }
            return false;
        }).map(Node.class::cast).forEach(note -> toView.getPersistedChildren().add(note));
    }

    private Optional<Node> getNoteContainer(Node node) {
        if (new ViewQuery((View)node).isRegionContainer()) {
            return Optional.of(node);
        }
        return new NodeQuery(node).getFreeFormContainerCompartment();
    }

    private void moveNotesOfContainer(View fromView, View toView) {
        if (fromView instanceof Node var3_4 && ( instanceOfPatternExpressionValue = toView) instanceof Node var4_6) {
            this.getNoteContainer((Node)fromNode).ifPresent(arg_0 -> this.lambda$7((Node)toNode, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reconciliateOrphanNode(View orphanNode) {
        void var3_2;
        DSemanticDecorator dSemanticDecorator;
        EObject eObject = orphanNode.getElement();
        if (eObject instanceof DSemanticDecorator && (dSemanticDecorator = (DSemanticDecorator)eObject) == (DSemanticDecorator)var3_2) {
            void dDiagramElement;
            this.getCorrespondingView((DSemanticDecorator)dDiagramElement).ifPresent(correspondingView -> {
                this.reconnectNoteAttachment(orphanNode, (View)correspondingView);
                this.moveNotesOfContainer(orphanNode, (View)correspondingView);
            });
        }
    }

    public void reconciliateOrphanNodes() {
        for (View orphanNode : this.orphanNodes) {
            this.reconciliateOrphanNode(orphanNode);
            EMFUtil.getTreeStream((EObject)orphanNode, view -> new ArrayList(view.getChildren())).filter(view -> {
                ViewQuery query = new ViewQuery((View)view);
                return query.isNode() || query.isContainer();
            }).forEach(this::reconciliateOrphanNode);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void reconciliateOrphanEdges() {
        for (Edge orphanEdge : this.orphanEdges) {
            void dDiagramElement;
            EObject eObject = orphanEdge.getElement();
            if (!(eObject instanceof DSemanticDecorator var3_3)) continue;
            this.getCorrespondingView((DSemanticDecorator)dDiagramElement).ifPresent(correspondingView -> this.reconnectNoteAttachment((View)orphanEdge, (View)correspondingView));
        }
    }

    private Optional<View> getCorrespondingView(DSemanticDecorator dDiagramElement) {
        return this.getUniqueCreatedViewForDDiagramElement(dDiagramElement).or(() -> this.getUniqueCreatedViewForSemanticElement(dDiagramElement.getTarget()));
    }

    private Optional<View> getUniqueCreatedViewForDDiagramElement(DSemanticDecorator dDiagramElement) {
        ArrayList<View> candidates = new ArrayList<View>();
        for (View view : this.getCreatedViews()) {
            if (!dDiagramElement.equals(view.getElement())) continue;
            candidates.add(view);
            if (candidates.size() > 1) break;
        }
        if (candidates.size() == 1) {
            return Optional.of((View)candidates.get(0));
        }
        return Optional.empty();
    }

    /*
     * WARNING - void declaration
     */
    private Optional<View> getUniqueCreatedViewForSemanticElement(EObject semanticElement) {
        ArrayList<View> candidates = new ArrayList<View>();
        for (View view : this.getCreatedViews()) {
            void dDiagramElement;
            DSemanticDecorator dSemanticDecorator;
            EObject eObject = view.getElement();
            if (!(eObject instanceof DSemanticDecorator) || (dSemanticDecorator = (DSemanticDecorator)eObject) != (DSemanticDecorator)eObject || !semanticElement.equals(dDiagramElement.getTarget())) continue;
            candidates.add(view);
            if (candidates.size() > 1) break;
        }
        if (candidates.size() == 1) {
            return Optional.of((View)candidates.get(0));
        }
        return Optional.empty();
    }

    public void deleteOrphanNodes() {
        this.orphanNodes.stream().forEach(EcoreUtil::remove);
        this.orphanNodes.clear();
    }

    public void deleteOrphanEdges() {
        this.orphanEdges.stream().forEach(EcoreUtil::remove);
        this.orphanEdges.clear();
    }

    public void collectAttachedEdgeToNodes() {
        this.collectAttachedEdges(this.orphanNodes);
    }

    public void collectAttachedEdgeToEdges() {
        this.collectAttachedEdges(this.orphanEdges);
    }

    private <T extends View> void collectAttachedEdges(Collection<T> views) {
        HashSet<View> removed = new HashSet<View>();
        while (!views.isEmpty()) {
            View view = (View)views.stream().findAny().orElseThrow();
            if (removed.add(view)) {
                List<Edge> edgesToDelete = this.getIncomingOutgoingEdges(view);
                this.addOrphanEdges(edgesToDelete);
            }
            views.removeIf(v -> view == v);
        }
        views.addAll(removed);
    }

    private List<Edge> getIncomingOutgoingEdges(View view) {
        ArrayList<Edge> edgesToDelete = new ArrayList<Edge>();
        edgesToDelete.addAll((Collection<Edge>)view.getSourceEdges());
        edgesToDelete.addAll((Collection<Edge>)view.getTargetEdges());
        EList children = view.getChildren();
        for (View child : children) {
            edgesToDelete.addAll(this.getIncomingOutgoingEdges(child));
        }
        return edgesToDelete;
    }

    private void collectAttachedPGE(View view) {
        List<Edge> noteAttachments = this.getIncomingOutgoingEdges(view).stream().filter(GMFNotationHelper::isNoteAttachment).toList();
        noteAttachments.stream().flatMap(edge -> Stream.of(edge.getSource(), edge.getTarget())).filter(attachedView -> {
            void var2_1;
            Node node;
            View view = attachedView;
            if (view instanceof Node && (node = (Node)view) == (Node)var2_1) {
                void attachedNode;
                return GMFNotationHelper.isNote((Node)attachedNode) || GMFNotationHelper.isTextNote((Node)attachedNode);
            }
            return false;
        }).map(Node.class::cast).forEach(attachedNote -> this.partialOrphanPGE.add((Node)attachedNote));
    }

    public void collectDetachedPGEFromNode() {
        if (this.prefRemoveAttachedPGE) {
            for (View orphanNode : this.orphanNodes) {
                this.collectAttachedPGE(orphanNode);
            }
        }
    }

    public void collectDetachedPGEFromEdge() {
        if (this.prefRemoveAttachedPGE) {
            for (Edge orphanEdge : this.orphanEdges) {
                this.collectAttachedPGE((View)orphanEdge);
            }
        }
    }

    public void deleteDetachedPGE() {
        if (this.prefRemoveAttachedPGE) {
            for (Node pureGraphicalElement : this.partialOrphanPGE) {
                EList sourceEdges = pureGraphicalElement.getSourceEdges();
                EList targetEdges = pureGraphicalElement.getTargetEdges();
                List<Edge> validEdges = Stream.concat(sourceEdges.stream(), targetEdges.stream()).filter(edge -> edge.eContainer() != null).toList();
                if (validEdges.size() == 0) {
                    EcoreUtil.remove((EObject)pureGraphicalElement);
                    continue;
                }
                Stream<Edge> visibleEdges = validEdges.stream().filter(edge -> edge.isVisible());
                if (visibleEdges.count() != 0L) continue;
                pureGraphicalElement.setVisible(false);
            }
            this.partialOrphanPGE.clear();
        }
    }

    private /* synthetic */ void lambda$7(Node node, Node fromCompartment) {
        this.getNoteContainer(node).ifPresent(toCompartment -> this.moveNotesOfView((View)fromCompartment, (View)toCompartment));
    }
}

