/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.internal.commands;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.query.ResourceQuery;
import org.eclipse.sirius.business.internal.representation.DRepresentationLocationManager;
import org.eclipse.sirius.common.tools.api.util.WorkspaceUtil;
import org.eclipse.sirius.ui.tools.internal.actions.repair.RepresentationFilesNeedCloseSessionValidator;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.handlers.HandlerUtil;

public class UpdateRepresentationsLocationHandler
extends AbstractHandler {
    private static final String ERROR_MSG = MessageFormat.format(Messages.UpdateRepresentationsLocationHandler_errorMsg, Messages.UpdateRepresentationsLocationHandler_label);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            Collection<IFile> files = UpdateRepresentationsLocationHandler.getAirdFiles(((IStructuredSelection)selection).toList());
            files.stream().forEach(file -> this.handleIFile((IFile)file));
        }
        return null;
    }

    private void handleIFile(IFile iFile) {
        RepresentationFilesNeedCloseSessionValidator validator = new RepresentationFilesNeedCloseSessionValidator(Messages.UpdateRepresentationsLocationHandler_label);
        if (validator.validate(iFile).isOK()) {
            UpdateRepresentationLocationOperation operation = new UpdateRepresentationLocationOperation(iFile);
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, false, (IRunnableWithProgress)operation);
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException(ERROR_MSG, e);
            }
        }
    }

    public static Collection<IFile> getAirdFiles(List<?> selection) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        selection.iterator().forEachRemaining(el -> {
            if (el instanceof IContainer) {
                files.addAll(WorkspaceUtil.getFilesFromWorkspace(Collections.singleton((IContainer)el), (String)"aird"));
            } else if (el instanceof IFile) {
                files.add((IFile)el);
            }
        });
        return files;
    }

    private class UpdateRepresentationLocationOperation
    extends WorkspaceModifyOperation {
        IFile file;

        UpdateRepresentationLocationOperation(IFile file) {
            this.file = file;
        }

        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
            monitor.beginTask(Messages.UpdateRepresentationsLocationHandler_label, -1);
            URI uri = URI.createPlatformResourceURI((String)this.file.getFullPath().toOSString(), (boolean)true);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            TransactionalEditingDomain domain = TransactionalEditingDomainImpl.FactoryImpl.INSTANCE.createEditingDomain((ResourceSet)resourceSet);
            final Resource airdResource = resourceSet.getResource(uri, true);
            domain.getCommandStack().execute((Command)new RecordingCommand(domain, (ResourceSet)resourceSet){
                private final /* synthetic */ ResourceSet val$resourceSet;
                {
                    this.val$resourceSet = resourceSet;
                    super($anonymous0);
                }

                protected void doExecute() {
                    Stream descriptors = airdResource.getContents().stream().filter(DAnalysis.class::isInstance).map(DAnalysis.class::cast).flatMap(d -> d.getOwnedViews().stream()).flatMap(v -> v.getOwnedRepresentationDescriptors().stream());
                    descriptors.forEach(repDesc -> {
                        DRepresentation representation = repDesc.getRepresentation();
                        DRepresentationLocationManager representationLocationManager = new DRepresentationLocationManager();
                        Resource resourceforRepresentation = representationLocationManager.getOrCreateRepresentationResource(representation, airdResource);
                        this.val$resourceSet.getResources().add((Object)resourceforRepresentation);
                        resourceforRepresentation.getContents().add((Object)representation);
                        repDesc.updateRepresentation(representation);
                    });
                    try {
                        for (Resource resource : this.val$resourceSet.getResources()) {
                            ResourceQuery query = new ResourceQuery(resource);
                            if (!query.isAirdOrSrmResource()) continue;
                            if (resource.getContents().isEmpty()) {
                                resource.delete(Collections.emptyMap());
                                continue;
                            }
                            resource.save(Collections.emptyMap());
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(ERROR_MSG, e);
                    }
                }
            });
        }
    }
}

