/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.actions.export;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.query.FileQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.resource.ImageFileFormat;
import org.eclipse.sirius.ui.tools.api.actions.export.ExportAction;
import org.eclipse.sirius.ui.tools.api.dialogs.ExportSeveralRepresentationsAsImagesDialog;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ExportRepresentationsFromFileAction
implements IObjectActionDelegate {
    private IFile sessionResourceFile;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        Shell shell = Display.getCurrent().getActiveShell();
        IPath targetPath = this.sessionResourceFile.getParent().getLocation();
        URI sessionResourceURI = URI.createPlatformResourceURI((String)this.sessionResourceFile.getFullPath().toOSString(), (boolean)true);
        Session session = SessionManager.INSTANCE.getSession(sessionResourceURI, (IProgressMonitor)new NullProgressMonitor());
        if (session != null) {
            Collection dRepresentationsDescToExportAsImage = DialectManager.INSTANCE.getAllRepresentationDescriptors(session);
            if (!dRepresentationsDescToExportAsImage.isEmpty()) {
                ExportSeveralRepresentationsAsImagesDialog dialog = new ExportSeveralRepresentationsAsImagesDialog(shell, targetPath);
                if (dialog.open() == 1) {
                    dialog.close();
                    return;
                }
                try (ProgressMonitorDialog pmd = new ProgressMonitorDialog(shell);){
                    try {
                        pmd.run(false, false, (IRunnableWithProgress)new ExportRepresentationsWorkspaceModifyOperation(dialog, sessionResourceURI, session));
                    }
                    catch (InvocationTargetException e) {
                        SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.ui", e.getLocalizedMessage(), (Throwable)e));
                        MessageDialog.openError((Shell)shell, (String)Messages.ExportRepresentationsFromFileAction_errorDialog_title, (String)e.getTargetException().getMessage());
                        pmd.close();
                    }
                    catch (InterruptedException e) {
                        SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.ui", e.getLocalizedMessage(), (Throwable)e));
                        MessageDialog.openInformation((Shell)shell, (String)Messages.ExportRepresentationsFromFileAction_interruptedDialog_title, (String)e.getMessage());
                        pmd.close();
                    }
                }
            } else {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ExportRepresentationsFromFileAction_noRepresentationsDialog_title, (String)Messages.ExportRepresentationsFromFileAction_noRepresentationsDialog_message);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        action.setEnabled(false);
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && ((IStructuredSelection)selection).getFirstElement() instanceof IFile && (structuredSelection = (IStructuredSelection)selection).getFirstElement() instanceof IFile) {
            this.sessionResourceFile = (IFile)structuredSelection.getFirstElement();
            action.setEnabled(new FileQuery(this.sessionResourceFile.getFileExtension()).isSessionResourceFile());
        }
    }

    private class ExportRepresentationsWorkspaceModifyOperation
    extends WorkspaceModifyOperation {
        private IPath outputPath;
        private ImageFileFormat imageFormat;
        private boolean exportToHtml;
        private boolean exportDecorations;
        private Integer scaleLevel;
        private URI sessionResourceURI;
        private Session session;

        ExportRepresentationsWorkspaceModifyOperation(ExportSeveralRepresentationsAsImagesDialog dialog, URI sessionResourceURI, Session session) {
            this.outputPath = dialog.getOutputPath();
            this.imageFormat = dialog.getImageFormat();
            this.exportToHtml = dialog.isExportToHtml();
            this.exportDecorations = dialog.isExportDecorations();
            this.scaleLevel = dialog.getDiagramScaleLevelInPercent();
            this.sessionResourceURI = sessionResourceURI;
            this.session = session;
        }

        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
            boolean isOpen = false;
            try {
                isOpen = this.session.isOpen();
                if (!isOpen) {
                    this.session = SessionManager.INSTANCE.openSession(this.sessionResourceURI, monitor, SiriusEditPlugin.getPlugin().getUiCallback());
                }
                if (this.session != null) {
                    Collection dRepresentationsToExportAsImage = DialectManager.INSTANCE.getAllRepresentations(this.session);
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ExportRepresentationsFromFileAction_exportTask, (int)dRepresentationsToExportAsImage.size());
                    ExportAction exportAction = new ExportAction(this.session, dRepresentationsToExportAsImage, this.outputPath, this.imageFormat, this.exportToHtml, this.exportDecorations);
                    exportAction.setDiagramScaleLevel(this.scaleLevel);
                    exportAction.run((IProgressMonitor)subMonitor.newChild(dRepresentationsToExportAsImage.size()));
                }
            }
            finally {
                if (!isOpen && this.session != null) {
                    this.session.close(monitor);
                }
                monitor.done();
            }
        }
    }
}

