/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.commands;

import java.util.HashSet;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ui.internal.operation.CenterEdgeEndModelChangeOperation;

public class CenterEdgeLayoutCommand
extends AbstractTransactionalCommand {
    private GraphicalEditPart editPart;

    public CenterEdgeLayoutCommand(GraphicalEditPart graphicalEditPart) {
        super(graphicalEditPart.getEditingDomain(), "", null);
        this.editPart = graphicalEditPart;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Object model = this.editPart.getModel();
        if (model instanceof View) {
            View view = (View)model;
            HashSet edges = new HashSet();
            if (view instanceof Diagram) {
                edges.addAll(((Diagram)view).getEdges());
            } else {
                ViewUtil.getAllRelatedEdgesForView((View)view, edges);
            }
            for (Edge edge : edges) {
                CenterEdgeEndModelChangeOperation centerEdgeEndModelChangeOperation = new CenterEdgeEndModelChangeOperation(edge, false);
                centerEdgeEndModelChangeOperation.execute();
            }
        }
        return CommandResult.newOKCommandResult();
    }

    public void dispose() {
        this.editPart = null;
        super.dispose();
    }
}

