/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import org.eclipse.elk.alg.layered.DebugUtil;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class ConstraintsPostprocessor
implements ILayoutProcessor<LGraph> {
    public void process(LGraph graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Constraints Postprocessor", 1.0f);
        if (progressMonitor.isLoggingEnabled()) {
            DebugUtil.logDebugGraph(progressMonitor, graph, 0, "ConstraintPostProcessor");
        }
        int layerIndex = 0;
        for (Layer layer : graph.getLayers()) {
            int posIndex = 0;
            boolean nodeLayer = false;
            for (LNode currentNode : layer.getNodes()) {
                if (currentNode.getType() != LNode.NodeType.NORMAL) continue;
                nodeLayer = true;
                currentNode.setProperty(LayeredOptions.LAYERING_LAYER_ID, layerIndex);
                currentNode.setProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_ID, posIndex);
                ++posIndex;
            }
            if (!nodeLayer) continue;
            ++layerIndex;
        }
        if (progressMonitor.isLoggingEnabled()) {
            DebugUtil.logDebugGraph(progressMonitor, graph, 0, "ConstraintPostProcessor");
        }
        progressMonitor.done();
    }
}

