/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.api.widgets;

import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.controllers.IEEFOnClickController;
import org.eclipse.eef.ide.ui.api.widgets.AbstractEEFWidgetLifecycleManager;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

public class EEFHyperlinkListener
implements MouseListener {
    private AbstractEEFWidgetLifecycleManager lifecycleManager;
    private Control hyperlink;
    private IEEFFormContainer container;
    private IEEFOnClickController controller;

    public EEFHyperlinkListener(AbstractEEFWidgetLifecycleManager lifecycleManager, Control hyperlink, IEEFFormContainer container, IEEFOnClickController controller) {
        this.lifecycleManager = lifecycleManager;
        this.hyperlink = hyperlink;
        this.container = container;
        this.controller = controller;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (!this.container.isRenderingInProgress()) {
            if (this.hyperlink instanceof StyledText) {
                try {
                    int offset = ((StyledText)this.hyperlink).getOffsetAtLocation(new Point(e.x, e.y));
                    StyleRange stylerange = ((StyledText)this.hyperlink).getStyleRangeAtOffset(offset);
                    if (stylerange != null) {
                        this.controller.onClick(this.hyperlink.getData(), "SINGLE_CLICK");
                        this.lifecycleManager.refresh();
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                this.controller.onClick(this.hyperlink.getData(), "SINGLE_CLICK");
                this.lifecycleManager.refresh();
            }
        }
    }

    public void mouseUp(MouseEvent e) {
    }
}

