/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.modelingproject.resourcelistener;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.sirius.ui.tools.api.views.modelexplorerview.resourcelistener.DefaultModelingProjectResourceListener;
import org.eclipse.sirius.ui.tools.api.views.modelexplorerview.resourcelistener.IModelingProjectResourceListener;
import org.eclipse.sirius.ui.tools.internal.views.common.modelingproject.resourcelistener.ModelingProjectResourceListenerDescriptor;

public final class ModelingProjectResourceListenerRegistry {
    private static final String EXTENSION_POINT = "org.eclipse.sirius.ui.modelingprojectresourcelistener";
    private static final Object TAG_EXTENSION = "resourcelistener";
    private static List<IModelingProjectResourceListener> registeredModelingProjectResourceListeners = new ArrayList<IModelingProjectResourceListener>();
    private static IModelingProjectResourceListener defaultModelingProjectResourceListener;
    private static boolean initalContributionParsed;

    private ModelingProjectResourceListenerRegistry() {
    }

    public static IModelingProjectResourceListener getModelingProjectResourceListener() {
        if (!initalContributionParsed) {
            ModelingProjectResourceListenerRegistry.parseInitialContributions();
            initalContributionParsed = true;
        }
        if (registeredModelingProjectResourceListeners.iterator().hasNext()) {
            return registeredModelingProjectResourceListeners.get(registeredModelingProjectResourceListeners.size() - 1);
        }
        return ModelingProjectResourceListenerRegistry.getDefaultModelingProjectResourceListener();
    }

    private static IModelingProjectResourceListener getDefaultModelingProjectResourceListener() {
        if (defaultModelingProjectResourceListener == null) {
            defaultModelingProjectResourceListener = new DefaultModelingProjectResourceListener();
        }
        return defaultModelingProjectResourceListener;
    }

    private static void parseInitialContributions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] iExtensionArray = registry.getExtensionPoint(EXTENSION_POINT).getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            ModelingProjectResourceListenerRegistry.parseExtension(extension);
            ++n2;
        }
    }

    private static void parseExtension(IExtension extension) {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            if (TAG_EXTENSION.equals(elem.getName())) {
                try {
                    registeredModelingProjectResourceListeners.add(new ModelingProjectResourceListenerDescriptor(elem).getModelingProjectResourceListener());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            ++n2;
        }
    }
}

