/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.unit.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.synchronizer.AutomaticCreator;
import org.eclipse.sirius.synchronizer.Mapping;
import org.eclipse.sirius.synchronizer.MappingHiearchy;
import org.eclipse.sirius.synchronizer.MappingHiearchyTable;
import org.eclipse.sirius.synchronizer.SemanticPartition;
import org.junit.Assert;

public class MappingHierarchyTableTest
extends TestCase {
    MappingHiearchyTable table;

    protected void setUp() throws Exception {
        super.setUp();
        this.table = new MappingHiearchyTable();
    }

    public void testMappingHierarchy() throws Exception {
        final MockMapping a = new MockMapping();
        MockMapping b = new MockMapping(this){

            @Override
            public Option<Mapping> getSuper() {
                return Options.newSome((Object)a);
            }
        };
        MappingHiearchy hierarchy = new MappingHiearchy((Mapping)b);
        Iterator it = hierarchy.fromMostSpecificToMostGeneral();
        Assert.assertSame((Object)b, it.next());
        Assert.assertSame((Object)a, it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    public void testASingleMappingHasAHierarchy() throws Exception {
        MockMapping a = new MockMapping();
        this.table.compute(new ArrayList<Mapping>(Arrays.asList(a)));
        Assert.assertNotNull((Object)this.table.getHierarchy((Mapping)a));
    }

    public void test2UnrelatedElementsHaveDifferentHierarchies() throws Exception {
        MockMapping a = new MockMapping();
        MockMapping b = new MockMapping();
        this.table.compute(new ArrayList<Mapping>(Arrays.asList(a, b)));
        Assert.assertNotSame(this.table.getHierarchy((Mapping)a).iterator().next(), this.table.getHierarchy((Mapping)b).iterator().next());
    }

    public void testAisSuperOfB() throws Exception {
        final MockMapping a = new MockMapping();
        MockMapping b = new MockMapping(this){

            @Override
            public Option<Mapping> getSuper() {
                return Options.newSome((Object)a);
            }
        };
        this.table.compute(new ArrayList<Mapping>(Arrays.asList(a, b)));
        Assert.assertSame(this.table.getHierarchy((Mapping)a).iterator().next(), this.table.getHierarchy((Mapping)b).iterator().next());
    }

    public void _testCyclingHierarchy() throws Exception {
        MockMapping a = new MockMapping();
        MockMapping b = new MockMapping();
        b.setSuper(a);
        a.setSuper(b);
        this.table.compute(new ArrayList<MockMapping>(Arrays.asList(a, b)));
        Assert.assertSame(this.table.getHierarchy((Mapping)a).iterator().next(), this.table.getHierarchy((Mapping)b).iterator().next());
    }

    class MockMapping
    implements Mapping {
        Mapping superMap = null;

        MockMapping() {
        }

        public Option<Mapping> getSuper() {
            return Options.newSome((Object)this.superMap);
        }

        public Option<AutomaticCreator> getCreator() {
            return Options.newNone();
        }

        public SemanticPartition getSemanticPartition() {
            return SemanticPartition.NONE;
        }

        public List<Mapping> getChildMappings() {
            return new ArrayList<Mapping>();
        }

        public boolean isEnabled() {
            return true;
        }

        public void setSuper(Mapping newSuper) {
            this.superMap = newSuper;
        }
    }
}

