/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.api.command.view;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.helper.graphicalfilters.HideFilterHelper;
import org.eclipse.sirius.diagram.tools.api.Messages;

public class RevealDDiagramElementsLabel
extends RecordingCommand {
    public static final String REVEAL_LABELS = Messages.RevealDDiagramElementsLabel_revealLabels;
    public static final String REVEAL_LABEL = Messages.RevealDDiagramElementsLabel_revealLabel;
    private final Set<DDiagramElement> diagramElements;
    private final Map<EObject, List<Integer>> selectedLabelVisualIds;

    public RevealDDiagramElementsLabel(TransactionalEditingDomain domain, Set<DDiagramElement> diagramElements) {
        super(domain, RevealDDiagramElementsLabel.getLabel(diagramElements));
        this.diagramElements = diagramElements;
        this.selectedLabelVisualIds = Collections.EMPTY_MAP;
    }

    public RevealDDiagramElementsLabel(TransactionalEditingDomain domain, Set<DDiagramElement> diagramElements, Map<EObject, List<Integer>> selectedLabelVisualIds) {
        super(domain, RevealDDiagramElementsLabel.getLabel(diagramElements));
        this.diagramElements = diagramElements;
        this.selectedLabelVisualIds = selectedLabelVisualIds;
    }

    protected void doExecute() {
        for (DDiagramElement diagramElement : this.diagramElements) {
            if (this.selectedLabelVisualIds.keySet().contains(diagramElement)) {
                HideFilterHelper.INSTANCE.revealLabel(diagramElement, this.selectedLabelVisualIds);
                continue;
            }
            HideFilterHelper.INSTANCE.revealLabel(diagramElement);
        }
    }

    public static String getLabel(Set<DDiagramElement> diagramElements) {
        String result = diagramElements != null && diagramElements.size() > 1 ? REVEAL_LABELS : REVEAL_LABEL;
        return result;
    }
}

