/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.operation;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramComponentizationManager;
import org.eclipse.sirius.diagram.business.api.query.DiagramDescriptionQuery;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.RefreshSemanticOrderingsOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.tool.ToolCommandBuilder;
import org.eclipse.sirius.diagram.sequence.description.tool.InstanceRoleReorderTool;
import org.eclipse.sirius.diagram.sequence.tool.internal.Messages;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.command.SiriusCommand;

public class SynchronizeInstanceRoleSemanticOrderingOperation
extends AbstractModelChangeOperation<Void> {
    private final SequenceDDiagram sequenceDiagram;
    private final SequenceDiagram diagram;
    private final Set<InstanceRole> reordered = new LinkedHashSet<InstanceRole>();
    private InstanceRole instanceRole;
    private Set<InstanceRole> selection = new LinkedHashSet<InstanceRole>();

    public SynchronizeInstanceRoleSemanticOrderingOperation(InstanceRole instanceRole) {
        super(Messages.SynchronizeInstanceRoleSemanticOrderingOperation_operationName);
        this.instanceRole = Objects.requireNonNull(instanceRole);
        this.diagram = instanceRole.getDiagram();
        this.sequenceDiagram = this.diagram.getSequenceDDiagram();
    }

    public SynchronizeInstanceRoleSemanticOrderingOperation(InstanceRole instanceRole, Collection<InstanceRole> selection) {
        this(instanceRole);
        this.selection.addAll(Objects.requireNonNull(selection));
    }

    public Void execute() {
        this.updateSemanticPositions();
        return null;
    }

    private void updateSemanticPositions() {
        this.updateSemanticPosition(this.instanceRole);
        for (InstanceRole selected : this.selection) {
            this.updateSemanticPosition(selected);
        }
    }

    private void updateSemanticPosition(InstanceRole instanceRoleToUpdate) {
        DDiagramElement dde = this.resolveDiagramElement(instanceRoleToUpdate);
        if (dde == null || this.reordered.contains(instanceRoleToUpdate)) {
            return;
        }
        InstanceRoleReorderTool reorderTool = this.findReorderTool(dde);
        if (reorderTool == null) {
            return;
        }
        EObject semanticElement = dde.getTarget();
        EList rolesBySemanticOrder = this.sequenceDiagram.getInstanceRoleSemanticOrdering().getSemanticInstanceRoles();
        List<EObject> rolesByGraphicalOrder = this.getSemanticInstanceRolesByGraphicalOrder();
        EObject predecessorBefore = this.findEndPredecessor(semanticElement, (List<EObject>)rolesBySemanticOrder);
        EObject predecessorAfter = this.findEndPredecessor(semanticElement, rolesByGraphicalOrder);
        if (!rolesBySemanticOrder.isEmpty() && !Objects.equals(predecessorBefore, predecessorAfter) || !Iterables.elementsEqual((Iterable)rolesBySemanticOrder, rolesByGraphicalOrder)) {
            this.applySemanticReordering(semanticElement, predecessorBefore, predecessorAfter, reorderTool);
            this.reordered.add(instanceRoleToUpdate);
            new RefreshSemanticOrderingsOperation(this.sequenceDiagram).execute();
        }
    }

    private List<EObject> getSemanticInstanceRolesByGraphicalOrder() {
        Option<SequenceDiagram> seqDiag;
        Iterable diagramViews = Iterables.filter(ISequenceElementAccessor.getViewsForSemanticElement(this.sequenceDiagram, this.sequenceDiagram.getTarget()), Diagram.class);
        if (!Iterables.isEmpty((Iterable)diagramViews) && (seqDiag = ISequenceElementAccessor.getSequenceDiagram((Diagram)diagramViews.iterator().next())).some()) {
            return Lists.newArrayList((Iterable)Iterables.transform(((SequenceDiagram)seqDiag.get()).getSortedInstanceRole(), ISequenceElement.SEMANTIC_TARGET));
        }
        return Collections.emptyList();
    }

    private DDiagramElement resolveDiagramElement(InstanceRole instanceRoleToUpdate) {
        EObject element = instanceRoleToUpdate.getNotationView().getElement();
        if (element instanceof DDiagramElement) {
            return (DDiagramElement)element;
        }
        throw new RuntimeException(MessageFormat.format(Messages.SynchronizeInstanceRoleSemanticOrderingOperation_invalidInstanceRoleContext, instanceRoleToUpdate));
    }

    private EObject findEndPredecessor(EObject semanticElement, List<EObject> semanticInstanceRoles) {
        EObject result = null;
        for (EObject current : semanticInstanceRoles) {
            if (semanticElement == current) break;
            result = current;
        }
        return result;
    }

    private void applySemanticReordering(EObject semanticElement, EObject predecessorBefore, EObject predecessorAfter, InstanceRoleReorderTool reorderTool) {
        SiriusCommand cmd = ToolCommandBuilder.buildInstanceRoleReorderCommand(this.sequenceDiagram, reorderTool, semanticElement, predecessorBefore, predecessorAfter);
        cmd.execute();
    }

    private InstanceRoleReorderTool findReorderTool(DDiagramElement diagramElement) {
        if (diagramElement != null) {
            Session session = SessionManager.INSTANCE.getSession((EObject)diagramElement);
            Collection allTools = session != null ? new DiagramComponentizationManager().getAllTools(session.getSelectedViewpoints(false), this.sequenceDiagram.getDescription()) : new DiagramDescriptionQuery(this.sequenceDiagram.getDescription()).getAllTools();
            for (InstanceRoleReorderTool toolDesc : Iterables.filter((Iterable)allTools, InstanceRoleReorderTool.class)) {
                if (!toolDesc.getMappings().contains((Object)diagramElement.getMapping())) continue;
                return toolDesc;
            }
        }
        return null;
    }
}

