/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.swt.finder.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.ArrayResult;
import org.eclipse.swtbot.swt.finder.results.BoolResult;
import org.eclipse.swtbot.swt.finder.results.IntResult;
import org.eclipse.swtbot.swt.finder.results.ListResult;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.StringResult;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.results.WidgetResult;
import org.eclipse.swtbot.swt.finder.utils.MessageFormat;
import org.eclipse.swtbot.swt.finder.utils.SWTUtils;
import org.eclipse.swtbot.swt.finder.utils.TableRow;
import org.eclipse.swtbot.swt.finder.utils.TextDescription;
import org.eclipse.swtbot.swt.finder.utils.internal.Assert;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotRootMenu;
import org.eclipse.swtbot.swt.finder.widgets.SiriusSWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.TimeoutException;
import org.hamcrest.SelfDescribing;

public class SiriusSWTBotTreeItem
extends AbstractSWTBot<TreeItem> {
    private Tree tree;

    public SiriusSWTBotTreeItem(TreeItem treeItem) throws WidgetNotFoundException {
        this(treeItem, null);
    }

    public SiriusSWTBotTreeItem(final TreeItem treeItem, SelfDescribing description) throws WidgetNotFoundException {
        super((Widget)treeItem, description);
        this.tree = (Tree)this.syncExec((Result)new WidgetResult<Tree>(){

            public Tree run() {
                return treeItem.getParent();
            }
        });
    }

    public String cell(final int column) {
        if (column == 0) {
            return this.getText();
        }
        int columnCount = new SiriusSWTBotTree(this.tree).columnCount();
        Assert.isLegal((column < columnCount ? 1 : 0) != 0, (Object)java.text.MessageFormat.format("The column index ({0}) is more than the number of column({1}) in the tree.", column, columnCount));
        return this.syncExec(new StringResult(){

            public String run() {
                return ((TreeItem)SiriusSWTBotTreeItem.this.widget).getText(column);
            }
        });
    }

    public TableRow row() {
        return (TableRow)this.syncExec((Result)new Result<TableRow>(){

            public TableRow run() {
                int columnCount = SiriusSWTBotTreeItem.this.tree.getColumnCount();
                TableRow tableRow = new TableRow();
                if (columnCount == 0) {
                    tableRow.add(((TreeItem)SiriusSWTBotTreeItem.this.widget).getText());
                } else {
                    int j = 0;
                    while (j < columnCount) {
                        tableRow.add(((TreeItem)SiriusSWTBotTreeItem.this.widget).getText(j));
                        ++j;
                    }
                }
                return tableRow;
            }
        });
    }

    public int rowCount() {
        return this.syncExec(new IntResult(){

            public Integer run() {
                return ((TreeItem)SiriusSWTBotTreeItem.this.widget).getItemCount();
            }
        });
    }

    public SiriusSWTBotTreeItem getNode(final int row) {
        int rowCount = this.rowCount();
        Assert.isLegal((row < rowCount ? 1 : 0) != 0, (Object)java.text.MessageFormat.format("The row number ({0}) is more than the number of rows({1}) in the tree.", row, rowCount));
        return (SiriusSWTBotTreeItem)((Object)this.syncExec((Result)new Result<SiriusSWTBotTreeItem>(){

            public SiriusSWTBotTreeItem run() {
                return new SiriusSWTBotTreeItem(((TreeItem)SiriusSWTBotTreeItem.this.widget).getItem(row));
            }
        }));
    }

    public String cell(int row, int column) {
        return this.getNode(row).cell(column);
    }

    public SiriusSWTBotTreeItem expand() {
        this.waitForEnabled();
        if (this.isExpanded()) {
            this.log.warn((Object)MessageFormat.format((String)"Tree item {0} is already expanded. Won''t expand it again.", (Object[])new Object[]{this}));
            return this;
        }
        this.preExpandCollapseNotify();
        this.syncExec(new VoidResult(){

            public void run() {
                SiriusSWTBotTreeItem.this.notifyTree(17, SiriusSWTBotTreeItem.this.createEvent());
                ((TreeItem)SiriusSWTBotTreeItem.this.widget).setExpanded(true);
            }
        });
        this.postExpandCollapseNotify();
        return this;
    }

    public SiriusSWTBotTreeItem collapse() {
        this.waitForEnabled();
        if (!this.isExpanded()) {
            this.log.warn((Object)MessageFormat.format((String)"Tree item {0} is already collapsed. Won''t collapse it again.", (Object[])new Object[]{this}));
            return this;
        }
        this.preExpandCollapseNotify();
        this.syncExec(new VoidResult(){

            public void run() {
                SiriusSWTBotTreeItem.this.notifyTree(18, SiriusSWTBotTreeItem.this.createEvent());
                ((TreeItem)SiriusSWTBotTreeItem.this.widget).setExpanded(false);
            }
        });
        this.postExpandCollapseNotify();
        return this;
    }

    private void preExpandCollapseNotify() {
        this.notifyTree(26, super.createEvent());
        this.notifyTree(15, super.createEvent());
        this.notifyTree(3, this.createMouseEvent(1, 0, 1));
    }

    private void postExpandCollapseNotify() {
        this.notifyTree(4, this.createMouseEvent(1, 524288, 1));
    }

    private void notifyTree(int eventType, Event event) {
        this.notify(eventType, event, (Widget)this.tree);
    }

    private void notifyTree(int eventType, Event event, Runnable runnable) {
        this.notify(eventType, event, (Widget)this.tree, runnable);
    }

    protected Event createEvent() {
        Event event = super.createEvent();
        event.widget = this.tree;
        event.item = this.widget;
        return event;
    }

    public List<String> getNodes() {
        return this.syncExec((ListResult)new ListResult<String>(){

            public List<String> run() {
                TreeItem[] items = ((TreeItem)SiriusSWTBotTreeItem.this.widget).getItems();
                ArrayList<String> result = new ArrayList<String>(items.length);
                TreeItem[] treeItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    result.add(item.getText());
                    ++n2;
                }
                return result;
            }
        });
    }

    public SiriusSWTBotTreeItem expandNode(String ... nodes) {
        Assert.isNotEmpty((Object[])nodes);
        this.waitForEnabled();
        SiriusSWTBotTreeItem item = this;
        String[] stringArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            String node = stringArray[n2];
            item = item.getNode(node).expand();
            ++n2;
        }
        return item;
    }

    public SiriusSWTBotTreeItem collapseNode(String nodeText) {
        this.waitForEnabled();
        return this.getNode(nodeText).collapse();
    }

    public SiriusSWTBotTreeItem getNode(String nodeText, int index) {
        List<SiriusSWTBotTreeItem> nodes = this.getNodes(nodeText);
        Assert.isTrue((index < nodes.size() ? 1 : 0) != 0, (Object)MessageFormat.format((String)"The index ({0}) was more than the number of nodes ({1}) in the tree.", (Object[])new Object[]{index, nodes.size()}));
        return nodes.get(index);
    }

    public List<SiriusSWTBotTreeItem> getNodes(final String nodeText) {
        List foundItems = this.syncExec((ListResult)new ListResult<SiriusSWTBotTreeItem>(){

            public List<SiriusSWTBotTreeItem> run() {
                TreeItem[] items = ((TreeItem)SiriusSWTBotTreeItem.this.widget).getItems();
                ArrayList<SiriusSWTBotTreeItem> results = new ArrayList<SiriusSWTBotTreeItem>();
                TreeItem[] treeItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem treeItem = treeItemArray[n2];
                    if (treeItem.getText().equals(nodeText)) {
                        results.add(new SiriusSWTBotTreeItem(treeItem, (SelfDescribing)new TextDescription("Tree node with text: " + nodeText)));
                    }
                    ++n2;
                }
                return results;
            }
        });
        if (foundItems.isEmpty()) {
            throw new WidgetNotFoundException("Could not find node with text: " + nodeText);
        }
        return foundItems;
    }

    public SiriusSWTBotTreeItem getNode(String nodeText) {
        return this.getNode(nodeText, 0);
    }

    public SiriusSWTBotTreeItem select() {
        this.waitForEnabled();
        this.setFocus();
        this.notifySelect((TreeItem)this.widget, 0);
        return this;
    }

    public SiriusSWTBotTreeItem unselect() {
        this.assertMultiSelect();
        if (!this.isSelected()) {
            return this;
        }
        this.waitForEnabled();
        this.setFocus();
        this.notifyUnselect((TreeItem)this.widget);
        return this;
    }

    protected void clickXY(int x, int y) {
        this.log.debug((Object)MessageFormat.format((String)"Clicking on {0}", (Object[])new Object[]{this}));
        this.notifyTree(6, this.createMouseEvent(x, y, 0, 0, 0));
        this.notifyTree(26, super.createEvent());
        this.setFocus();
        this.notifyTree(15, super.createEvent());
        this.notifyTree(3, this.createMouseEvent(x, y, 1, 0, 1));
        this.notifyTree(13, this.createSelectionEvent(524288), this.selectRunnable((TreeItem)this.widget, false));
        this.notifyTree(4, this.createMouseEvent(x, y, 1, 524288, 1));
        this.notifyTree(7, this.createMouseEvent(x, y, 0, 0, 0));
        this.notifyTree(27, super.createEvent());
        this.notifyTree(16, super.createEvent());
        this.log.debug((Object)MessageFormat.format((String)"Clicked on {0}", (Object[])new Object[]{this}));
    }

    public SiriusSWTBotTreeItem click() {
        this.waitForEnabled();
        Point center = this.getCenter(this.getBounds());
        this.clickXY(center.x, center.y);
        return this;
    }

    public SiriusSWTBotTreeItem click(int column) {
        this.waitForEnabled();
        Point center = this.getCenter(this.getCellBounds(column));
        this.clickXY(center.x, center.y);
        return this;
    }

    public SiriusSWTBotTreeItem doubleClick() {
        this.waitForEnabled();
        this.log.debug((Object)MessageFormat.format((String)"Double-clicking on {0}", (Object[])new Object[]{this}));
        this.notifyTree(6, this.createMouseEvent(0, 0, 0));
        this.notifyTree(26, super.createEvent());
        this.setFocus();
        this.notifyTree(15, super.createEvent());
        this.notifyTree(3, this.createMouseEvent(1, 0, 1));
        this.notifyTree(13, this.createSelectionEvent(524288), this.selectRunnable((TreeItem)this.widget, false));
        this.notifyTree(4, this.createMouseEvent(1, 524288, 1));
        this.notifyTree(3, this.createMouseEvent(1, 0, 2));
        this.notifyTree(8, this.createMouseEvent(1, 0, 2));
        this.notifyTree(14, this.createSelectionEvent(524288));
        this.notifyTree(4, this.createMouseEvent(1, 524288, 2));
        this.notifyTree(7, this.createMouseEvent(0, 0, 0));
        this.notifyTree(27, super.createEvent());
        this.notifyTree(16, super.createEvent());
        this.log.debug((Object)MessageFormat.format((String)"Double-clicked on {0}", (Object[])new Object[]{this}));
        return this;
    }

    public SiriusSWTBotTreeItem doubleClick(int column) {
        this.waitForEnabled();
        Point center = this.getCenter(this.getCellBounds(column));
        this.doubleClickXY(center.x, center.y);
        return this;
    }

    protected void doubleClickXY(int x, int y) {
        this.waitForEnabled();
        this.log.debug((Object)MessageFormat.format((String)"Double-clicking on {0}", (Object[])new Object[]{this}));
        this.notifyTree(6, this.createMouseEvent(x, y, 0, 0, 0));
        this.notifyTree(26, super.createEvent());
        this.setFocus();
        this.notifyTree(15, super.createEvent());
        this.notifyTree(3, this.createMouseEvent(x, y, 1, 0, 1));
        this.notifyTree(13, this.createSelectionEvent(524288), this.selectRunnable((TreeItem)this.widget, false));
        this.notifyTree(4, this.createMouseEvent(x, y, 1, 524288, 1));
        this.notifyTree(3, this.createMouseEvent(x, y, 1, 0, 2));
        this.notifyTree(8, this.createMouseEvent(x, y, 1, 0, 2));
        this.notifyTree(14, this.createSelectionEvent(524288));
        this.notifyTree(4, this.createMouseEvent(x, y, 1, 524288, 2));
        this.notifyTree(7, this.createMouseEvent(x, y, 0, 0, 0));
        this.notifyTree(27, super.createEvent());
        this.notifyTree(16, super.createEvent());
        this.log.debug((Object)MessageFormat.format((String)"Double-clicked on {0}", (Object[])new Object[]{this}));
    }

    protected Control getDNDControl() {
        return this.tree;
    }

    protected void dragStart() {
        this.setFocus();
        this.notifyTree(26, super.createEvent());
        this.notifyTree(15, super.createEvent());
        this.notifyTree(3, this.createMouseEvent(1, 0, 1));
        this.notifyTree(13, this.createSelectionEvent(524288), this.selectRunnable((TreeItem)this.widget, false));
    }

    protected Rectangle getBounds() {
        return (Rectangle)this.syncExec((Result)new Result<Rectangle>(){

            public Rectangle run() {
                if (((TreeItem)SiriusSWTBotTreeItem.this.widget).isDisposed()) {
                    return new Rectangle(0, 0, 0, 0);
                }
                return ((TreeItem)SiriusSWTBotTreeItem.this.widget).getBounds();
            }
        });
    }

    private Rectangle getCellBounds(final int column) {
        return (Rectangle)this.syncExec((Result)new Result<Rectangle>(){

            public Rectangle run() {
                return ((TreeItem)SiriusSWTBotTreeItem.this.widget).getBounds(column);
            }
        });
    }

    private Point getCenter(Rectangle bounds) {
        return new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
    }

    public SiriusSWTBotTreeItem select(String ... items) {
        this.waitForEnabled();
        this.setFocus();
        if (items.length > 1) {
            this.assertMultiSelect();
        }
        ArrayList<TreeItem> selection = new ArrayList<TreeItem>();
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            SiriusSWTBotTreeItem si = this.getTreeItem(item);
            selection.add((TreeItem)si.widget);
            ++n2;
        }
        int i = 0;
        while (i < selection.size()) {
            int stateMask = i == 0 ? 0 : SWT.MOD1;
            this.notifySelect((TreeItem)selection.get(i), stateMask);
            ++i;
        }
        return this;
    }

    public SiriusSWTBotTreeItem select(int ... indices) {
        this.waitForEnabled();
        this.setFocus();
        if (indices.length > 1) {
            this.assertMultiSelect();
        }
        int i = 0;
        while (i < indices.length) {
            this.assertIsLegalRowIndex(indices[i]);
            ++i;
        }
        ArrayList<TreeItem> selection = new ArrayList<TreeItem>();
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            selection.add(this.getItem(index));
            ++n2;
        }
        this.log.debug((Object)MessageFormat.format((String)"Selecting rows {0} in {1}", (Object[])new Object[]{Arrays.toString(indices), this}));
        int i2 = 0;
        while (i2 < selection.size()) {
            int stateMask = i2 == 0 ? 0 : SWT.MOD1;
            this.notifySelect((TreeItem)selection.get(i2), stateMask);
            ++i2;
        }
        return this;
    }

    public SiriusSWTBotTreeItem select(String item) {
        return this.select(new String[]{item});
    }

    private Runnable selectRunnable(final TreeItem item, final boolean add) {
        return new Runnable(){

            @Override
            public void run() {
                if (add) {
                    SiriusSWTBotTreeItem.this.tree.select(item);
                } else {
                    SiriusSWTBotTreeItem.this.tree.setSelection(item);
                }
            }
        };
    }

    public void selectAll() {
        this.assertMultiSelect();
        this.waitForEnabled();
        this.setFocus();
        TreeItem[] items = (TreeItem[])this.syncExec((ArrayResult)new ArrayResult<TreeItem>(){

            public TreeItem[] run() {
                if (!((TreeItem)SiriusSWTBotTreeItem.this.widget).getExpanded()) {
                    return new TreeItem[]{(TreeItem)SiriusSWTBotTreeItem.this.widget};
                }
                return SiriusSWTBotTreeItem.this.getExpandedChildren((TreeItem)SiriusSWTBotTreeItem.this.widget).toArray(new TreeItem[0]);
            }
        });
        if (items.length == 0) {
            return;
        }
        this.notifySelect(items[0], 0);
        if (items.length > 1) {
            this.notifySelect(items[items.length - 1], SWT.MOD2, this.selectRunnable(items));
        }
    }

    private List<TreeItem> getExpandedChildren(TreeItem item) {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            items.add(child);
            if (child.getExpanded() && child.getItemCount() > 0) {
                items.addAll(this.getExpandedChildren(child));
            }
            ++n2;
        }
        return items;
    }

    private Runnable selectRunnable(final TreeItem[] items) {
        return new Runnable(){

            @Override
            public void run() {
                SiriusSWTBotTreeItem.this.tree.setSelection(items);
            }
        };
    }

    private Runnable unselectRunnable(final TreeItem item) {
        return new Runnable(){

            @Override
            public void run() {
                SiriusSWTBotTreeItem.this.tree.deselect(item);
            }
        };
    }

    private void notifyUnselect(TreeItem unselected) {
        this.notifySelect(unselected, SWT.MOD1, this.unselectRunnable(unselected));
    }

    private void notifySelect(TreeItem selected, int stateMask) {
        this.notifySelect(selected, stateMask, this.selectRunnable(selected, (stateMask & SWT.MOD1) != 0));
    }

    private void notifySelect(TreeItem selected, int stateMask, Runnable runnable) {
        SiriusSWTBotTreeItem item = new SiriusSWTBotTreeItem(selected);
        this.notifyTree(6, item.createMouseEvent(0, 0, 0));
        this.notifyTree(26, super.createEvent());
        this.notifyTree(15, super.createEvent());
        this.notifyTree(3, item.createMouseEvent(1, stateMask, 1));
        this.notifyTree(13, item.createSelectionEvent(stateMask | 0x80000), runnable);
        this.notifyTree(4, item.createMouseEvent(1, stateMask | 0x80000, 1));
    }

    protected Event createSelectionEvent(int stateMask) {
        Event event = super.createSelectionEvent(stateMask);
        event.item = this.widget;
        return event;
    }

    public String getText() {
        return SWTUtils.getText((Object)this.widget);
    }

    public SWTBotRootMenu contextMenu() {
        this.waitForEnabled();
        this.select();
        return this.contextMenu((Control)this.tree);
    }

    public void toggleCheck() {
        this.setChecked(!this.isChecked());
    }

    public void check() {
        this.setChecked(true);
    }

    public void uncheck() {
        this.setChecked(false);
    }

    public boolean isChecked() {
        this.assertIsCheck();
        return this.syncExec(new BoolResult(){

            public Boolean run() {
                return ((TreeItem)SiriusSWTBotTreeItem.this.widget).getChecked();
            }
        });
    }

    private Event createCheckEvent() {
        Event event = this.createSelectionEvent(524288);
        event.detail = 32;
        return event;
    }

    private void setChecked(final boolean checked) {
        this.waitForEnabled();
        this.assertIsCheck();
        this.syncExec(new VoidResult(){

            public void run() {
                SiriusSWTBotTreeItem.this.log.debug((Object)MessageFormat.format((String)"Setting state to {0} on: {1}", (Object[])new Object[]{checked ? "checked" : "unchecked", ((TreeItem)SiriusSWTBotTreeItem.this.widget).getText()}));
                ((TreeItem)SiriusSWTBotTreeItem.this.widget).setChecked(checked);
            }
        });
        this.notifyCheck();
    }

    private void assertIsCheck() {
        Assert.isLegal((boolean)this.hasStyle((Widget)this.tree, 32), (Object)"The tree does not have the style SWT.CHECK");
    }

    private void notifyCheck() {
        this.syncExec(new VoidResult(){

            public void run() {
                SiriusSWTBotTreeItem.this.tree.notifyListeners(13, SiriusSWTBotTreeItem.this.createCheckEvent());
            }
        });
    }

    protected void waitForEnabled() {
        new SiriusSWTBotTree(this.tree).waitForEnabled();
    }

    private void assertMultiSelect() {
        Assert.isLegal((boolean)this.hasStyle((Widget)this.tree, 2), (Object)"Tree does not support multi selection.");
    }

    private void assertIsLegalRowIndex(int rowIndex) {
        Assert.isLegal((rowIndex < this.rowCount() ? 1 : 0) != 0, (Object)("The row number: " + rowIndex + " does not exist."));
    }

    public boolean isSelected() {
        return (Boolean)UIThreadRunnable.syncExec((Result)new BoolResult(){

            public Boolean run() {
                return Arrays.asList(SiriusSWTBotTreeItem.this.tree.getSelection()).contains(SiriusSWTBotTreeItem.this.widget);
            }
        });
    }

    public boolean isExpanded() {
        this.waitForEnabled();
        return (Boolean)UIThreadRunnable.syncExec((Result)new BoolResult(){

            public Boolean run() {
                return ((TreeItem)SiriusSWTBotTreeItem.this.widget).getExpanded();
            }
        });
    }

    public SiriusSWTBotTreeItem[] getItems() {
        return (SiriusSWTBotTreeItem[])this.syncExec((ArrayResult)new ArrayResult<SiriusSWTBotTreeItem>(){

            public SiriusSWTBotTreeItem[] run() {
                TreeItem[] items = ((TreeItem)SiriusSWTBotTreeItem.this.widget).getItems();
                ArrayList<SiriusSWTBotTreeItem> children = new ArrayList<SiriusSWTBotTreeItem>();
                int i = 0;
                while (i < items.length) {
                    if (!items[i].isDisposed()) {
                        children.add(new SiriusSWTBotTreeItem(items[i]));
                    }
                    ++i;
                }
                return children.toArray(new SiriusSWTBotTreeItem[children.size()]);
            }
        });
    }

    public Color foregroundColor() {
        return (Color)this.syncExec((Result)new Result<Color>(){

            public Color run() {
                return ((TreeItem)SiriusSWTBotTreeItem.this.widget).getForeground();
            }
        });
    }

    public Color backgroundColor() {
        return (Color)this.syncExec((Result)new Result<Color>(){

            public Color run() {
                return ((TreeItem)SiriusSWTBotTreeItem.this.widget).getBackground();
            }
        });
    }

    private SiriusSWTBotTreeItem getTreeItem(final String nodeText) throws WidgetNotFoundException {
        try {
            new SWTBot().waitUntil((ICondition)new DefaultCondition(){

                public String getFailureMessage() {
                    return "Could not find node with text " + nodeText;
                }

                public boolean test() throws Exception {
                    return SiriusSWTBotTreeItem.this.getItem(nodeText) != null;
                }
            });
        }
        catch (TimeoutException e) {
            throw new WidgetNotFoundException("Timed out waiting for tree item " + nodeText, (Throwable)e);
        }
        return new SiriusSWTBotTreeItem(this.getItem(nodeText));
    }

    private TreeItem getItem(final int index) {
        return (TreeItem)this.syncExec((WidgetResult)new WidgetResult<TreeItem>(){

            public TreeItem run() {
                return ((TreeItem)SiriusSWTBotTreeItem.this.widget).getItem(index);
            }
        });
    }

    private TreeItem getItem(final String nodeText) {
        return (TreeItem)this.syncExec((WidgetResult)new WidgetResult<TreeItem>(){

            public TreeItem run() {
                TreeItem[] items;
                TreeItem[] treeItemArray = items = ((TreeItem)SiriusSWTBotTreeItem.this.widget).getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    if (item.getText().equals(nodeText)) {
                        return item;
                    }
                    ++n2;
                }
                return null;
            }
        });
    }

    public boolean isEnabled() {
        return this.syncExec(new BoolResult(){

            public Boolean run() {
                return SiriusSWTBotTreeItem.this.tree.isEnabled();
            }
        });
    }

    public boolean isGrayed() {
        this.assertIsCheck();
        return this.syncExec(new BoolResult(){

            public Boolean run() {
                return ((TreeItem)SiriusSWTBotTreeItem.this.widget).getGrayed();
            }
        });
    }

    protected Rectangle absoluteLocation() {
        return (Rectangle)UIThreadRunnable.syncExec((Result)new Result<Rectangle>(){

            public Rectangle run() {
                return SiriusSWTBotTreeItem.this.display.map((Control)((TreeItem)SiriusSWTBotTreeItem.this.widget).getParent(), null, ((TreeItem)SiriusSWTBotTreeItem.this.widget).getBounds());
            }
        });
    }

    public void setFocus() {
        new SiriusSWTBotTree(this.tree).setFocus();
    }
}

