/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.view.factories;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;

public final class ViewLocationHint {
    public static final String SOURCE_ANCHOR_LOCATION = "sourceConnectionAnchorLocation";
    public static final String TARGET_ANCHOR_LOCATION = "targetConnectionAnchorLocation";
    private static ViewLocationHint instance = new ViewLocationHint();
    private static final int QUEUE_SIZE = 3;
    private final ConcurrentMap<Object, Object> memento = new ConcurrentHashMap<Object, Object>();
    private Queue<Point> locations = new LinkedList<Point>();
    private Map<Object, Point> hintData = new HashMap<Object, Point>();
    private Map<Point, Object> inverseHintData = new HashMap<Point, Object>();
    private boolean isLocked = false;

    private ViewLocationHint() {
    }

    public synchronized void setLocation(Point location) {
        this.setLocation(location, null);
    }

    public void putData(Object key, Object value) {
        this.memento.put(key, value);
    }

    public Object getData(Object key) {
        return this.memento.get(key);
    }

    public Object removeData(Object key) {
        return this.memento.remove(key);
    }

    public synchronized void setLocation(Point location, Object hint) {
        if (!this.isLocked) {
            Point overflowedLocation;
            this.locations.add(location);
            if (this.locations.size() > 3 && this.inverseHintData.containsKey(overflowedLocation = this.locations.poll())) {
                Object overflowedHintData = this.inverseHintData.get(overflowedLocation);
                this.inverseHintData.remove(overflowedLocation);
                this.hintData.remove(overflowedHintData);
            }
            if (hint != null) {
                Point locationPoint = this.hintData.get(hint);
                if (locationPoint != null) {
                    this.inverseHintData.remove(locationPoint);
                    this.locations.remove(locationPoint);
                }
                this.hintData.put(hint, location);
                this.inverseHintData.put(location, hint);
            }
        }
    }

    public synchronized void lock() {
        this.isLocked = true;
    }

    public synchronized Point consumeLocation() {
        return this.consumeLocation(null);
    }

    public synchronized Point consumeLocation(Object hint) {
        Point loc = null;
        if (!this.locations.isEmpty()) {
            if (hint != null) {
                loc = this.hintData.get(hint);
                if (loc == null) {
                    if (hint instanceof AbstractGraphicalEditPart) {
                        loc = this.getLocationFromCompartmentParent((AbstractGraphicalEditPart)hint);
                    }
                    if (loc == null) {
                        loc = this.getLocationFromInverseData(hint);
                    }
                } else {
                    this.remove(hint, loc);
                }
            }
            if (loc == null) {
                Iterator points = this.locations.iterator();
                while (points.hasNext()) {
                    Point next = (Point)points.next();
                    if (this.inverseHintData.containsKey(next)) continue;
                    loc = next;
                    points.remove();
                    break;
                }
                if (loc == null) {
                    loc = this.locations.peek();
                }
            }
        }
        this.isLocked = false;
        return loc;
    }

    private Point getLocationFromInverseData(Object hint) {
        Point loc = null;
        for (Map.Entry<Point, Object> iterInverse : this.inverseHintData.entrySet()) {
            if (iterInverse.getValue() != hint) continue;
            loc = iterInverse.getKey();
        }
        if (loc != null) {
            this.inverseHintData.remove(loc);
        }
        return loc;
    }

    private Point getLocationFromCompartmentParent(AbstractGraphicalEditPart hint) {
        Point loc = null;
        CompartmentEditPart children = this.searchForCompartmentParent(hint);
        if (children != null) {
            loc = this.hintData.get(children);
            this.remove(children, loc);
        }
        return loc;
    }

    private void remove(Object hint, Point loc) {
        this.hintData.remove(hint);
        this.inverseHintData.remove(loc);
        this.locations.remove(loc);
    }

    private CompartmentEditPart searchForCompartmentParent(AbstractGraphicalEditPart hint) {
        for (Object recordedHint : this.hintData.keySet()) {
            if (!(recordedHint instanceof CompartmentEditPart) || !((CompartmentEditPart)recordedHint).getParent().equals(hint)) continue;
            return (CompartmentEditPart)recordedHint;
        }
        return null;
    }

    public static ViewLocationHint getInstance() {
        return instance;
    }
}

