/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.api.dialect;

import org.eclipse.sirius.common.tools.api.resource.ImageFileFormat;

public class ExportFormat {
    private final ExportDocumentFormat documentFormat;
    private final ImageFileFormat imageFomat;
    private final ScalingPolicy scalingPolicy;
    private boolean exportTraceabilityData;
    private final Integer scalingLevel;

    public ExportFormat(ExportDocumentFormat documentFormat, ImageFileFormat imageFormat, ScalingPolicy scalingPolicy) {
        this.documentFormat = documentFormat;
        this.imageFomat = imageFormat;
        this.scalingPolicy = scalingPolicy;
        this.scalingLevel = null;
    }

    public ExportFormat(ExportDocumentFormat documentFormat, ImageFileFormat imageFormat, ScalingPolicy scalingPolicy, Integer scalingLevel) {
        this.documentFormat = documentFormat;
        this.imageFomat = imageFormat;
        this.scalingPolicy = scalingPolicy;
        this.scalingLevel = scalingLevel;
    }

    public ExportFormat(ExportDocumentFormat documentFormat, ImageFileFormat imageFormat) {
        this(documentFormat, imageFormat, ScalingPolicy.WORKSPACE_DEFAULT, null);
    }

    public ImageFileFormat getImageFormat() {
        return this.imageFomat;
    }

    public ExportDocumentFormat getDocumentFormat() {
        return this.documentFormat;
    }

    public ScalingPolicy getScalingPolicy() {
        return this.scalingPolicy;
    }

    public Integer getScalingLevel() {
        return this.scalingLevel;
    }

    public void setSemanticTraceabilityEnabled(boolean exportTraceability) {
        this.exportTraceabilityData = exportTraceability;
    }

    public boolean isSemanticTraceabilityEnabled() {
        return this.exportTraceabilityData;
    }

    public static enum ExportDocumentFormat {
        HTML,
        CSV,
        NONE;

    }

    public static enum ScalingPolicy {
        WORKSPACE_DEFAULT,
        AUTO_SCALING,
        NO_SCALING,
        AUTO_SCALING_IF_LARGER;

    }
}

