/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.internal.part;

import java.util.Collections;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.draw2d.Graphics;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gef.tools.ConnectionEndpointTracker;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.gef.ui.internal.tools.SelectConnectionEditPartTracker;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.tools.api.layout.PinHelper;
import org.eclipse.sirius.diagram.tools.internal.commands.PinElementsCommand;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.command.GMFCommandWrapper;
import org.eclipse.sirius.diagram.ui.tools.internal.preferences.SiriusDiagramUiInternalPreferencesKeys;
import org.eclipse.sirius.diagram.ui.tools.internal.render.SiriusRenderedMapModeGraphics;

public final class CommonEditPartOperation {
    private CommonEditPartOperation() {
    }

    public static void setGraphicsTraceabilityId(Graphics graphics, Supplier<EObject> element) {
        if (graphics instanceof SiriusRenderedMapModeGraphics) {
            ((SiriusRenderedMapModeGraphics)graphics).setGraphicsTraceabilityId(element);
        }
    }

    public static org.eclipse.gef.commands.Command handleAutoPinOnInteractiveMove(IDiagramElementEditPart self, Request request, org.eclipse.gef.commands.Command cmd) {
        org.eclipse.gef.commands.Command result = cmd;
        Optional<DDiagramElement> optionaldDiagramElement = CommonEditPartOperation.getAffectedDDiagramElement(self, request);
        if (optionaldDiagramElement.isPresent()) {
            DDiagramElement dDiagramElement = optionaldDiagramElement.get();
            if (CommonEditPartOperation.autoPinOnMoveEnabled() && CommonEditPartOperation.isInteractiveMove() && PinHelper.allowsPinUnpin((DDiagramElement)dDiagramElement)) {
                CompoundCommand cc = new CompoundCommand();
                cc.add(cmd);
                PinElementsCommand emfCommand = new PinElementsCommand(Collections.singleton(dDiagramElement));
                ICommandProxy pinCmd = new ICommandProxy((ICommand)new GMFCommandWrapper(self.getEditingDomain(), (Command)emfCommand));
                cc.add((org.eclipse.gef.commands.Command)pinCmd);
                result = cc.unwrap();
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static Optional<DDiagramElement> getAffectedDDiagramElement(IDiagramElementEditPart editPart, Request request) {
        Optional<DDiagramElement> result = Optional.empty();
        EObject semanticElement = editPart.resolveSemanticElement();
        if (semanticElement instanceof DDiagramElement) {
            DDiagramElement dDiagramElement = (DDiagramElement)semanticElement;
            if (("move".equals(request.getType()) || "create bendpoint".equals(request.getType()) || "move bendpoint".equals(request.getType())) && !new PinHelper().isPinned(dDiagramElement)) {
                result = Optional.of(dDiagramElement);
            } else {
                Request request2 = request;
                if (request2 instanceof ReconnectRequest) {
                    void reconnectRequest;
                    ReconnectRequest reconnectRequest2 = (ReconnectRequest)request2;
                    ReconnectRequest cfr_ignored_0 = (ReconnectRequest)request2;
                    ConnectionEditPart connectionEditPart = reconnectRequest.getConnectionEditPart();
                    if (connectionEditPart instanceof IGraphicalEditPart) {
                        void connectionEditPart2;
                        IGraphicalEditPart iGraphicalEditPart = (IGraphicalEditPart)connectionEditPart;
                        IGraphicalEditPart cfr_ignored_1 = (IGraphicalEditPart)connectionEditPart;
                        EObject edgeSemanticElement = connectionEditPart2.resolveSemanticElement();
                        if (edgeSemanticElement instanceof DDiagramElement && !new PinHelper().isPinned((DDiagramElement)edgeSemanticElement)) {
                            result = Optional.of((DDiagramElement)edgeSemanticElement);
                        }
                    }
                }
            }
        }
        return result;
    }

    private static boolean autoPinOnMoveEnabled() {
        return DiagramUIPlugin.getPlugin().getPreferenceStore().getBoolean(SiriusDiagramUiInternalPreferencesKeys.PREF_AUTO_PIN_ON_MOVE.name());
    }

    private static boolean isInteractiveMove() {
        RuntimeException re = new RuntimeException();
        StackTraceElement[] stack = re.getStackTrace();
        int i = 3;
        while (i < 6 && i < stack.length) {
            try {
                if (DragTracker.class.isAssignableFrom(Class.forName(stack[i].getClassName())) || SelectConnectionEditPartTracker.class.isAssignableFrom(Class.forName(stack[i].getClassName())) || ConnectionEndpointTracker.class.isAssignableFrom(Class.forName(stack[i].getClassName()))) {
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                break;
            }
            ++i;
        }
        return false;
    }
}

