/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ConnectionBendpointEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.SetConnectionBendpointsCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.sirius.diagram.sequence.business.api.util.Range;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.CombinedFragment;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.EndOfLife;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Execution;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceNode;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.LostMessageEnd;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.EndOfLifeMoveOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.SetMessageRangeOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.ShiftDirectSubExecutionsOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.ordering.EventEndHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.query.ISequenceEventQuery;
import org.eclipse.sirius.diagram.sequence.business.internal.query.SequenceMessageViewQuery;
import org.eclipse.sirius.diagram.sequence.business.internal.util.EventFinder;
import org.eclipse.sirius.diagram.sequence.ordering.CompoundEventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.SingleEventEnd;
import org.eclipse.sirius.diagram.sequence.ui.Messages;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.EndOfLifeOperations;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.SequenceEditPartsOperations;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.ShiftDescendantMessagesOperation;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.EndOfLifeEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.ISequenceEventEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.InstanceRoleEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.LifelineEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.SequenceDiagramEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.SequenceMessageEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy.SequenceInteractionFeedBackBuilder;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.PositionsChecker;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.EditPartsHelper;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.CommandFactory;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ext.draw2d.figure.HorizontalGuide;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;
import org.eclipse.swt.graphics.Color;

public class SequenceMessageEditPolicy
extends ConnectionBendpointEditPolicy {
    public static final String REQUEST_FROM_SEQUENCE_MESSAGE_EDIT_POLICY = "org.eclipse.sirius.sequence.resize.execution.from.bendpoint.request";
    private static final Color MESSAGE_FEEDBACK_COLOR = SequenceInteractionFeedBackBuilder.ISE_FEEDBACK_COLOR;
    private final Collection<Figure> guides = new ArrayList<Figure>();
    private boolean invalidCommand;

    public void activate() {
        Preconditions.checkState((boolean)(this.getHost() instanceof SequenceMessageEditPart));
        super.activate();
    }

    protected SequenceMessageEditPart getMessage() {
        return (SequenceMessageEditPart)this.getHost();
    }

    protected void addInvisibleCreationHandle(List list, ConnectionEditPart connEP, int i) {
    }

    public void showSourceFeedback(Request request) {
        this.removeFeedBackOnGuides();
        if (request instanceof BendpointRequest) {
            this.showSourceFeedback((BendpointRequest)request);
        }
    }

    private void showSourceFeedback(BendpointRequest br) {
        SequenceMessageEditPart thisEvent = (SequenceMessageEditPart)this.getHost();
        ISequenceEvent iSequenceEvent = thisEvent.getISequenceEvent();
        List ends = EventEndHelper.findEndsFromSemanticOrdering((ISequenceEvent)iSequenceEvent);
        super.showSourceFeedback((Request)br);
        MoveType moveType = this.getMoveType(thisEvent, br, ends);
        if (moveType.needsCompoundMove()) {
            this.showCompoundEndFeedback(br, thisEvent, ends, moveType.isFromTop());
        } else {
            Point location = new Point(1, thisEvent.getConnectionFigure().getPoints().getFirstPoint().y);
            location.performScale(GraphicalHelper.getZoom((EditPart)this.getHost()));
            HorizontalGuide guide = new HorizontalGuide(MESSAGE_FEEDBACK_COLOR, location.y);
            Rectangle bounds = this.getFeedbackLayer().getBounds().getCopy();
            bounds.setHeight(1);
            bounds.setY(location.y);
            guide.setBounds(bounds);
            this.addFeedback((IFigure)guide);
            this.guides.add((Figure)guide);
            if (new ISequenceEventQuery(this.getMessage().getISequenceEvent()).isReflectiveMessage()) {
                Point endLocation = new Point(1, thisEvent.getConnectionFigure().getPoints().getLastPoint().y);
                endLocation.performScale(GraphicalHelper.getZoom((EditPart)this.getHost()));
                HorizontalGuide messageToSelfBottomGuide = new HorizontalGuide(MESSAGE_FEEDBACK_COLOR, endLocation.y);
                bounds = this.getFeedbackLayer().getBounds().getCopy();
                bounds.setHeight(1);
                bounds.setY(endLocation.y);
                messageToSelfBottomGuide.setBounds(bounds);
                this.addFeedback((IFigure)messageToSelfBottomGuide);
                this.guides.add((Figure)messageToSelfBottomGuide);
            }
            if (thisEvent.getTarget() instanceof InstanceRoleEditPart) {
                this.showInstanceRoleFeedback(br);
            } else if (thisEvent.getTarget() instanceof EndOfLifeEditPart) {
                this.showEndOfLifeFeedback((Request)br);
            }
            Point reqLoc = br.getLocation().getCopy();
            GraphicalHelper.screen2logical((Point)reqLoc, (GraphicalEditPart)((IGraphicalEditPart)this.getHost()));
            Option<Range> finalRange = this.computeFinalRange(br, thisEvent, reqLoc);
            if (finalRange.some()) {
                Collection<Integer> invalidPositions = this.checkGlobalPositions(iSequenceEvent, finalRange);
                for (Integer conflict : invalidPositions) {
                    bounds = this.getFeedbackLayer().getBounds().getCopy();
                    Point conflictingPosition = new Point(0, conflict.intValue());
                    conflictingPosition.performScale(GraphicalHelper.getZoom((EditPart)this.getHost()));
                    HorizontalGuide conflictGuide = new HorizontalGuide(SequenceInteractionFeedBackBuilder.CONFLICT_FEEDBACK_COLOR, conflictingPosition.y);
                    bounds.setY(conflictingPosition.y);
                    bounds.setHeight(1);
                    conflictGuide.setBounds(bounds);
                    this.addFeedback((IFigure)conflictGuide);
                    this.guides.add((Figure)conflictGuide);
                }
            }
        }
    }

    private void removeFeedBackOnGuides() {
        for (Figure fig : this.guides) {
            this.removeFeedback((IFigure)fig);
        }
        this.guides.clear();
    }

    private void showCompoundEndFeedback(BendpointRequest request, SequenceMessageEditPart thisEvent, List<EventEnd> ends, boolean fromTop) {
        final EObject thisSemanticEvent = thisEvent.resolveTargetSemanticElement();
        SequenceDiagramEditPart sdep = EditPartsHelper.getSequenceDiagramPart((IGraphicalEditPart)thisEvent);
        Range thisRange = thisEvent.getISequenceEvent().getVerticalRange();
        Point location = request.getLocation().getCopy();
        Predicate<SingleEventEnd> toMove = new Predicate<SingleEventEnd>(){

            public boolean apply(SingleEventEnd input) {
                return !input.getSemanticEvent().equals(thisSemanticEvent);
            }
        };
        Dimension resizeDelta = this.getResizeDelta(location.getCopy(), thisEvent, thisRange, fromTop);
        for (CompoundEventEnd cee : Iterables.filter(ends, CompoundEventEnd.class)) {
            for (SingleEventEnd see : Iterables.filter((Iterable)Lists.newArrayList((Iterable)cee.getEventEnds()), (Predicate)toMove)) {
                ISequenceEventEditPart ise = EditPartsHelper.findISequenceEvent(see, sdep);
                ChangeBoundsRequest cbr = this.buildChangeBoundRequest(location.getCopy(), thisEvent, see, resizeDelta);
                ise.showSourceFeedback((Request)cbr);
            }
        }
    }

    private void eraseCompoundEndFeedback(BendpointRequest request, SequenceMessageEditPart thisEvent, List<EventEnd> ends, boolean fromTop) {
        final EObject thisSemanticEvent = thisEvent.resolveTargetSemanticElement();
        SequenceDiagramEditPart sdep = EditPartsHelper.getSequenceDiagramPart((IGraphicalEditPart)thisEvent);
        Range thisRange = thisEvent.getISequenceEvent().getVerticalRange();
        Point location = request.getLocation().getCopy();
        Predicate<SingleEventEnd> toMove = new Predicate<SingleEventEnd>(){

            public boolean apply(SingleEventEnd input) {
                return !input.getSemanticEvent().equals(thisSemanticEvent);
            }
        };
        Dimension resizeDelta = this.getResizeDelta(location.getCopy(), thisEvent, thisRange, fromTop);
        for (CompoundEventEnd cee : Iterables.filter(ends, CompoundEventEnd.class)) {
            for (SingleEventEnd see : Iterables.filter((Iterable)Lists.newArrayList((Iterable)cee.getEventEnds()), (Predicate)toMove)) {
                ISequenceEventEditPart ise = EditPartsHelper.findISequenceEvent(see, sdep);
                ChangeBoundsRequest cbr = this.buildChangeBoundRequest(location.getCopy(), thisEvent, see, resizeDelta);
                ise.eraseSourceFeedback((Request)cbr);
            }
        }
    }

    private void showInstanceRoleFeedback(BendpointRequest request) {
        InstanceRoleEditPart target = (InstanceRoleEditPart)((SequenceMessageEditPart)this.getHost()).getTarget();
        ChangeBoundsRequest cbr = new ChangeBoundsRequest((Object)"move");
        Point scrollSize = GraphicalHelper.getScrollSize((GraphicalEditPart)target);
        IGraphicalEditPart source = (IGraphicalEditPart)((SequenceMessageEditPart)this.getHost()).getSource();
        int feedbackRangeLimit = request.getLocation().y;
        Rectangle sourceBbounds = source.getFigure().getBounds();
        int firstMessageInTargetInstanceRole = Integer.MAX_VALUE;
        LifelineEditPart lifelineEditPart = (LifelineEditPart)Iterables.getOnlyElement(EditPartsHelper.getAllLifelines((IGraphicalEditPart)target));
        Range occupiedRange = lifelineEditPart.getISequenceEvent().getOccupiedRange();
        if (!occupiedRange.isEmpty()) {
            firstMessageInTargetInstanceRole = occupiedRange.getLowerBound() - 5;
        }
        if (feedbackRangeLimit < sourceBbounds.y + 5) {
            feedbackRangeLimit = sourceBbounds.y + 5;
        } else if (firstMessageInTargetInstanceRole < feedbackRangeLimit + 5) {
            feedbackRangeLimit = firstMessageInTargetInstanceRole - 5;
        } else if (feedbackRangeLimit + GraphicalHelper.getScrollSize((GraphicalEditPart)target).y > sourceBbounds.y + sourceBbounds.height - 5) {
            feedbackRangeLimit = sourceBbounds.y + sourceBbounds.height - GraphicalHelper.getScrollSize((GraphicalEditPart)target).y - 5;
        }
        cbr.getMoveDelta().setY(feedbackRangeLimit - (target.getFigure().getBounds().y + target.getFigure().getBounds().height / 2) + scrollSize.y);
        target.showSourceFeedback((Request)cbr);
    }

    private void showEndOfLifeFeedback(Request request) {
        EndOfLifeEditPart endOfLifeEditPart = (EndOfLifeEditPart)((SequenceMessageEditPart)this.getHost()).getTarget();
        EndOfLifeOperations.showEndOfLifeFeedback(request, endOfLifeEditPart, (IGraphicalEditPart)((SequenceMessageEditPart)this.getHost()).getSource());
    }

    public void eraseSourceFeedback(Request request) {
        this.removeFeedBackOnGuides();
        super.eraseSourceFeedback(request);
        if (request instanceof BendpointRequest) {
            SequenceMessageEditPart thisEvent = (SequenceMessageEditPart)this.getHost();
            List ends = EventEndHelper.findEndsFromSemanticOrdering((ISequenceEvent)((ISequenceEventEditPart)this.getHost()).getISequenceEvent());
            BendpointRequest br = (BendpointRequest)request;
            if (thisEvent.getTarget() instanceof InstanceRoleEditPart) {
                InstanceRoleEditPart target = (InstanceRoleEditPart)thisEvent.getTarget();
                ChangeBoundsRequest cbr = new ChangeBoundsRequest((Object)"move");
                cbr.getMoveDelta().setY(br.getLocation().y - (target.getFigure().getBounds().y + target.getFigure().getBounds().height / 2));
                target.eraseSourceFeedback((Request)cbr);
            } else if (thisEvent.getTarget() instanceof EndOfLifeEditPart) {
                EndOfLifeOperations.eraseEndOfLifeFeedback((LifelineEditPart)thisEvent.getTarget().getParent(), (Request)br);
            } else {
                MoveType moveType = this.getMoveType(thisEvent, br, ends);
                if (moveType.needsCompoundMove()) {
                    this.eraseCompoundEndFeedback(br, thisEvent, ends, moveType.isFromTop());
                }
            }
        }
    }

    public EditPart getTargetEditPart(Request request) {
        if ("set_all_connection_bendpoint".equals(request.getType())) {
            return this.getHost();
        }
        return super.getTargetEditPart(request);
    }

    protected Command getBendpointsChangedCommand(BendpointRequest request) {
        org.eclipse.gef.commands.UnexecutableCommand result;
        this.invalidCommand = false;
        SequenceMessageEditPart thisEvent = (SequenceMessageEditPart)this.getHost();
        Command baseCommand = super.getBendpointsChangedCommand(request);
        ICommand smrc = null;
        Point location = request.getLocation().getCopy();
        GraphicalHelper.screen2logical((Point)location, (GraphicalEditPart)((IGraphicalEditPart)this.getHost()));
        Option<Range> finalRange = this.computeFinalRange(request, thisEvent, location);
        if (finalRange.some()) {
            smrc = this.createReconnectionCommandOnBendpointMove(request, thisEvent, location, (Range)finalRange.get());
        }
        List ends = EventEndHelper.findEndsFromSemanticOrdering((ISequenceEvent)thisEvent.getISequenceEvent());
        this.invalidCommand = this.invalidCommand || !baseCommand.canExecute() || !finalRange.some();
        this.invalidCommand = this.invalidCommand || "move bendpoint".equals(request.getType());
        this.invalidCommand = this.invalidCommand || !this.validateMessageParentOperand(finalRange);
        boolean bl = this.invalidCommand = this.invalidCommand || !this.checkGlobalPositions(thisEvent.getISequenceEvent(), finalRange).isEmpty();
        if (this.invalidCommand) {
            thisEvent.setCursor(Cursors.NO);
            result = org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
        } else {
            String label = baseCommand.getLabel();
            CompositeTransactionalCommand ctc = new CompositeTransactionalCommand(thisEvent.getEditingDomain(), MessageFormat.format(Messages.SequenceMessageEditPolicy_synchronizeOrderingCompositeCommand, label != null ? label : "<null>"));
            SequenceEditPartsOperations.appendFullRefresh((IGraphicalEditPart)thisEvent, ctc);
            MoveType move = this.getMoveType(thisEvent, request, ends);
            if (move.needsCompoundMove()) {
                this.addCompoundEventCommands(ctc, thisEvent, ends, request, move.isFromTop());
                thisEvent.setCursor(Cursors.SIZENS);
            } else {
                if (thisEvent.getTarget() instanceof InstanceRoleEditPart) {
                    ctc.compose((IUndoableOperation)this.getMoveCreateMessageCommand(request, thisEvent, baseCommand));
                } else if (thisEvent.getTarget() instanceof EndOfLifeEditPart) {
                    ctc.compose((IUndoableOperation)this.getMoveDestroyMessageCommand(request, thisEvent, baseCommand));
                }
                ctc.compose((IUndoableOperation)smrc);
                SequenceEditPartsOperations.addRefreshGraphicalOrderingCommand(ctc, (IGraphicalEditPart)thisEvent);
                SequenceEditPartsOperations.addSynchronizeSemanticOrderingCommand(ctc, thisEvent.getISequenceEvent());
                thisEvent.setCursor(org.eclipse.gmf.runtime.gef.ui.internal.l10n.Cursors.CURSOR_SEG_MOVE);
            }
            SequenceEditPartsOperations.appendFullRefresh((IGraphicalEditPart)thisEvent, ctc);
            if (!ctc.canExecute()) {
                thisEvent.setCursor(Cursors.NO);
                result = org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
            } else {
                result = new ICommandProxy((ICommand)ctc);
            }
        }
        return result;
    }

    private Collection<Integer> checkGlobalPositions(final ISequenceEvent thisEvent, final Option<Range> finalRange) {
        Function<ISequenceEvent, Range> futureRangeFunction = new Function<ISequenceEvent, Range>(){

            public Range apply(ISequenceEvent from) {
                Range verticalRange = from.getVerticalRange();
                if (thisEvent.equals(from) && finalRange.some()) {
                    verticalRange = (Range)finalRange.get();
                }
                return verticalRange;
            }
        };
        return new PositionsChecker(thisEvent.getDiagram(), futureRangeFunction).getInvalidPositions();
    }

    private ICommand createReconnectionCommandOnBendpointMove(BendpointRequest request, SequenceMessageEditPart thisEvent, Point location, Range finalRange) {
        SetMessageRangeOperation smrc = new SetMessageRangeOperation((Edge)thisEvent.getNotationView(), finalRange);
        Message message = (Message)thisEvent.getISequenceEvent();
        boolean reflectiveMessage = message.isReflective();
        this.setOperations(true, message, finalRange, smrc, reflectiveMessage);
        this.setOperations(false, message, finalRange, smrc, reflectiveMessage);
        return CommandFactory.createICommand((TransactionalEditingDomain)thisEvent.getEditingDomain(), (AbstractModelChangeOperation)smrc);
    }

    private void setOperations(boolean source, Message message, Range finalRange, SetMessageRangeOperation smrc, boolean reflectiveMessage) {
        Range messageEndRange = source ? new Range(finalRange.getLowerBound(), finalRange.getLowerBound()) : new Range(finalRange.getUpperBound(), finalRange.getUpperBound());
        ISequenceNode currentEnd = source ? message.getSourceElement() : message.getTargetElement();
        Option endLifeline = currentEnd.getLifeline();
        if (endLifeline.some() && currentEnd instanceof ISequenceEvent) {
            boolean noValidation;
            ISequenceEvent finalEnd;
            EventFinder endFinder = new EventFinder((Lifeline)endLifeline.get());
            endFinder.setReconnection(true);
            if (!reflectiveMessage) {
                finalEnd = endFinder.findMostSpecificEvent(finalRange);
            } else {
                boolean compoundSrc;
                finalEnd = (ISequenceEvent)currentEnd;
                boolean bl = finalEnd instanceof Execution && message.equals(source ? ((Execution)finalEnd).getEndMessage().get() : ((Execution)finalEnd).getStartMessage().get()) ? true : (compoundSrc = false);
                if (!compoundSrc && !finalEnd.equals(endFinder.findMostSpecificEvent(messageEndRange))) {
                    this.invalidCommand = true;
                }
                endFinder.setReconnection(false);
                ISequenceEvent potentialSource = endFinder.findMostSpecificEvent(messageEndRange);
                if (potentialSource instanceof CombinedFragment) {
                    this.invalidCommand = true;
                }
            }
            if (source && finalEnd == null) {
                finalEnd = (ISequenceEvent)currentEnd;
            }
            endFinder.setReconnection(false);
            ISequenceEvent realEnd = endFinder.findMostSpecificEvent(finalRange);
            if (realEnd == null) {
                realEnd = (ISequenceEvent)currentEnd;
            }
            boolean bl = noValidation = reflectiveMessage || realEnd instanceof Lifeline;
            if (!this.invalidCommand) {
                if (finalEnd != null && (noValidation || realEnd != null && realEnd.canChildOccupy((ISequenceEvent)message, finalRange))) {
                    Range finalEndRange = finalEnd.getVerticalRange();
                    Rectangle endBounds = new Rectangle(0, finalEndRange.getLowerBound(), 0, finalEndRange.width());
                    if (source) {
                        smrc.setSource(finalEnd.getNotationView(), endBounds);
                    } else {
                        smrc.setTarget(finalEnd.getNotationView(), endBounds);
                    }
                } else {
                    this.invalidCommand = true;
                }
            }
        } else if (currentEnd instanceof LostMessageEnd || currentEnd instanceof EndOfLife || currentEnd instanceof InstanceRole) {
            Rectangle finalEndBounds = currentEnd.getProperLogicalBounds().getCopy();
            if (source) {
                smrc.setSource(currentEnd.getNotationView(), finalEndBounds);
            } else {
                smrc.setTarget(currentEnd.getNotationView(), finalEndBounds);
            }
        }
    }

    private Option<Range> computeFinalRange(BendpointRequest request, SequenceMessageEditPart smep, Point location) {
        Range finalRange = null;
        if (!new ISequenceEventQuery(smep.getISequenceEvent()).isReflectiveMessage()) {
            finalRange = new Range(location.y, location.y);
        } else {
            Edge edge = (Edge)smep.getNotationView();
            SequenceMessageViewQuery query = new SequenceMessageViewQuery(edge);
            int firstPointVerticalPosition = query.getFirstPointVerticalPosition(true);
            int lastPointVerticalPosition = query.getLastPointVerticalPosition(true);
            switch (request.getIndex()) {
                case 0: {
                    finalRange = this.safeComputeMessageToSelfFinalRangeFromTop(location, lastPointVerticalPosition);
                    break;
                }
                case 2: {
                    finalRange = this.safeComputeMessageToSelfFinalRangeFromBottom(firstPointVerticalPosition, location);
                    break;
                }
                default: {
                    finalRange = new Range(firstPointVerticalPosition, lastPointVerticalPosition);
                }
            }
        }
        return Options.newSome((Object)finalRange);
    }

    private Range safeComputeMessageToSelfFinalRangeFromBottom(int firstPointVerticalPosition, Point newBottomLocation) {
        if (newBottomLocation.y >= firstPointVerticalPosition + 10) {
            return new Range(firstPointVerticalPosition, newBottomLocation.y);
        }
        this.invalidCommand = true;
        return null;
    }

    private Range safeComputeMessageToSelfFinalRangeFromTop(Point newTopLocation, int lastPointVerticalPosition) {
        if (newTopLocation.y <= lastPointVerticalPosition - 10) {
            return new Range(newTopLocation.y, lastPointVerticalPosition);
        }
        this.invalidCommand = true;
        return null;
    }

    private MoveType getMoveType(SequenceMessageEditPart event, BendpointRequest request, List<EventEnd> ends) {
        boolean compoundMove = !Iterables.isEmpty((Iterable)Iterables.filter(ends, CompoundEventEnd.class));
        boolean msgToSelfMove = new ISequenceEventQuery(event.getISequenceEvent()).isReflectiveMessage();
        boolean needsCompoundEventCommands = compoundMove && !msgToSelfMove;
        boolean fromTop = true;
        if (compoundMove && msgToSelfMove && ends.size() == 2) {
            Point location = request.getLocation().getCopy();
            GraphicalHelper.screen2logical((Point)location, (GraphicalEditPart)event);
            needsCompoundEventCommands = request.getExtendedData().containsKey("messageToSelfTopMove") ? ((fromTop = ((Boolean)request.getExtendedData().get("messageToSelfTopMove")).booleanValue()) ? ends.get(0) instanceof CompoundEventEnd : ends.get(1) instanceof CompoundEventEnd) : false;
        }
        return new MoveType(needsCompoundEventCommands, fromTop);
    }

    private void addCompoundEventCommands(CompositeTransactionalCommand ctc, SequenceMessageEditPart thisEvent, List<EventEnd> ends, BendpointRequest request, boolean fromTop) {
        final EObject thisSemanticEvent = thisEvent.resolveTargetSemanticElement();
        SequenceDiagramEditPart sdep = EditPartsHelper.getSequenceDiagramPart((IGraphicalEditPart)thisEvent);
        Range thisRange = thisEvent.getISequenceEvent().getVerticalRange();
        Point location = request.getLocation().getCopy();
        Predicate<SingleEventEnd> toMove = new Predicate<SingleEventEnd>(){

            public boolean apply(SingleEventEnd input) {
                return !input.getSemanticEvent().equals(thisSemanticEvent);
            }
        };
        Dimension resizeDelta = this.getResizeDelta(location.getCopy(), thisEvent, thisRange, fromTop);
        for (CompoundEventEnd cee : Iterables.filter(ends, CompoundEventEnd.class)) {
            for (SingleEventEnd see : Iterables.filter((Iterable)Lists.newArrayList((Iterable)cee.getEventEnds()), (Predicate)toMove)) {
                ISequenceEventEditPart ise = EditPartsHelper.findISequenceEvent(see, sdep);
                ISequenceEvent sequenceEvent = ise.getISequenceEvent();
                ChangeBoundsRequest cbr = this.buildChangeBoundRequest(location.getCopy(), ise, see, resizeDelta);
                if (sequenceEvent instanceof AbstractNodeEvent) {
                    cbr.getExtendedData().put(REQUEST_FROM_SEQUENCE_MESSAGE_EDIT_POLICY, true);
                }
                ctc.compose((IUndoableOperation)new CommandProxy(ise.getCommand((Request)cbr)));
            }
        }
    }

    private ChangeBoundsRequest buildChangeBoundRequest(Point point, ISequenceEventEditPart ise, SingleEventEnd see, Dimension resizeDelta) {
        ChangeBoundsRequest cbr = new ChangeBoundsRequest((Object)"resize");
        cbr.setLocation(point);
        cbr.setEditParts((EditPart)ise);
        cbr.setConstrainedResize(true);
        if (see.isStart()) {
            cbr.setResizeDirection(1);
            cbr.setMoveDelta(new Point(0, resizeDelta.height));
            cbr.setSizeDelta(resizeDelta.getNegated());
            cbr.setConstrainedMove(true);
        } else {
            cbr.setResizeDirection(4);
            cbr.setSizeDelta(resizeDelta);
            cbr.setConstrainedResize(true);
        }
        return cbr;
    }

    private Dimension getResizeDelta(Point location, ISequenceEventEditPart ise, Range range, boolean fromTop) {
        GraphicalHelper.screen2logical((Point)location, (GraphicalEditPart)ise);
        int deltaY = location.y - (fromTop ? range.getLowerBound() : range.getUpperBound());
        deltaY = (int)((double)deltaY * GraphicalHelper.getZoom((EditPart)ise));
        return new Dimension(0, deltaY);
    }

    private AbstractEMFOperation getMoveDestroyMessageCommand(BendpointRequest br, SequenceMessageEditPart smep, Command baseCommand) {
        CompositeTransactionalCommand ctc = new CompositeTransactionalCommand(smep.getEditingDomain(), Messages.SequenceMessageEditPolicy_moveCreateMessageCommand);
        if (smep.getSource() instanceof ISequenceEventEditPart) {
            ISequenceEventEditPart source = (ISequenceEventEditPart)smep.getSource();
            Range sourceRange = source.getISequenceEvent().getVerticalRange();
            Range lowerLimit = new Range(sourceRange.getLowerBound() - 5, sourceRange.getLowerBound() + 5);
            Range upperLimit = new Range(sourceRange.getUpperBound() - 5, sourceRange.getUpperBound() + 5);
            Point wantedLocation = br.getLocation().getCopy();
            GraphicalHelper.screen2logical((Point)wantedLocation, (GraphicalEditPart)smep);
            if (lowerLimit.includes(wantedLocation.y) || upperLimit.includes(wantedLocation.y)) {
                ctc.compose((IUndoableOperation)UnexecutableCommand.INSTANCE);
                return ctc;
            }
        }
        EndOfLifeEditPart endOfLifeEditPart = (EndOfLifeEditPart)smep.getTarget();
        LifelineEditPart lifelineEditPart = (LifelineEditPart)endOfLifeEditPart.getParent();
        ChangeBoundsRequest cbr = SequenceMessageEditPolicy.getEndOfLifeMoveRequest(endOfLifeEditPart, br.getLocation().getCopy());
        ctc.compose((IUndoableOperation)new CommandProxy(endOfLifeEditPart.getCommand((Request)cbr)));
        if (ctc.canExecute()) {
            ctc.compose((IUndoableOperation)new CommandProxy(baseCommand));
            this.updateMovingTargetReferencePoint(baseCommand, cbr);
            TransactionalEditingDomain editingDomain = smep.getEditingDomain();
            ctc.compose((IUndoableOperation)CommandFactory.createICommand((TransactionalEditingDomain)editingDomain, (AbstractModelChangeOperation)new ShiftDescendantMessagesOperation(lifelineEditPart.getISequenceEvent(), cbr.getSizeDelta().height, true, false, false)));
        }
        return ctc;
    }

    private static ChangeBoundsRequest getEndOfLifeMoveRequest(EndOfLifeEditPart endOfLifeEditPart, Point location) {
        ChangeBoundsRequest cbr = new ChangeBoundsRequest((Object)"move");
        cbr.setEditParts((EditPart)endOfLifeEditPart);
        cbr.setLocation(location.getCopy());
        cbr.setConstrainedMove(true);
        double zoom = GraphicalHelper.getZoom((EditPart)endOfLifeEditPart);
        GraphicalHelper.screen2logical((Point)location, (GraphicalEditPart)endOfLifeEditPart);
        Rectangle bounds = endOfLifeEditPart.getFigure().getBounds();
        int delta = location.y - bounds.getCenter().y;
        cbr.setMoveDelta((Point)new PrecisionPoint(0.0, (double)delta * zoom));
        return cbr;
    }

    private AbstractEMFOperation getMoveCreateMessageCommand(BendpointRequest request, SequenceMessageEditPart smep, Command baseCommand) {
        int sourceRangeLimit;
        Point normalizedLocation = request.getLocation().getCopy();
        GraphicalHelper.screen2logical((Point)normalizedLocation, (GraphicalEditPart)smep);
        InstanceRoleEditPart instanceRoleEditPart = (InstanceRoleEditPart)smep.getTarget();
        LifelineEditPart lifelineEditPart = (LifelineEditPart)Iterables.getOnlyElement(EditPartsHelper.getAllLifelines((IGraphicalEditPart)instanceRoleEditPart));
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(smep.getEditingDomain(), Messages.SequenceMessageEditPolicy_moveCreateMessageCommand);
        int firstMessageInTargetInstanceRole = lifelineEditPart.getISequenceEvent().getVerticalRange().getUpperBound() - 5;
        Range occupiedRange = lifelineEditPart.getISequenceEvent().getOccupiedRange();
        if (!occupiedRange.isEmpty()) {
            firstMessageInTargetInstanceRole = occupiedRange.getLowerBound() - 5;
        }
        if (normalizedLocation.y > (sourceRangeLimit = this.computeSourceRangeLimit(smep, normalizedLocation, firstMessageInTargetInstanceRole))) {
            cc.compose((IUndoableOperation)UnexecutableCommand.INSTANCE);
            return cc;
        }
        ChangeBoundsRequest cbr = new ChangeBoundsRequest((Object)"move");
        cbr.getMoveDelta().setY(sourceRangeLimit - (instanceRoleEditPart.getFigure().getBounds().y + instanceRoleEditPart.getFigure().getBounds().height / 2));
        cbr.setConstrainedMove(true);
        cbr.setEditParts((EditPart)instanceRoleEditPart);
        cc.compose((IUndoableOperation)new CommandProxy(instanceRoleEditPart.getCommand((Request)cbr)));
        cc.compose((IUndoableOperation)new CommandProxy(baseCommand));
        LifelineEditPart lep = EditPartsHelper.getAllLifelines((IGraphicalEditPart)instanceRoleEditPart).get(0);
        TransactionalEditingDomain editingDomain = smep.getEditingDomain();
        cc.compose((IUndoableOperation)CommandFactory.createICommand((TransactionalEditingDomain)editingDomain, (AbstractModelChangeOperation)new EndOfLifeMoveOperation((Lifeline)lep.getISequenceEvent(), -cbr.getMoveDelta().y)));
        cc.compose((IUndoableOperation)CommandFactory.createICommand((TransactionalEditingDomain)editingDomain, (AbstractModelChangeOperation)new ShiftDirectSubExecutionsOperation(lep.getISequenceEvent(), -cbr.getMoveDelta().y)));
        cc.compose((IUndoableOperation)CommandFactory.createICommand((TransactionalEditingDomain)editingDomain, (AbstractModelChangeOperation)new ShiftDescendantMessagesOperation(lep.getISequenceEvent(), cbr.getMoveDelta().y, true, false, true)));
        return cc;
    }

    private void updateMovingTargetReferencePoint(Command baseCommand, ChangeBoundsRequest cbr) {
        if (baseCommand instanceof ICommandProxy && ((ICommandProxy)baseCommand).getICommand() instanceof SetConnectionBendpointsCommand) {
            SetConnectionBendpointsCommand scbc = (SetConnectionBendpointsCommand)((ICommandProxy)baseCommand).getICommand();
            scbc.setNewPointList(scbc.getNewPointList(), scbc.getSourceRefPoint(), scbc.getTargetRefPoint().getCopy().getTranslated(cbr.getMoveDelta()));
        }
    }

    private int computeSourceRangeLimit(SequenceMessageEditPart smep, Point normalizedLocation, int firstMessageInTargetInstanceRole) {
        int sourceRangeLimit = normalizedLocation.y;
        Range sourceRange = smep.getISequenceEvent().getVerticalRange();
        Range lowerLimit = new Range(sourceRange.getLowerBound(), sourceRange.getLowerBound() + 5);
        Range upperLimit = new Range(sourceRange.getUpperBound() - 5, sourceRange.getUpperBound());
        if (firstMessageInTargetInstanceRole < sourceRangeLimit + 5) {
            sourceRangeLimit = firstMessageInTargetInstanceRole - 5;
        } else if (lowerLimit.includes(sourceRangeLimit)) {
            sourceRangeLimit = lowerLimit.getUpperBound();
        } else if (upperLimit.includes(sourceRangeLimit)) {
            sourceRangeLimit = upperLimit.getLowerBound();
        }
        return sourceRangeLimit;
    }

    private boolean validateMessageParentOperand(Option<Range> finalRange) {
        boolean valid = true;
        SequenceMessageEditPart thisEvent = (SequenceMessageEditPart)this.getHost();
        Message message = (Message)thisEvent.getISequenceEvent();
        Option sourceLifeline = message.getSourceLifeline();
        Option targetLifeline = message.getTargetLifeline();
        if (finalRange.some() && sourceLifeline.some() && targetLifeline.some()) {
            Option sourceFinalOperand = Options.newNone();
            Option targetFinalOperand = Options.newNone();
            if (((Lifeline)sourceLifeline.get()).equals(targetLifeline.get())) {
                int lBound = ((Range)finalRange.get()).getLowerBound();
                int uBound = ((Range)finalRange.get()).getUpperBound();
                sourceFinalOperand = ((Lifeline)sourceLifeline.get()).getParentOperand(new Range(lBound, lBound));
                targetFinalOperand = ((Lifeline)targetLifeline.get()).getParentOperand(new Range(uBound, uBound));
            } else {
                sourceFinalOperand = ((Lifeline)sourceLifeline.get()).getParentOperand((Range)finalRange.get());
                targetFinalOperand = ((Lifeline)targetLifeline.get()).getParentOperand((Range)finalRange.get());
            }
            valid = sourceFinalOperand.get() == targetFinalOperand.get();
        }
        return valid;
    }

    private static class MoveType {
        private boolean fromTop;
        private boolean needsCompoundMove;

        MoveType(boolean needsCompoundMove, boolean fromTop) {
            this.fromTop = fromTop;
            this.needsCompoundMove = needsCompoundMove;
        }

        public boolean isFromTop() {
            return this.fromTop;
        }

        public boolean needsCompoundMove() {
            return this.needsCompoundMove;
        }

        public String toString() {
            return "[fromTop:" + this.fromTop + ", compound:" + this.needsCompoundMove + "]";
        }
    }
}

