/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.query;

import com.google.common.collect.Iterables;
import java.util.Objects;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.sirius.diagram.AbsoluteBoundsFilter;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElement;

public class ISequenceElementQuery {
    protected final ISequenceElement event;

    public ISequenceElementQuery(ISequenceElement event) {
        this.event = Objects.requireNonNull(event);
    }

    public boolean hasAbsoluteBoundsFlag() {
        if (this.event.getNotationView() != null && this.event.getNotationView().getElement() instanceof DDiagramElement) {
            DDiagramElement dde = (DDiagramElement)this.event.getNotationView().getElement();
            return !Iterables.isEmpty((Iterable)Iterables.filter((Iterable)dde.getGraphicalFilters(), AbsoluteBoundsFilter.class));
        }
        return false;
    }

    public Rectangle getFlaggedAbsoluteBounds() {
        DDiagramElement dde;
        Iterable flags;
        Rectangle bounds = new Rectangle();
        if (this.event.getNotationView() != null && this.event.getNotationView().getElement() instanceof DDiagramElement && !Iterables.isEmpty((Iterable)(flags = Iterables.filter((Iterable)(dde = (DDiagramElement)this.event.getNotationView().getElement()).getGraphicalFilters(), AbsoluteBoundsFilter.class)))) {
            AbsoluteBoundsFilter flag = (AbsoluteBoundsFilter)flags.iterator().next();
            bounds.setX(this.safeGetInt(flag.getX()));
            bounds.setY(this.safeGetInt(flag.getY()));
            bounds.setWidth(this.safeGetInt(flag.getWidth()));
            bounds.setHeight(this.safeGetInt(flag.getHeight()));
        }
        return bounds;
    }

    private int safeGetInt(Integer i) {
        return i == null ? 0 : i;
    }
}

