/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.colors;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.description.DAnnotationEntry;
import org.eclipse.sirius.viewpoint.description.DescriptionFactory;
import org.eclipse.swt.graphics.RGB;

public final class ColorsAnnotationHelper {
    private static final String RGB_VALUES_SEPARATOR = ",";
    private final Session session;
    private Optional<DAnalysis> optDanalysis;

    public ColorsAnnotationHelper(Session session) {
        this.session = session;
        this.optDanalysis = session != null ? this.session.getSharedMainDAnalysis() : Optional.empty();
    }

    public void initializeAllColorsAnnotations() {
        this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(this.session.getTransactionalEditingDomain()){

            protected void doExecute() {
                String[] annotationSources;
                String[] stringArray = annotationSources = new String[]{"FillCustomColors", "FillSuggestedColors", "FontCustomColors", "FontSuggestedColors", "LineCustomColors", "LineSuggestedColors"};
                int n = annotationSources.length;
                int n2 = 0;
                while (n2 < n) {
                    String source = stringArray[n2];
                    Optional<DAnnotationEntry> optAnnotation = ColorsAnnotationHelper.this.getOrCreateColorAnnotationEntry(source);
                    optAnnotation.ifPresent(annotation -> ColorsAnnotationHelper.this.addColorAnnotation((DAnnotationEntry)annotation));
                    ++n2;
                }
            }
        });
    }

    private Optional<DAnnotationEntry> getOrCreateColorAnnotationEntry(String colorsAnnotationSourceName) {
        Optional<DAnnotationEntry> dAnnotationEntry = Optional.empty();
        if (this.optDanalysis.isPresent()) {
            dAnnotationEntry = Optional.of(this.getColorAnnotationEntry(colorsAnnotationSourceName).orElseGet(() -> {
                DAnnotationEntry annotationEntry = DescriptionFactory.eINSTANCE.createDAnnotationEntry();
                annotationEntry.setSource(colorsAnnotationSourceName);
                return annotationEntry;
            }));
        }
        return dAnnotationEntry;
    }

    private Optional<DAnnotationEntry> getColorAnnotationEntry(String colorsAnnotationSourceName) {
        if (this.optDanalysis.isPresent()) {
            EList sessionAnnotations = this.optDanalysis.get().getEAnnotations();
            for (DAnnotationEntry annotationEntry : sessionAnnotations) {
                if (!annotationEntry.getSource().equals(colorsAnnotationSourceName)) continue;
                return Optional.of(annotationEntry);
            }
        }
        return Optional.empty();
    }

    public void setColorsDetails(final String colorsAnnotationSourceName, final List<RGB> colorsList) {
        this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(this.session.getTransactionalEditingDomain()){

            protected void doExecute() {
                Optional<DAnnotationEntry> optColorsEntry = ColorsAnnotationHelper.this.getOrCreateColorAnnotationEntry(colorsAnnotationSourceName);
                optColorsEntry.ifPresent(colorsEntry -> {
                    List<String> stringColorsList = ColorsAnnotationHelper.this.convertRGBToString(colorsList);
                    EList colorDetails = colorsEntry.getDetails();
                    colorDetails.clear();
                    colorDetails.addAll(stringColorsList);
                    if (!colorDetails.isEmpty()) {
                        ColorsAnnotationHelper.this.addColorAnnotation((DAnnotationEntry)colorsEntry);
                    }
                });
            }
        });
    }

    public List<RGB> getColorsDetails(String colorsAnnotationSourceName) {
        ArrayList<RGB> colors = new ArrayList<RGB>();
        Optional<DAnnotationEntry> optAnnotationEntry = this.getColorAnnotationEntry(colorsAnnotationSourceName);
        optAnnotationEntry.ifPresent(annotationEntry -> {
            EList details = annotationEntry.getDetails();
            colors.addAll(this.convertStringToRGB((List<String>)details));
        });
        return colors;
    }

    private List<String> convertRGBToString(List<RGB> colorsList) {
        ArrayList<String> stringColorsList = new ArrayList<String>();
        if (colorsList != null) {
            for (RGB rgb : colorsList) {
                String stringColor = rgb.red + RGB_VALUES_SEPARATOR + rgb.green + RGB_VALUES_SEPARATOR + rgb.blue;
                stringColorsList.add(stringColor);
            }
        }
        return stringColorsList;
    }

    private List<RGB> convertStringToRGB(List<String> stringColorsList) {
        ArrayList<RGB> colors = new ArrayList<RGB>();
        if (stringColorsList != null) {
            for (String stringColor : stringColorsList) {
                String[] stringToParseArray = stringColor.split(RGB_VALUES_SEPARATOR);
                RGB color = new RGB(Integer.parseInt(stringToParseArray[0]), Integer.parseInt(stringToParseArray[1]), Integer.parseInt(stringToParseArray[2]));
                colors.add(color);
            }
        }
        return colors;
    }

    private void addColorAnnotation(DAnnotationEntry colorsEntry) {
        this.optDanalysis.ifPresent(dAnalysis -> {
            boolean bl = dAnalysis.getEAnnotations().add((Object)colorsEntry);
        });
    }
}

