/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.tool.internal.validation.description.constraints;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.sequence.description.InteractionContainerMapping;
import org.eclipse.sirius.diagram.sequence.description.SequenceDiagramDescription;

public class UniqueInteractionContainerMappingConstraints
extends AbstractModelConstraint {
    public static final String UNIQUE_INTERACTION_CONTAINER_MAPPING_ID = "org.eclipse.sirius.diagram.sequence.UniqueInteractionContainerMapping";

    public IStatus validate(IValidationContext ctx) {
        IStatus result = ctx.createSuccessStatus();
        EObject eObj = ctx.getTarget();
        if (UNIQUE_INTERACTION_CONTAINER_MAPPING_ID.equals(ctx.getCurrentConstraintId())) {
            result = this.validateUniqueInteractionContainerMapping(ctx, eObj);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private IStatus validateUniqueInteractionContainerMapping(IValidationContext ctx, EObject eObj) {
        LinkedHashSet<Object> layersToInspect = new LinkedHashSet<Object>();
        EObject eObject = eObj;
        if (eObject instanceof SequenceDiagramDescription) {
            void sequenceDiagramDescription;
            SequenceDiagramDescription sequenceDiagramDescription2 = (SequenceDiagramDescription)eObject;
            SequenceDiagramDescription cfr_ignored_0 = (SequenceDiagramDescription)eObject;
            Layer defaultLayer = sequenceDiagramDescription.getDefaultLayer();
            if (defaultLayer != null) {
                layersToInspect.add(defaultLayer);
            }
            layersToInspect.addAll((Collection<Object>)sequenceDiagramDescription.getAdditionalLayers());
        } else {
            EObject eObject2 = eObj;
            if (eObject2 instanceof Layer) {
                void layer2;
                Layer defaultLayer = (Layer)eObject2;
                Layer cfr_ignored_1 = (Layer)eObject2;
                layersToInspect.add(layer2);
            }
        }
        Stream<InteractionContainerMapping> interactionMappings = layersToInspect.stream().flatMap(layer -> layer.eContents().stream()).filter(InteractionContainerMapping.class::isInstance).map(InteractionContainerMapping.class::cast);
        List<InteractionContainerMapping> interactionContainerMappingList = interactionMappings.toList();
        if (interactionContainerMappingList.size() > 1) {
            String interactionContainerMappingNames = interactionContainerMappingList.stream().map(icm -> icm.getName()).collect(Collectors.joining(", "));
            return ctx.createFailureStatus(new Object[]{interactionContainerMappingNames});
        }
        return ctx.createSuccessStatus();
    }
}

