/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.description.tool.NodeCreationDescription;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.VerticalPositionFunction;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.CombinedFragment;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.description.tool.CombinedFragmentCreationTool;
import org.eclipse.sirius.diagram.sequence.description.tool.ExecutionCreationTool;
import org.eclipse.sirius.diagram.sequence.description.tool.InteractionUseCreationTool;
import org.eclipse.sirius.diagram.sequence.description.tool.ObservationPointCreationTool;
import org.eclipse.sirius.diagram.sequence.description.tool.OperandCreationTool;
import org.eclipse.sirius.diagram.sequence.description.tool.StateCreationTool;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.command.SequenceDelegatingCommandFactory;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.SequenceDiagramEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.StateEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.layout.SequenceGraphicalHelper;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.EditPartsHelper;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.CreationUtil;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.NodeCreationEditPolicy;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.api.requests.DistributeRequest;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;

public class SequenceNodeCreationPolicy
extends NodeCreationEditPolicy {
    protected Command getCreateCommand(CreateRequest request) {
        Option<SequenceDiagramEditPart> sdep = this.shouldRetargetToDiagram(request);
        if (sdep.some()) {
            return ((SequenceDiagramEditPart)((Object)sdep.get())).getCommand((Request)request);
        }
        return super.getCreateCommand(request);
    }

    private Option<SequenceDiagramEditPart> shouldRetargetToDiagram(CreateRequest request) {
        IGraphicalEditPart self;
        SequenceDiagramEditPart sdep;
        AbstractToolDescription tool;
        if ("create child".equals(request.getType()) && !(this.getHost() instanceof StateEditPart) && ((tool = this.getTool(request)) instanceof InteractionUseCreationTool || tool instanceof CombinedFragmentCreationTool) && (sdep = EditPartsHelper.getSequenceDiagramPart(self = (IGraphicalEditPart)this.getHost())) != null) {
            Map extData = request.getExtendedData();
            extData.put("original.target", this.getHost());
            return Options.newSome((Object)((Object)sdep));
        }
        return Options.newNone();
    }

    public void showTargetFeedback(Request request) {
        Option<SequenceDiagramEditPart> sdep;
        if (request instanceof CreateRequest && (sdep = this.shouldRetargetToDiagram((CreateRequest)request)).some() && ((SequenceDiagramEditPart)((Object)sdep.get())).getEditPolicy("ContainerEditPolicy") != null) {
            ((SequenceDiagramEditPart)((Object)sdep.get())).getEditPolicy("ContainerEditPolicy").showTargetFeedback(request);
        }
        super.showTargetFeedback(request);
    }

    public void eraseTargetFeedback(Request request) {
        Option<SequenceDiagramEditPart> sdep;
        if (request instanceof CreateRequest && (sdep = this.shouldRetargetToDiagram((CreateRequest)request)).some() && ((SequenceDiagramEditPart)((Object)sdep.get())).getEditPolicy("ContainerEditPolicy") != null) {
            ((SequenceDiagramEditPart)((Object)sdep.get())).getEditPolicy("ContainerEditPolicy").eraseTargetFeedback(request);
        }
        super.eraseTargetFeedback(request);
    }

    protected Command getCreateNodeOnNodeCommand(CreateRequest request, NodeCreationDescription tool, DNode viewnode, EditPart parentEditPartToUse) {
        if (tool instanceof ExecutionCreationTool || tool instanceof StateCreationTool || tool instanceof ObservationPointCreationTool) {
            SequenceDiagram sequenceDiagram = EditPartsHelper.getSequenceDiagram(this.getHost());
            SequenceDDiagram diagram = sequenceDiagram.getSequenceDDiagram();
            Point location = request.getLocation().getCopy();
            GraphicalHelper.screen2logical((Point)location, (GraphicalEditPart)((IGraphicalEditPart)this.getHost()));
            EventEnd startingEndPredecessor = SequenceGraphicalHelper.getEndBefore(diagram, location.y);
            EventEnd startingEndSuccessor = SequenceGraphicalHelper.getEndAfter(diagram, location.y);
            if (tool instanceof ExecutionCreationTool) {
                Point bottomRight = location.getCopy().getTranslated(0, 1);
                bottomRight = new Point(location.x + 20, this.computeBottomY(diagram, location, startingEndSuccessor));
                GraphicalHelper.logical2screen((Point)bottomRight, (IGraphicalEditPart)((IGraphicalEditPart)this.getHost()));
                request.setSize(new Dimension(20, 30));
            }
            CreationUtil creationUtil = new CreationUtil(this.getDiagramCommandFactory(startingEndPredecessor, startingEndPredecessor, location), this.getRealLocation(request, parentEditPartToUse), request.getSize(), this.getHost());
            return creationUtil.getNodeCreationCommand(viewnode, tool);
        }
        return super.getCreateNodeOnNodeCommand(request, tool, viewnode, parentEditPartToUse);
    }

    protected Command getCreateContainerInContainerCommand(CreateRequest request, ContainerCreationDescription tool, DDiagramElementContainer viewNodeContainer) {
        Command result;
        if (this.isCreatingOperandInCombinedFragment(tool, viewNodeContainer)) {
            Option<Operand> operand = this.getOperand(viewNodeContainer);
            if (operand.some()) {
                SequenceDiagram sequenceDiagram = EditPartsHelper.getSequenceDiagram(this.getHost());
                SequenceDDiagram diagram = sequenceDiagram.getSequenceDDiagram();
                EventEnd startingEndPredecessor = SequenceGraphicalHelper.getEndBefore(diagram, ((Operand)operand.get()).getVerticalRange().getUpperBound() - 1);
                Point location = request.getLocation().getCopy();
                GraphicalHelper.screen2logical((Point)location, (GraphicalEditPart)((IGraphicalEditPart)this.getHost()));
                CreationUtil creationUtil = new CreationUtil(request, this.getDiagramCommandFactory(startingEndPredecessor, startingEndPredecessor, location), this.getRealLocation(request, this.getHost()), this.getHost());
                result = creationUtil.getContainerCreationDescription((DDiagramElementContainer)viewNodeContainer.eContainer(), tool);
            } else {
                result = UnexecutableCommand.INSTANCE;
            }
        } else {
            result = super.getCreateContainerInContainerCommand(request, tool, viewNodeContainer);
        }
        return result;
    }

    private Option<Operand> getOperand(DDiagramElementContainer viewNodeContainer) {
        Collection views = ISequenceElementAccessor.getViewsForSemanticElement((SequenceDDiagram)((SequenceDDiagram)viewNodeContainer.getParentDiagram()), (EObject)viewNodeContainer.getTarget());
        ArrayList operandViews = Lists.newArrayList((Iterable)Iterables.filter((Iterable)views, (Predicate)Operand.notationPredicate()));
        for (View view : operandViews) {
            Option optOperand = ISequenceElementAccessor.getOperand((View)view);
            if (!optOperand.some()) continue;
            return optOperand;
        }
        return Options.newNone();
    }

    private boolean isCreatingOperandInCombinedFragment(ContainerCreationDescription tool, DDiagramElementContainer viewNodeContainer) {
        return tool instanceof OperandCreationTool && Operand.viewpointElementPredicate().apply((Object)viewNodeContainer) && CombinedFragment.viewpointElementPredicate().apply((Object)((DDiagramElement)viewNodeContainer.eContainer()));
    }

    private int computeBottomY(SequenceDDiagram diagram, Point location, EventEnd startingEndSuccessor) {
        int parentBottomMargin = 5;
        int nextY = startingEndSuccessor != null ? new VerticalPositionFunction(diagram).apply(startingEndSuccessor) : location.y + 30 + parentBottomMargin;
        int bottomY = Math.max(location.y + 30, nextY - parentBottomMargin);
        return bottomY;
    }

    private IDiagramCommandFactory getDiagramCommandFactory(EventEnd startingEndPredecessor, EventEnd finishingEndPredecessor, Point location) {
        EditPart host = this.getHost();
        SequenceDiagram seqDiag = EditPartsHelper.getSequenceDiagram(host);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)seqDiag.getNotationDiagram());
        DDiagramEditor diagramEditor = (DDiagramEditor)this.getHost().getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
        if (diagramEditor == null) {
            return null;
        }
        Object adapter = diagramEditor.getAdapter(IDiagramCommandFactoryProvider.class);
        IDiagramCommandFactoryProvider cmdFactoryProvider = (IDiagramCommandFactoryProvider)adapter;
        IDiagramCommandFactory diagramCommandFactory = cmdFactoryProvider.getCommandFactory(domain);
        return new SequenceDelegatingCommandFactory(diagramCommandFactory, domain, seqDiag, startingEndPredecessor, finishingEndPredecessor, location);
    }

    protected Command getDistributeCommand(DistributeRequest request) {
        return UnexecutableCommand.INSTANCE;
    }
}

