/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.disco.debug.views;

import java.util.Arrays;
import org.eclipse.elk.alg.disco.debug.views.DisCoGraphRenderingConfigurator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.widgets.Display;

public class DisCoGraphRenderingFillPatterns {
    private DisCoGraphRenderingConfigurator config;
    private Display display;
    private int scale;

    public DisCoGraphRenderingFillPatterns(DisCoGraphRenderingConfigurator config, double scale) {
        this.config = config;
        this.display = config.getDisplay();
        this.scale = (int)scale;
    }

    public Pattern getDCExtensionPattern(int alpha) {
        ImageData imData = new ImageData(6 * this.scale, 6 * this.scale, 24, new PaletteData(0xFF0000, 65280, 255));
        imData.setAlpha(0, 0, 0);
        Arrays.fill(imData.alphaData, (byte)0);
        Image image = new Image((Device)this.display, imData);
        Color fill = this.config.getDCElementExternalFillColor();
        GC gc = new GC((Drawable)image);
        gc.setBackground(fill);
        gc.setAlpha(alpha);
        this.fillRectangle(gc, this.scale, 4, 0, 2, 2);
        this.fillRectangle(gc, this.scale, 2, 2, 2, 2);
        this.fillRectangle(gc, this.scale, 0, 4, 2, 2);
        gc.dispose();
        return new Pattern((Device)this.display, image);
    }

    public Pattern getPolyominoExtensionPattern(int alpha) {
        ImageData imData = new ImageData(6 * this.scale, 6 * this.scale, 24, new PaletteData(0xFF0000, 65280, 255));
        imData.setAlpha(0, 0, 0);
        Arrays.fill(imData.alphaData, (byte)0);
        Image image = new Image((Device)this.display, imData);
        Color fill = this.config.getPolyominoWeaklyBlockedColor();
        GC gc = new GC((Drawable)image);
        gc.setBackground(fill);
        gc.setAlpha(alpha);
        this.fillRectangle(gc, this.scale, 0, 0, 2, 2);
        this.fillRectangle(gc, this.scale, 2, 2, 2, 2);
        this.fillRectangle(gc, this.scale, 4, 4, 2, 2);
        gc.dispose();
        if (this.scale != 1) {
            imData = image.getImageData();
            image.dispose();
            imData.scaledTo(imData.width * this.scale, imData.height * this.scale);
            image = new Image((Device)this.display, imData);
        }
        return new Pattern((Device)this.display, image);
    }

    public Pattern getPolyominoCenterPattern(int alpha) {
        ImageData imData = new ImageData(6 * this.scale, 6 * this.scale, 24, new PaletteData(0xFF0000, 65280, 255));
        imData.setAlpha(0, 0, 0);
        Arrays.fill(imData.alphaData, (byte)0);
        Image image = new Image((Device)this.display, imData);
        Color fill = this.config.getPolyominoCenterColor();
        GC gc = new GC((Drawable)image);
        gc.setBackground(fill);
        gc.setAlpha(alpha);
        this.fillRectangle(gc, this.scale, 2, 0, 2, 2);
        this.fillRectangle(gc, this.scale, 0, 2, 2, 2);
        this.fillRectangle(gc, this.scale, 4, 2, 2, 2);
        this.fillRectangle(gc, this.scale, 2, 4, 2, 2);
        gc.dispose();
        return new Pattern((Device)this.display, image);
    }

    private void fillRectangle(GC gc, int scaling, int x, int y, int width, int height) {
        gc.fillRectangle(x * scaling, y * scaling, width * scaling, height * scaling);
    }
}

