/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.ui.views;

import org.eclipse.elk.core.ui.views.LayoutViewPart;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class MultipleOptionsCellEditor
extends DialogCellEditor {
    private String[] items;
    private boolean decoratedItemValues;

    public MultipleOptionsCellEditor(Composite parent, String[] items, boolean enumerationSet) {
        super(parent);
        this.items = items;
        this.decoratedItemValues = enumerationSet;
    }

    protected Control createContents(final Composite cell) {
        Control label = super.createContents(cell);
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Object newValue = MultipleOptionsCellEditor.this.openDialogBox((Control)cell);
                if (newValue != null) {
                    MultipleOptionsCellEditor.this.markDirty();
                    MultipleOptionsCellEditor.this.doSetValue(newValue);
                    MultipleOptionsCellEditor.this.fireApplyEditorValue();
                } else {
                    MultipleOptionsCellEditor.this.fireCancelEditor();
                }
                LayoutViewPart layoutView = LayoutViewPart.findView();
                if (layoutView != null) {
                    layoutView.setFocus();
                }
            }
        });
        return label;
    }

    protected void updateContents(Object value) {
        if (value instanceof String[]) {
            String[] strArray = (String[])value;
            if (strArray.length == 0) {
                super.updateContents((Object)"");
            } else {
                StringBuilder text = new StringBuilder();
                String[] stringArray = strArray;
                int n = strArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    text.append(", " + item);
                    ++n2;
                }
                super.updateContents((Object)text.substring(2));
            }
        }
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        ListSelectionDialog dialog = new ListSelectionDialog(cellEditorWindow.getShell(), (Object)this.items, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new LabelProvider(), null);
        dialog.setInitialSelections((Object[])this.matchSelectionToItems((String[])this.getValue()));
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            String[] stringResult = new String[result.length];
            int i = 0;
            while (i < result.length) {
                stringResult[i] = this.stripDecorator((String)result[i]);
                ++i;
            }
            return stringResult;
        }
        return null;
    }

    private String stripDecorator(String text) {
        int spaceIndex;
        if (this.decoratedItemValues && (spaceIndex = text.indexOf(32)) != -1) {
            return text.substring(0, spaceIndex);
        }
        return text;
    }

    private String[] matchSelectionToItems(String[] selection) {
        if (this.decoratedItemValues) {
            String[] selectedItems = new String[selection.length];
            int i = 0;
            while (i < selectedItems.length) {
                String[] stringArray = this.items;
                int n = this.items.length;
                int n2 = 0;
                while (n2 < n) {
                    String candidate = stringArray[n2];
                    if (candidate.startsWith(selection[i])) {
                        selectedItems[i] = candidate;
                        break;
                    }
                    ++n2;
                }
                ++i;
            }
            return selectedItems;
        }
        return selection;
    }
}

