/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.ui.rendering;

import org.eclipse.elk.core.ui.rendering.GraphRenderingCanvas;
import org.eclipse.elk.core.ui.rendering.GraphRenderingConfigurator;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class LayoutGraphDialog
extends Dialog {
    private final ElkNode graph;
    private final Resource resource;
    private final GraphRenderingConfigurator configurator;
    private GraphRenderingCanvas graphCanvas;

    public LayoutGraphDialog(ElkNode graph, Resource resource, GraphRenderingConfigurator configurator, Shell parentShell) {
        super(parentShell);
        this.graph = graph;
        this.resource = resource;
        this.configurator = configurator;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        String fileName = null;
        if (this.resource != null && this.resource.getURI() != null) {
            fileName = this.resource.getURI().lastSegment();
        }
        if (fileName == null || fileName.isEmpty()) {
            shell.setText("Layout Graph");
        } else {
            shell.setText(fileName);
        }
    }

    protected Control createContents(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.graphCanvas = new GraphRenderingCanvas(parent, this.configurator);
        this.graphCanvas.setupMouseInteraction();
        this.graphCanvas.setLayoutGraph(this.graph);
        return this.graphCanvas;
    }
}

