/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.interpreter.internal.view.listener;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.sirius.ui.interpreter.internal.view.GeneratedTextDialog;
import org.eclipse.sirius.ui.interpreter.internal.view.InterpreterFile;
import org.eclipse.sirius.ui.interpreter.internal.view.InterpreterFileStorage;
import org.eclipse.sirius.ui.interpreter.internal.view.StorageEditorInput;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ResultDoubleClickListener
implements IDoubleClickListener {
    public void doubleClick(DoubleClickEvent event) {
        ISelection selection = event.getSelection();
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        Object target = ((IStructuredSelection)selection).getFirstElement();
        if (target instanceof InterpreterFile) {
            this.showGeneratedFile((InterpreterFile)target);
        } else if (target instanceof String && (((String)target).indexOf(10) >= 0 || ((String)target).indexOf(13) >= 0)) {
            GeneratedTextDialog dialog = new GeneratedTextDialog(Display.getCurrent().getActiveShell(), "Evaluation Result", (String)target);
            dialog.open();
        } else if (event.getViewer() instanceof TreeViewer && ((TreeViewer)event.getViewer()).isExpandable(target)) {
            TreeViewer viewer = (TreeViewer)event.getViewer();
            if (selection instanceof ITreeSelection) {
                TreePath[] paths = ((ITreeSelection)selection).getPathsFor(target);
                int i = 0;
                while (i < paths.length) {
                    viewer.setExpandedState((Object)paths[i], !viewer.getExpandedState((Object)paths[i]));
                    ++i;
                }
            } else {
                viewer.setExpandedState(target, !viewer.getExpandedState(target));
            }
        }
    }

    private void showGeneratedFile(InterpreterFile file) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench.getActiveWorkbenchWindow() == null || workbench.getActiveWorkbenchWindow().getActivePage() == null) {
            return;
        }
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        InterpreterFileStorage storage = new InterpreterFileStorage(file);
        IEditorDescriptor editor = workbench.getEditorRegistry().getDefaultEditor(file.getFileName());
        StorageEditorInput input = new StorageEditorInput(storage);
        try {
            String editorID = editor == null ? "org.eclipse.ui.DefaultTextEditor" : editor.getId();
            page.openEditor((IEditorInput)input, editorID);
        }
        catch (PartInitException partInitException) {}
    }
}

