/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.tex.core.model.build;

import org.eclipse.statet.docmlet.tex.core.ast.TexAstInfo;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.model.LtxSourceUnitModelInfo;
import org.eclipse.statet.docmlet.tex.core.model.TexSourceUnit;
import org.eclipse.statet.docmlet.tex.core.project.TexProject;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.internal.docmlet.tex.core.builder.TexTaskTagReporter;
import org.eclipse.statet.internal.docmlet.tex.core.model.AstProblemReporter;
import org.eclipse.statet.internal.docmlet.tex.core.model.LtxModelInspector;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;
import org.eclipse.statet.ltk.issues.core.TaskIssueConfig;
import org.eclipse.statet.ltk.model.core.build.BasicIssueReporter;

@NonNullByDefault
public class LtxIssueReporter
extends BasicIssueReporter<TexSourceUnit, LtxSourceUnitModelInfo> {
    private final AstProblemReporter astVisitor = new AstProblemReporter();
    private final LtxModelInspector modelCheck = new LtxModelInspector();
    private final TexTaskTagReporter taskReporter = new TexTaskTagReporter();

    public LtxIssueReporter() {
        super("Ltx");
    }

    protected TexTaskTagReporter getTaskReporter() {
        return this.taskReporter;
    }

    public void configure(PreferenceAccess prefs, @Nullable TexProject config) {
        super.configure(TaskIssueConfig.getConfig((PreferenceAccess)prefs));
    }

    protected void runReporters(TexSourceUnit sourceUnit, LtxSourceUnitModelInfo model, SourceContent content, IssueRequestor requestor, int level) {
        TexAstNode node;
        TexAstInfo ast = model.getAst();
        TexAstNode texAstNode = node = ast.getRoot() instanceof TexAstNode ? (TexAstNode)ast.getRoot() : null;
        if (this.shouldReportProblems()) {
            if (node != null) {
                this.astVisitor.run(sourceUnit, node, content, requestor);
            }
            this.modelCheck.run(model, content, requestor);
        }
        if (this.shouldReportTasks() && node != null) {
            this.taskReporter.run(sourceUnit, node, content, requestor);
        }
    }
}

