/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Cursor;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.HardLineBreak;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Inline;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.SoftLineBreak;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.SourceSpan;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class LineBreakSpan
extends SourceSpan {
    private static final Pattern PATTERN = Pattern.compile("( *(\\\\)?\n).*", 32);
    private final Matcher matcher = PATTERN.matcher("");

    @Override
    public @Nullable Inline createInline(ProcessingContext context, Cursor cursor) {
        Matcher matcher;
        char c = cursor.getChar();
        if ((c == '\n' || c == ' ') && (matcher = cursor.setup(this.matcher)).matches()) {
            int cursorLength = matcher.end(1) - matcher.regionStart();
            int startOffset = cursor.getOffset();
            int endOffset = cursor.getMatcherOffset(matcher.end(1));
            if (cursorLength > 2 || matcher.start(2) != -1) {
                return new HardLineBreak(cursor.getLineAtOffset(), startOffset, endOffset - startOffset, cursorLength);
            }
            return new SoftLineBreak(cursor.getLineAtOffset(), startOffset, endOffset - startOffset, cursorLength);
        }
        return null;
    }
}

