/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.util;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.statet.ecommons.ui.swt.SwtUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

@NonNullByDefault
public class SourceViewerEditorPreferenceUpdater {
    protected final ISourceViewer viewer;
    private final boolean manageColors;
    private final boolean manageFont;
    protected final IPreferenceStore preferenceStore;
    private @Nullable IPropertyChangeListener preferenceStoreListener;
    private @Nullable IPropertyChangeListener fontRegistryListener;

    public SourceViewerEditorPreferenceUpdater(SourceViewer viewer, boolean manageColors, boolean manageFont, IPreferenceStore preferenceStore) {
        Object listener;
        this.viewer = (ISourceViewer)ObjectUtils.nonNullAssert((Object)viewer);
        this.manageColors = manageColors;
        this.manageFont = manageColors;
        this.preferenceStore = (IPreferenceStore)ObjectUtils.nonNullAssert((Object)preferenceStore);
        StyledText textWidget = (StyledText)ObjectUtils.nonNullAssert((Object)viewer.getTextWidget());
        textWidget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SourceViewerEditorPreferenceUpdater.this.dispose();
            }
        });
        if (this.manageColors) {
            this.preferenceStoreListener = listener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String prefKey = event.getProperty();
                    boolean updateColors = SourceViewerEditorPreferenceUpdater.this.manageColors && ("AbstractTextEditor.Color.Foreground".equals(prefKey) || "AbstractTextEditor.Color.Foreground.SystemDefault".equals(prefKey) || "AbstractTextEditor.Color.Background".equals(prefKey) || "AbstractTextEditor.Color.Background.SystemDefault".equals(prefKey) || "AbstractTextEditor.Color.SelectionForeground".equals(prefKey) || "AbstractTextEditor.Color.SelectionForeground.SystemDefault".equals(prefKey) || "AbstractTextEditor.Color.SelectionBackground".equals(prefKey) || "AbstractTextEditor.Color.SelectionBackground.SystemDefault".equals(prefKey));
                    boolean updateFont = false;
                    if (updateColors) {
                        SourceViewerEditorPreferenceUpdater.this.update(updateColors, false);
                    }
                }
            };
            this.preferenceStore.addPropertyChangeListener(listener);
        }
        if (this.manageFont) {
            this.fontRegistryListener = listener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String prefKey = event.getProperty();
                    boolean updateFont = SourceViewerEditorPreferenceUpdater.this.getSymbolicFontName().equals(prefKey);
                    if (updateFont) {
                        SourceViewerEditorPreferenceUpdater.this.update(false, updateFont);
                    }
                }
            };
            JFaceResources.getFontRegistry().addListener(listener);
        }
        this.update(this.manageColors, this.manageFont);
    }

    public SourceViewerEditorPreferenceUpdater(SourceViewer viewer, IPreferenceStore preferenceStore) {
        this(viewer, true, true, preferenceStore);
    }

    protected String getSymbolicFontName() {
        return "org.eclipse.jface.textfont";
    }

    protected void update(boolean updateColors, boolean updateFont) {
        ISourceViewer viewer = this.viewer;
        StyledText styledText = viewer.getTextWidget();
        if (styledText != null && !styledText.isDisposed()) {
            if (updateColors) {
                this.updateColors(viewer, styledText);
            }
            if (updateFont) {
                this.updateFont(viewer, styledText);
            }
        }
    }

    protected void updateColors(ISourceViewer viewer, StyledText styledText) {
        Color color = this.preferenceStore.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault") ? null : this.createColor(this.preferenceStore, "AbstractTextEditor.Color.Foreground");
        styledText.setForeground(color);
        color = this.preferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? null : this.createColor(this.preferenceStore, "AbstractTextEditor.Color.Background");
        styledText.setBackground(color);
        color = this.preferenceStore.getBoolean("AbstractTextEditor.Color.SelectionForeground.SystemDefault") ? null : this.createColor(this.preferenceStore, "AbstractTextEditor.Color.SelectionForeground");
        styledText.setSelectionForeground(color);
        color = this.preferenceStore.getBoolean("AbstractTextEditor.Color.SelectionBackground.SystemDefault") ? null : this.createColor(this.preferenceStore, "AbstractTextEditor.Color.SelectionBackground");
        styledText.setSelectionBackground(color);
    }

    protected Color createColor(IPreferenceStore store, String key) {
        return SwtUtils.getColors().get(PreferenceConverter.getColor((IPreferenceStore)store, (String)key));
    }

    protected void updateFont(ISourceViewer viewer, StyledText styledText) {
        Font font = JFaceResources.getFont((String)this.getSymbolicFontName());
        styledText.setFont(font);
    }

    protected void dispose() {
        StyledText styledText;
        IPropertyChangeListener listener = this.preferenceStoreListener;
        if (listener != null) {
            this.preferenceStoreListener = null;
            this.preferenceStore.removePropertyChangeListener(listener);
        }
        if ((listener = this.fontRegistryListener) != null) {
            this.fontRegistryListener = null;
            JFaceResources.getFontRegistry().removeListener(listener);
        }
        if ((styledText = this.viewer.getTextWidget()) != null && !styledText.isDisposed()) {
            if (this.manageColors) {
                styledText.setForeground(null);
                styledText.setBackground(null);
                styledText.setSelectionForeground(null);
                styledText.setSelectionBackground(null);
            }
            if (this.manageFont) {
                styledText.setFont(null);
            }
        }
    }
}

