/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.refactoring;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.r.core.refactoring.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.core.util.SourceMessageUtil;
import org.eclipse.statet.ltk.model.core.ElementSet;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.refactoring.core.CommonRefactoringDescriptor;
import org.eclipse.statet.ltk.refactoring.core.QuickRefactoring;
import org.eclipse.statet.ltk.refactoring.core.RefactoringChange;
import org.eclipse.statet.ltk.refactoring.core.RefactoringMessages;
import org.eclipse.statet.ltk.refactoring.core.SourceUnitChange;
import org.eclipse.statet.ltk.refactoring.core.TextChangeCompatibility;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.RCoreAccess;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.refactoring.RRefactoringAdapter;
import org.eclipse.statet.r.core.refactoring.RSourceCodeModifyUtil;
import org.eclipse.statet.r.core.source.RSourceConstants;
import org.eclipse.statet.r.core.source.RTerminal;
import org.eclipse.statet.r.core.source.ast.FCall;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.TextEdit;

@NonNullByDefault
public class FCallToPipeForwardRefactoring
extends QuickRefactoring {
    private final RRefactoringAdapter adapter = new RRefactoringAdapter();
    private final ElementSet elementSet;
    private final RSourceUnit sourceUnit;
    private final FCall fCall;
    private final int inputArgIndex;
    private @Nullable Boolean usePlaceholder;

    public FCallToPipeForwardRefactoring(RSourceUnit su, FCall fCall, FCall.Arg arg) {
        this.sourceUnit = su;
        this.elementSet = new ElementSet(new Object[]{su});
        this.fCall = fCall;
        this.inputArgIndex = fCall.getArgsChild().getChildIndex(arg);
        this.usePlaceholder = Boolean.TRUE;
    }

    public FCallToPipeForwardRefactoring(RSourceUnit su, FCall fCall) {
        this.sourceUnit = su;
        this.elementSet = new ElementSet(new Object[]{su});
        this.fCall = fCall;
        this.inputArgIndex = 0;
        this.usePlaceholder = null;
    }

    public String getBundleId() {
        return "org.eclipse.statet.r.core";
    }

    public String getIdentifier() {
        return "org.eclipse.statet.r.refactoring.ConvertFCallToPipeForwardOperation";
    }

    public String getName() {
        return Messages.FCallToPipeForwardMethod_label;
    }

    public RefactoringStatus checkInitialConditions(@Nullable IProgressMonitor monitor) {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            RCoreAccess rCoreAccess = RCore.getContextAccess((IAdaptable)this.sourceUnit);
            FCall fCall = this.fCall;
            FCall.Args args = fCall.getArgsChild();
            if (args.getChildCount() == 0) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)Messages.FCallToPipeForwardMethod_error_MissingArg_message);
                return refactoringStatus;
            }
            FCall.Arg inputArg = args.getChild(this.inputArgIndex);
            if (!inputArg.hasValue()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)Messages.FCallToPipeForwardMethod_error_MissingArgValue_message);
                return refactoringStatus;
            }
            if (this.usePlaceholder == null) {
                this.usePlaceholder = inputArg.hasName() && rCoreAccess.getRSourceConfig().getLangVersion().compareTo(RSourceConstants.LANG_VERSION_4_2) >= 0;
            }
            RefactoringStatus result = new RefactoringStatus();
            this.adapter.checkInitialToModify(result, this.elementSet);
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            m.done();
        }
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringMessages.Common_FinalCheck_label, (int)3);
        try {
            RefactoringStatus status = new RefactoringStatus();
            this.adapter.checkFinalToModify(status, this.elementSet, (IProgressMonitor)m.newChild(2));
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            m.done();
        }
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringMessages.Common_CreateChanges_label, (int)3);
        try {
            SourceUnitChange textFileChange = new SourceUnitChange((SourceUnit)this.sourceUnit);
            if (this.sourceUnit.getWorkingContext() == Ltk.EDITOR_CONTEXT) {
                textFileChange.setSaveMode(4);
            }
            this.createChanges(textFileChange, m.newChild(2));
            textFileChange.setInsertPosition(new Position(this.fCall.getStartOffset(), 0));
            HashMap arguments = new HashMap();
            SourceMessageUtil messageUtil = new SourceMessageUtil(this.sourceUnit.getContent((IProgressMonitor)m));
            String description = NLS.bind((String)Messages.FCallToPipeForwardMethod_Descriptor_description, (Object)messageUtil.getFullQuoteText((AstNode)this.fCall.getRefChild()), (Object)messageUtil.getFullQuoteText((AstNode)this.fCall.getArgsChild().getChild(this.inputArgIndex).getValueChild()));
            IProject resource = this.elementSet.getSingleProject();
            String project = resource != null ? resource.getName() : null;
            String source = project != null ? NLS.bind((String)RefactoringMessages.Common_Source_Project_label, (Object)project) : RefactoringMessages.Common_Source_Workspace_label;
            boolean flags = false;
            String comment = "";
            CommonRefactoringDescriptor descriptor = new CommonRefactoringDescriptor(this.getIdentifier(), project, description, "", arguments, 0);
            RefactoringChange refactoringChange = new RefactoringChange((RefactoringDescriptor)descriptor, this.getName(), new Change[]{textFileChange});
            return refactoringChange;
        }
        catch (BadLocationException e) {
            throw this.handleUnexpectedError(e);
        }
        finally {
            m.done();
        }
    }

    public SourceUnitChange createTextChange(SubMonitor m) throws CoreException {
        m.setWorkRemaining(2);
        try {
            SourceUnitChange textFileChange = new SourceUnitChange((SourceUnit)this.sourceUnit);
            this.createChanges(textFileChange, m.newChild(2));
            return textFileChange;
        }
        catch (BadLocationException e) {
            throw this.handleUnexpectedError(e);
        }
    }

    private void createChanges(SourceUnitChange change, SubMonitor m) throws BadLocationException, CoreException {
        m.setWorkRemaining(11);
        this.sourceUnit.connect((IProgressMonitor)m.newChild(1));
        try {
            RSourceCodeModifyUtil util = new RSourceCodeModifyUtil(this.adapter, this.sourceUnit, m.newChild(1));
            AbstractDocument document = util.getSourceDocument();
            FCall fCall = this.fCall;
            FCall.Args fCallArgs = fCall.getArgsChild();
            FCall.Arg inputArg = fCallArgs.getChild(this.inputArgIndex);
            RAstNode valueNode = (RAstNode)((Object)ObjectUtils.nonNullAssert((Object)((Object)inputArg.getValueChild())));
            int inputStart = valueNode.getStartOffset();
            int inputEnd = valueNode.getEndOffset();
            int delStart = inputArg.getStartOffset();
            int sepStart = Integer.MIN_VALUE;
            int sepEnd = Integer.MIN_VALUE;
            if (this.inputArgIndex < fCallArgs.getSeparatorOffsets().size()) {
                sepStart = fCallArgs.getSeparatorOffsets().getAt(this.inputArgIndex);
                sepEnd = sepStart;
                if (sepEnd != Integer.MIN_VALUE && ++sepEnd < document.getLength() && RTerminal.isHWhitespace(document.getChar(sepEnd)) && (sepEnd + 1 == document.getLength() || document.getChar(sepEnd + 1) != '#')) {
                    ++sepEnd;
                }
            } else {
                sepEnd = sepStart = fCall.getArgsCloseOffset();
            }
            if (sepEnd == Integer.MIN_VALUE) {
                sepEnd = sepStart = inputArg.getEndOffset();
            }
            util.clear();
            util.append(util.getSource(inputStart, inputEnd), valueNode.getNodeType().opPrec > NodeType.PIPE_FORWARD.opPrec);
            util.appendOperator(RTerminal.PIPE_RIGHT);
            TextChangeCompatibility.addTextEdit((TextChange)change, (String)Messages.FCallToPipeForwardMethod_Changes_DeleteOld_name, (TextEdit)util.createInsertEdit(fCall.getStartOffset()));
            m.worked(4);
            util.clear();
            if (((Boolean)ObjectUtils.nonNullAssert((Object)this.usePlaceholder)).booleanValue()) {
                util.append("_");
                TextChangeCompatibility.addTextEdit((TextChange)change, (String)Messages.FCallToPipeForwardMethod_Changes_DeleteOld_name, (TextEdit)util.createReplaceEdit(inputStart, inputEnd));
            } else if (inputEnd < sepStart) {
                TextChangeCompatibility.addTextEdit((TextChange)change, (String)Messages.FCallToPipeForwardMethod_Changes_DeleteOld_name, (TextEdit)util.createDeleteEdit(delStart, inputEnd));
                if (sepStart < sepEnd) {
                    TextChangeCompatibility.addTextEdit((TextChange)change, (String)Messages.FCallToPipeForwardMethod_Changes_DeleteOld_name, (TextEdit)util.createDeleteEdit(sepStart, sepEnd));
                }
            } else {
                TextChangeCompatibility.addTextEdit((TextChange)change, (String)Messages.FCallToPipeForwardMethod_Changes_DeleteOld_name, (TextEdit)util.createDeleteEdit(delStart, sepEnd));
            }
            m.worked(4);
            TextChangeCompatibility.addMarker((TextChange)change, (RangeMarker)new RangeMarker(fCall.getEndOffset(), 0));
        }
        finally {
            this.sourceUnit.disconnect((IProgressMonitor)m.newChild(1));
        }
    }
}

