/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.rtool.setup;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.ui.pager.RPagerEditorInput;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolCommandData;
import org.eclipse.statet.jcommons.util.StringUtils;
import org.eclipse.statet.nico.ui.NicoUI;
import org.eclipse.statet.rj.ts.core.AbstractRToolCommandHandler;
import org.eclipse.statet.rj.ts.core.RToolService;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;

@NonNullByDefault
public class RShowContentsCommandHandler
extends AbstractRToolCommandHandler {
    public static final String SHOW_CONTENTS_COMMAND_ID = "r/showContents";

    public Status execute(String id, RToolService r, ToolCommandData data, ProgressMonitor m) throws StatusException {
        switch (id) {
            case "r/showContents": {
                String[] contents = (String[])data.getRequired("contents", ObjectUtils.NonNull_StringArray_TYPE);
                String title = data.getStringRequired("title");
                String[] headers = (String[])data.getRequired("headers", ObjectUtils.Nullable_StringArray_TYPE);
                title = StringUtils.toSimpleSingleLine((String)title);
                Object[] files = new RPagerEditorInput.TextFile[contents.length];
                int i = 0;
                while (i < files.length) {
                    Object header = headers[i];
                    if (header == null) {
                        header = "#" + (i + 1);
                    }
                    files[i] = new RPagerEditorInput.TextFile((String)header, (String)ObjectUtils.nonNullAssert((Object)contents[i]));
                    ++i;
                }
                RPagerEditorInput editorInput = new RPagerEditorInput(title, r.getTool(), (ImList<RPagerEditorInput.TextFile>)ImCollections.newList((Object[])files));
                try {
                    UIAccess.checkedSyncExec(() -> {
                        IWorkbenchPage workbenchPage = NicoUI.getToolRegistry().findWorkbenchPage((Tool)r.getTool());
                        IDE.openEditor((IWorkbenchPage)workbenchPage, (IEditorInput)editorInput, (String)"org.eclipse.statet.r.editors.RPager", (boolean)true);
                    });
                }
                catch (CoreException e) {
                    throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.ui", 0, "An error occurred when opening the R Pager view.", (Throwable)e));
                }
                return Status.OK_STATUS;
            }
        }
        throw new UnsupportedOperationException();
    }
}

