/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rhelp.core.http.ee10;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.statet.internal.rhelp.core.REnvHelpImpl;
import org.eclipse.statet.internal.rhelp.core.RHelpUIResources;
import org.eclipse.statet.internal.rhelp.core.RHelpWebapp;
import org.eclipse.statet.internal.rhelp.core.index.RHelpHtmlUtils;
import org.eclipse.statet.internal.rhelp.core.server.ServerClientSupport;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.text.core.util.HtmlUtils;
import org.eclipse.statet.rhelp.core.DocResource;
import org.eclipse.statet.rhelp.core.REnvHelp;
import org.eclipse.statet.rhelp.core.REnvHelpConfiguration;
import org.eclipse.statet.rhelp.core.RHelpManager;
import org.eclipse.statet.rhelp.core.RHelpPage;
import org.eclipse.statet.rhelp.core.RHelpTopicEntry;
import org.eclipse.statet.rhelp.core.RPkgHelp;
import org.eclipse.statet.rhelp.core.http.CustomMediaTypeProvider;
import org.eclipse.statet.rhelp.core.http.MediaTypeProvider;
import org.eclipse.statet.rhelp.core.http.RunResult;
import org.eclipse.statet.rhelp.core.http.ee10.HttpForwardHandler;
import org.eclipse.statet.rhelp.core.http.ee10.ResourceHandler;
import org.eclipse.statet.rhelp.core.http.ee10.ServletMediaTypeProvider;
import org.eclipse.statet.rhelp.core.http.ee10.SimpleResourceHandler;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.RLibLocation;
import org.eclipse.statet.rj.renv.core.RPkgDescription;

@NonNullByDefault
public abstract class RHelpHttpServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String PACKAGE_INDEX_PAGE_NAME = "00Index";
    private static final String ATTR_RENV_ID = "rhelp.renv.id";
    private static final String ATTR_RENV_RESOLVED = "rhelp.renv.resolved";
    private static final String ATTR_RENV_HELP = "rhelp.renv.help";
    private static final String ATTR_RENV_CONFIG = "rhelp.renv.config";
    private static final MediaTypeProvider DOC_MEDIA_TYPES;
    private static final String CACHE_CONTROL_DEFAULT = "max-age=30, must-revalidate";
    private static final String CACHE_CONTROL_ACTION = "no-cache, must-revalidate";
    private static final Pattern HTML_PRE_BEGIN_PATTERN;
    private static final Pattern HTML_PRE_END_PATTERN;
    protected static final int PC_OTHER = 0;
    protected static final int PC_ENV_MISSING = 1;
    protected static final int PC_ENV_HELP_MISSING = 2;
    protected static final int PC_ENV_RDOCDIR_MISSING = 3;
    protected static final int PC_PKGHELP_MISSING = 4;
    protected static final int PC_HELPPAGE_MISSING = 5;
    protected static final int PC_FILE_MISSING = 6;
    private RHelpManager rHelpManager;
    private ResourceHandler fileResourceHandler;
    private @Nullable HttpForwardHandler serverForwardHandler;
    private final Map<String, byte[]> images = new HashMap<String, byte[]>();

    static {
        CustomMediaTypeProvider docMediaTypes = new CustomMediaTypeProvider();
        docMediaTypes.addName("README", "text/plain;charset=iso-8859-1");
        docMediaTypes.addName("COPYING", "text/plain;charset=iso-8859-1");
        docMediaTypes.addName("LICENSE", "text/plain;charset=iso-8859-1");
        docMediaTypes.addName("AUTHORS", "text/plain;charset=iso-8859-1");
        docMediaTypes.addName("THANKS", "text/plain;charset=iso-8859-1");
        docMediaTypes.addName("DESCRIPTION", "text/plain");
        docMediaTypes.addExt("Rnw", "text/plain");
        DOC_MEDIA_TYPES = docMediaTypes;
        HTML_PRE_BEGIN_PATTERN = Pattern.compile("\\Q<pre\\E(?: ?[^>]*)\\>\\n*");
        HTML_PRE_END_PATTERN = Pattern.compile("\\Q</pre\\E(?: ?[^>]*)\\>");
    }

    protected static final String getREnvId(HttpServletRequest req) {
        return (String)req.getAttribute(ATTR_RENV_ID);
    }

    private static final REnv getREnv(HttpServletRequest req) {
        return (REnv)req.getAttribute(ATTR_RENV_RESOLVED);
    }

    protected static final @Nullable REnvHelpImpl getREnvHelp(HttpServletRequest req) {
        return (REnvHelpImpl)req.getAttribute(ATTR_RENV_HELP);
    }

    private static final REnvHelpConfiguration getREnvConfig(HttpServletRequest req) {
        return (REnvHelpConfiguration)req.getAttribute(ATTR_RENV_CONFIG);
    }

    private static String getBaseImagesPath(HttpServletRequest req) {
        StringBuilder sb = new StringBuilder();
        String path = req.getPathInfo();
        if (path != null) {
            int idx = 1;
            while (idx < path.length() && (idx = path.indexOf(47, idx)) != -1) {
                sb.append("../");
                ++idx;
            }
        }
        sb.append("images/");
        return sb.toString();
    }

    protected void init(RHelpManager rHelpManager, @Nullable ResourceHandler fileResourceHandler, @Nullable HttpForwardHandler serverForwardHandler) {
        this.rHelpManager = rHelpManager;
        this.fileResourceHandler = fileResourceHandler != null ? fileResourceHandler : new SimpleResourceHandler(new ServletMediaTypeProvider(this.getServletContext()));
        this.fileResourceHandler.setSpecialMediaTypes(DOC_MEDIA_TYPES);
        this.fileResourceHandler.setCacheControl("max-age=600, must-revalidate");
        this.serverForwardHandler = serverForwardHandler;
        this.loadImages();
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void destroy() {
        super.destroy();
    }

    private void loadImages() {
        try {
            RHelpUIResources.loadImagesContent(this.images);
        }
        catch (Exception e) {
            this.log("An error occurred when loading images.", e);
            this.images.clear();
        }
    }

    public RHelpManager getRHelpManager() {
        return this.rHelpManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String path = req.getPathInfo();
            if (path != null) {
                if (path.startsWith("/images/")) {
                    this.processImage(path.substring("images".length() + 2, path.length()), req, resp);
                    return;
                }
                if (path.endsWith("/R.css")) {
                    this.processCss(req, resp);
                    return;
                }
                RHelpWebapp.RequestInfo info = RHelpWebapp.extractRequestInfo(path);
                if (info != null) {
                    if (!this.checkREnv(info.rEnvId, req, resp)) {
                        return;
                    }
                    if (info.cat == null) {
                        this.processEnvIndex(req, resp);
                        return;
                    }
                    if (info.cat == "library") {
                        switch (info.cmd) {
                            case 1: {
                                this.processPkgIndex(info.pkgName, req, resp);
                                return;
                            }
                            case 2: {
                                this.processHelpPage(info.pkgName, info.detail, req, resp);
                                return;
                            }
                            case 3: {
                                this.processPkgRes(info.pkgName, "help", info.detail, req, resp);
                                return;
                            }
                            case 4: {
                                this.processTopic(info.pkgName, info.detail, req, resp);
                                return;
                            }
                            case 5: {
                                this.processPkgRes(info.pkgName, "doc", "index.html", req, resp);
                                return;
                            }
                            case 6: {
                                this.processPkgRes(info.pkgName, "doc", info.detail, req, resp);
                                return;
                            }
                            case 7: {
                                this.processPkgRes(info.pkgName, null, "DESCRIPTION", req, resp);
                                return;
                            }
                        }
                    } else if (info.cat == "doc") {
                        this.processEnvDoc(info.detail, req, resp);
                        return;
                    }
                }
            }
            resp.sendError(400);
            return;
        }
        catch (StatusException e) {
            Status status = e.getStatus();
            int httpStatus = switch (status.getCode()) {
                case 1001, 1002 -> 504;
                default -> 500;
            };
            resp.sendError(httpStatus, status.getMessage());
            return;
        }
        finally {
            REnvHelp help = (REnvHelp)req.getAttribute(ATTR_RENV_HELP);
            if (help != null) {
                help.unlock();
            }
        }
    }

    protected StringBuilder getServletPath(HttpServletRequest req) {
        return new StringBuilder().append(req.getContextPath()).append(req.getServletPath());
    }

    protected void sendPathRedirect(String path, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.resetBuffer();
        resp.setStatus(302);
        resp.setHeader("Location", path);
    }

    private boolean checkREnv(String id, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        REnvHelpConfiguration config;
        req.setAttribute(ATTR_RENV_ID, (Object)id);
        REnv rEnv = this.rHelpManager.getREnv(id);
        if (rEnv != null) {
            rEnv = rEnv.resolve();
        }
        if (rEnv != null && (config = (REnvHelpConfiguration)rEnv.get(REnvHelpConfiguration.class)) != null) {
            req.setAttribute(ATTR_RENV_RESOLVED, (Object)rEnv);
            REnvHelp help = this.rHelpManager.getHelp(rEnv);
            if (help != null) {
                req.setAttribute(ATTR_RENV_HELP, (Object)help);
                req.setAttribute(ATTR_RENV_CONFIG, (Object)config);
            }
            return true;
        }
        this.sendError(this.createEnvNotFound(id, req), req, resp);
        return false;
    }

    private void processHelpPage(String pkgName, String detail, HttpServletRequest req, HttpServletResponse resp) throws IOException, StatusException {
        if (detail != null && detail.equalsIgnoreCase(PACKAGE_INDEX_PAGE_NAME)) {
            this.sendPathRedirect(this.getServletPath(req).append('/').append(RHelpHttpServlet.getREnvId(req)).append("/library/").append(pkgName).append('/').toString(), req, resp);
            return;
        }
        REnvHelpImpl help = RHelpHttpServlet.getREnvHelp(req);
        if (help == null) {
            this.sendError(this.createHelpPageNotFound(2, pkgName, detail, req), req, resp);
            return;
        }
        RPkgHelp pkgHelp = help.getPkgHelp(pkgName);
        if (pkgHelp != null) {
            RHelpPage page = pkgHelp.getPage(detail);
            if (page != null) {
                String action = req.getParameter("action");
                if (action != null) {
                    if (action.equals("runExamples") && this.canRunExamples() && !page.getTopics().isEmpty()) {
                        this.doRunExamples(page, req, resp);
                        return;
                    }
                    resp.setStatus(400);
                    return;
                }
                String qs = req.getParameter("qs");
                String html = help.getHtmlPage(pkgHelp, detail, qs);
                if (html != null) {
                    if (qs != null) {
                        html = RHelpHtmlUtils.formatHtmlMatches(html);
                    }
                    this.serveHtmlPage(page, html, req, resp);
                    return;
                }
            } else {
                page = pkgHelp.getPageForTopic(detail);
                if (page != null) {
                    this.redirect(page, req, resp);
                    return;
                }
            }
        }
        this.sendError(this.createHelpPageNotFound(5, pkgName, detail, req), req, resp);
    }

    private void processPkgRes(String pkgName, @Nullable String resSub, String path, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        Path file;
        Path libDirectory;
        block17: {
            REnvHelpConfiguration rEnvConfig;
            block16: {
                REnvHelpImpl help = RHelpHttpServlet.getREnvHelp(req);
                if (help == null) {
                    this.sendError(this.createPkgResNotFound(2, path, req), req, resp);
                    return;
                }
                rEnvConfig = RHelpHttpServlet.getREnvConfig(req);
                libDirectory = null;
                if (!rEnvConfig.isLocal()) break block16;
                RPkgHelp pkgHelp = help.getPkgHelp(pkgName);
                if (pkgHelp != null) {
                    RPkgDescription pkgDescription = pkgHelp.getPkgDescription();
                    RLibLocation libLocation = pkgDescription.getLibLocation();
                    libDirectory = libLocation.getDirectoryPath();
                }
                break block17;
            }
            switch (rEnvConfig.getStateSharedType()) {
                case "server": {
                    this.forwardToServer(rEnvConfig, req, resp);
                    return;
                }
                default: {
                    resp.sendError(500);
                    return;
                }
                case "directory": 
            }
        }
        if (libDirectory == null) {
            resp.sendError(404);
            return;
        }
        Path directory = libDirectory.resolve(pkgName);
        if (resSub != null) {
            directory = directory.resolve(resSub);
        }
        if ((file = this.checkPath(directory, path)) == null) {
            resp.sendError(400);
            return;
        }
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            this.sendError(this.createPkgResNotFound(6, path, req), req, resp);
            return;
        }
        this.serveFileResource(file, null, req, resp);
    }

    private void processPkgIndex(String pkgName, HttpServletRequest req, HttpServletResponse resp) throws IOException, StatusException {
        ImList<RHelpTopicEntry> topics;
        REnvHelpImpl help = RHelpHttpServlet.getREnvHelp(req);
        if (help == null) {
            this.sendError(this.createPkgIndexNotFound(2, pkgName, req), req, resp);
            return;
        }
        RPkgHelp pkgHelp = help.getPkgHelp(pkgName);
        if (pkgHelp != null && (topics = pkgHelp.getTopics()) != null) {
            this.servePkgIndex(pkgHelp, (List<RHelpTopicEntry>)topics, req, resp);
            return;
        }
        this.sendError(this.createPkgIndexNotFound(4, pkgName, req), req, resp);
    }

    private void processTopic(String pkgName, String detail, HttpServletRequest req, HttpServletResponse resp) throws IOException, StatusException {
        RHelpPage page;
        REnvHelpImpl help = RHelpHttpServlet.getREnvHelp(req);
        if (help == null) {
            this.sendError(this.createTopicListNotFound(2, detail, req), req, resp);
            return;
        }
        RPkgHelp pkgHelp = help.getPkgHelp(pkgName);
        if (pkgHelp != null && (page = pkgHelp.getPageForTopic(detail)) != null) {
            this.redirect(page, req, resp);
            return;
        }
        List<RHelpPage> pages = help.getPagesForTopic(detail, null);
        if (pages.size() == 1) {
            this.redirect(pages.get(0), req, resp);
            return;
        }
        this.serveTopicList(detail, pages, req, resp);
    }

    private void processCss(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        PrintWriter writer = this.createCssDoc(req, resp);
        writer.println("span.acronym { font-size: small }\nspan.env { font-family: monospace; }\nspan.file { font-family: monospace; }\nspan.option { font-family: monospace; }\nspan.pkg { font-weight: bold; }\nspan.samp { font-family: monospace; }\nbody { line-height: 125%; margin: 1em; padding: 0; color: black; }\ntable { margin: 0.4em 0 0.4em 0; border-collapse:collapse; border:0px; font-size: 100%; }\ntd { padding: 0.2em 0.8em 0.2em 0; border:0px; }\nh2 { font-size: 120%; font-weight: bold; margin: 0 0 0.6em 0; }\nh3 {font-size: 110%; font-weight: bold; letter-spacing: 0.05em; margin: 1.0em 0 0.6em 0; }.h3-inline {display: inline-block; font-size: 90.91%; font-weight: normal; letter-spacing: normal; }p, pre, ol { margin: 0.6em 0 0.6em 0; }\ntd p, td code {margin: 0.3em 0 0.3em 0; }\n.c2 li { margin: 0.2em 0 0.2em 0; }\n.c2 li:first-child { margin-top: 0; }\n.c2 li:last-child { margin-bottom: 0; }\ntd { vertical-align: top; }\nhr { margin-top: 0.8em; clear: both; }\ndiv.toc { display: none; font-size: 80%; line-height: 125%; padding: 0.2em 0.8em 0.4em; }\ndiv.toc ul { list-style: none; padding: 0; margin: 0 }\ndiv.toc pre { margin: 0 0 0.4em; }\ndiv.toc a { text-decoration: none; color: black; }\ndiv.toc a:visited { text-decoration: none; color: black; }\na.action { font-size: 90%; text-decoration: none; padding-left: 1px; padding-right: 1px; }\na.action:hover { background-color: lightgrey; color: black; }\nimg.icon { vertical-align: text-top; padding-top: 1px; }\n.li img.icon { padding-right: 2px; margin-right: 2px; }\n");
        this.customizeCss(writer);
    }

    private void processImage(String imgName, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        byte[] content = this.images.get(imgName);
        if (content != null) {
            resp.setContentType("image/png");
            resp.setHeader("Cache-Control", "max-age=600, public");
            ServletOutputStream out = resp.getOutputStream();
            out.write(content);
            return;
        }
        resp.sendError(404);
    }

    private void processEnvIndex(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        REnvHelpImpl help = RHelpHttpServlet.getREnvHelp(req);
        if (help == null) {
            REnv rEnv = RHelpHttpServlet.getREnv(req);
            this.sendError(this.createEnvIndexNotFound(2, rEnv, req), req, resp);
            return;
        }
        this.serveEnvIndex(help, req, resp);
    }

    private void processEnvDoc(String path, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Path directory;
        REnvHelpImpl help;
        block16: {
            REnvHelpConfiguration rEnvConfig;
            block15: {
                help = RHelpHttpServlet.getREnvHelp(req);
                if (help == null) {
                    this.sendError(this.createEnvDocNotFound(2, help, path, req), req, resp);
                    return;
                }
                directory = null;
                rEnvConfig = RHelpHttpServlet.getREnvConfig(req);
                if (!rEnvConfig.isLocal()) break block15;
                String docDir = help.getDocDir();
                if (docDir != null) {
                    directory = Path.of(docDir, new String[0]);
                }
                break block16;
            }
            switch (rEnvConfig.getStateSharedType()) {
                case "server": {
                    this.forwardToServer(rEnvConfig, req, resp);
                    return;
                }
                default: {
                    resp.sendError(500);
                    return;
                }
                case "directory": 
            }
        }
        if (directory == null) {
            this.sendError(this.createEnvDocNotFound(3, help, path, req), req, resp);
            return;
        }
        Path file = this.checkPath(directory, path);
        if (file == null) {
            resp.sendError(400);
            return;
        }
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            this.sendError(this.createEnvDocNotFound(6, help, path, req), req, resp);
            return;
        }
        this.serveFileResource(file, req.getParameter("action"), req, resp);
    }

    private ErrorData createEnvNotFound(String rEnvId, HttpServletRequest req) throws IOException {
        ErrorData errorData = new ErrorData(1, 404, "R Environment");
        errorData.getMessageBuilder().append(rEnvId.startsWith("default-") ? "The default R environment could not be found." : "The requested R environment could not be found.");
        return errorData;
    }

    private void serveEnvIndex(REnvHelpImpl help, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        REnvHelpConfiguration rEnvConfig = RHelpHttpServlet.getREnvConfig(req);
        REnv rEnv = help.getREnv();
        ImList<RPkgHelp> packages = help.getPkgs();
        PrintWriter writer = this.createHtmlDoc("R Environment '" + rEnv.getName() + "'", req, resp);
        String basePath = this.getServletPath(req).append('/').append(rEnv.getId()).toString();
        String baseLibraryPath = basePath + "/library/";
        String baseDocPath = basePath + "/doc/";
        String baseImagesPath = basePath + "/../images/";
        this.customizeIndexHtmlHeader(req, writer);
        writer.println("</head><body>");
        writer.println("<div class=\"toc\"><ul>");
        writer.write("<li><a href=\"#manuals\">Manuals</a></li>");
        writer.write("<li><a href=\"#packages\">Packages</a><pre>");
        char i = 'A';
        int j = 0;
        while (i <= 'Z') {
            block11: {
                String name;
                if ((i - 65) % 7 == 0) {
                    writer.println();
                }
                writer.print(' ');
                while (j < packages.size() && (name = ((RPkgHelp)packages.get(j)).getName()) != null && name.length() > 0) {
                    char c = Character.toUpperCase(name.charAt(0));
                    if (c >= 'A' && c <= 'Z') {
                        if (c > i) break;
                        if (c == i) {
                            writer.write("<a href=\"#idx");
                            writer.print((char)(32 + c));
                            writer.write("\" class=\"mnemonic\">");
                            writer.print(c);
                            writer.write("</a>");
                            break block11;
                        }
                    }
                    ++j;
                }
                writer.print(i);
            }
            ++i;
        }
        writer.println("</pre></li>");
        if (!help.getMiscResources().isEmpty()) {
            writer.write("<li><a href=\"#misc\">Misc. Material</a></li>");
        }
        writer.println("</ul></div>");
        writer.write("<h2>");
        writer.write(rEnv.getName());
        writer.write("</h2>");
        writer.write("<h3 id=\"manuals\">Manuals</h3>");
        if (!help.getManuals().isEmpty()) {
            this.printDocTable(writer, (List<DocResource>)help.getManuals(), baseDocPath, rEnvConfig.isLocal());
        } else {
            writer.write("<p>No manuals available for this R installation.</p>");
        }
        writer.write("<h3 id=\"packages\">Packages</h3>");
        writer.write("<table>");
        char lastChar = '\u0000';
        for (RPkgHelp pkgHelp : packages) {
            char c;
            String name = pkgHelp.getName();
            writer.write("<tr><td class=\"li\" style=\"white-space: nowrap;\">");
            writer.write("<a href=\"");
            writer.write(baseLibraryPath);
            writer.write(name);
            writer.write("/\" title=\"");
            writer.write(name);
            writer.write(" [");
            HtmlUtils.writeContent((PrintWriter)writer, (String)pkgHelp.getVersion().toString());
            writer.print(']');
            writer.print('\"');
            if (name.length() > 0 && (c = Character.toUpperCase(name.charAt(0))) >= 'A' && c <= 'Z' && c > lastChar) {
                lastChar = c;
                writer.write(" id=\"idx");
                writer.print((char)(32 + c));
                writer.print('\"');
            }
            writer.write(">");
            this.printIcon(writer, baseImagesPath, RHelpUIResources.R_PACKAGE_ICON);
            writer.write("<code>");
            writer.write(pkgHelp.getName());
            writer.write("</code></a>");
            writer.write("</td><td>");
            HtmlUtils.writeContent((PrintWriter)writer, (String)pkgHelp.getTitle());
            writer.write("</td></tr>");
        }
        writer.write("</table>");
        if (!help.getMiscResources().isEmpty()) {
            writer.write("<h3 id=\"misc\">Miscellaneous Material</h3>");
            this.printDocTable(writer, (List<DocResource>)help.getMiscResources(), baseDocPath, rEnvConfig.isLocal());
        }
        writer.write("<hr/>");
        writer.println("</body></html>");
    }

    private ErrorData createEnvIndexNotFound(int problemCode, REnv rEnv, HttpServletRequest req) throws IOException {
        ErrorData errorData = new ErrorData(problemCode, 404, "R Environment '" + rEnv.getName() + "'");
        errorData.getMessageBuilder().append("The help for the R environment '").append(rEnv.getName()).append("' is not available.");
        return errorData;
    }

    private ErrorData createEnvDocNotFound(int problemCode, @Nullable REnvHelp help, String path, HttpServletRequest req) throws IOException {
        String resourceName = this.getDocResourceName(help, path);
        ErrorData errorData = new ErrorData(problemCode, 404, resourceName);
        errorData.getMessageBuilder().append("The requested documentation resource (").appendContent(resourceName).append(") could not be found.");
        return errorData;
    }

    private PrintWriter createHtmlDoc(String title, String cacheControl, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/html;charset=UTF-8");
        resp.setHeader("Cache-Control", cacheControl);
        PrintWriter writer = resp.getWriter();
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        writer.println("<html><head>");
        writer.write("<title>");
        HtmlUtils.writeContent((PrintWriter)writer, (String)title);
        writer.write("</title>");
        writer.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
        writer.write(this.getServletPath(req).append("/R.css").toString());
        writer.println("\"/>");
        return writer;
    }

    private PrintWriter createHtmlDoc(String title, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        return this.createHtmlDoc(title, CACHE_CONTROL_DEFAULT, req, resp);
    }

    private void redirect(RHelpPage page, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.sendPathRedirect(this.getServletPath(req).append('/').append(RHelpHttpServlet.getREnvId(req)).append("/library/").append(page.getPackage().getName()).append("/html/").append(page.getName()).append(".html").toString(), req, resp);
    }

    private PrintWriter createCssDoc(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/css;charset=UTF-8");
        PrintWriter writer = resp.getWriter();
        writer.println("@charset \"UTF-8\";");
        return writer;
    }

    private void serveHtmlPage(RHelpPage page, String html, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/html;charset=UTF-8");
        resp.setHeader("Cache-Control", CACHE_CONTROL_DEFAULT);
        PrintWriter writer = resp.getWriter();
        int idxDone = 0;
        int idxEnd = html.indexOf("</head>");
        if (idxEnd > 0) {
            writer.write(html, idxDone, idxEnd - idxDone);
            this.customizePageHtmlHeader(req, writer);
            writer.write("</head>");
            idxDone = idxEnd + 7;
            int idx = html.indexOf("<!-- EXAMPLES-ADD -->", idxDone);
            if (idx >= 0) {
                writer.write(html, idxDone, idx - idxDone);
                idx += "<!-- EXAMPLES-ADD -->".length();
                if (this.canRunExamples() && !page.getTopics().isEmpty()) {
                    writer.write("&emsp;<div class=\"h3-inline\">[&#8239;<a class=\"action\" href=\"?action=runExamples\">(Run in Console)</a>&#8239;]</div>");
                }
                idxDone = idx;
            }
            if ((idx = html.indexOf("<!-- BEGIN-EXAMPLES -->", idxDone)) >= 0) {
                writer.write(html, idxDone, idx - idxDone);
                idxEnd = html.indexOf("<!-- END-EXAMPLES -->", idx += "<!-- BEGIN-EXAMPLES -->".length());
                if (idxEnd > 0) {
                    if (idxEnd > idx) {
                        this.customizeExamples(writer, html.substring(idx, idxEnd));
                    }
                    idx = idxEnd + "<!-- END-EXAMPLES -->".length();
                }
                idxDone = idx;
            }
        }
        if (idxDone < html.length()) {
            writer.write(html, idxDone, html.length() - idxDone);
        }
    }

    private ErrorData createHelpPageNotFound(int problemCode, String pkgName, String detail, HttpServletRequest req) throws IOException {
        ErrorData errorData = new ErrorData(problemCode, 404, detail);
        errorData.getMessageBuilder().append("The help page <code>").appendContent(detail).append("</code> of the package <code>").appendContent(pkgName).append("</code> could not be found.");
        return errorData;
    }

    private void serveTopicList(String topic, List<RHelpPage> pages, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        PrintWriter writer = this.createHtmlDoc("Help on topic '" + topic + "'", req, resp);
        String codeTopic = "<code>" + topic + "</code>";
        this.customizeIndexHtmlHeader(req, writer);
        writer.println("</head><body>");
        writer.write("<h2>");
        writer.write(String.format("Help on topic %1$s", codeTopic));
        writer.write("</h2>");
        String baseLibraryPath = "../../";
        String baseImagesPath = "../../../../images/";
        if (pages != null && !pages.isEmpty()) {
            writer.write("<p>");
            writer.write(String.format("Help on topic %1$s was found in the following pages:", codeTopic));
            writer.println("</p>");
            Collections.sort(pages);
            writer.write("<table>");
            for (RHelpPage page : pages) {
                writer.write("<tr><td class=\"li\" style=\"white-space: nowrap;\">");
                this.printIcon(writer, "../../../../images/", page.isInternal() ? RHelpUIResources.RHELP_TOPIC_INTERNAL_ICON : RHelpUIResources.RHELP_TOPIC_ICON);
                writer.write("<a href=\"");
                writer.write("../../");
                writer.write(page.getPackage().getName());
                writer.write("/html/");
                writer.write(page.getName());
                writer.write(".html\"><code>");
                writer.write(page.getName());
                writer.write("</code></a> {");
                writer.write("<a href=\"");
                writer.write("../../");
                writer.write(page.getPackage().getName());
                writer.write("/\" title=\"");
                writer.write(page.getPackage().getName());
                writer.write(" [");
                writer.write(page.getPackage().getVersion().toString());
                writer.write("]\n");
                HtmlUtils.writeContent((PrintWriter)writer, (String)page.getPackage().getTitle());
                writer.write("\"><code>");
                writer.write(page.getPackage().getName());
                writer.write("</code></a>}</td>");
                writer.write("<td>");
                HtmlUtils.writeContent((PrintWriter)writer, (String)page.getTitle());
                writer.write("</td></tr>");
            }
            writer.write("</table>");
        } else {
            writer.write(String.format("No help found on topic %1$s in any package in the R library.", codeTopic));
        }
        writer.println("</body></html>");
    }

    private ErrorData createTopicListNotFound(int problemCode, String topic, HttpServletRequest req) throws IOException {
        ErrorData errorData = new ErrorData(problemCode, 404, "Help on topic '" + topic + "'");
        errorData.getMessageBuilder().append("The help on topic <code>").appendContent(topic).append("</code> could not be found.");
        return errorData;
    }

    private void servePkgIndex(RPkgHelp pkgHelp, List<RHelpTopicEntry> packageTopics, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String description;
        RPkgDescription pkgDescription = pkgHelp.getPkgDescription();
        ImList vignettes = ImCollections.emptyList();
        boolean showInternal = this.getShowInternal();
        PrintWriter writer = this.createHtmlDoc(String.format("Package '%1$s' - %2$s", pkgHelp.getName(), pkgHelp.getTitle()), req, resp);
        this.customizeIndexHtmlHeader(req, writer);
        writer.println("</head><body>");
        writer.write("<table class=\"header\"><tr><td>");
        writer.write(pkgHelp.getName());
        writer.write(" [");
        writer.write(pkgHelp.getVersion().toString());
        writer.write("]");
        writer.println("</td></tr></table>");
        writer.println("<div class=\"toc\"><ul>");
        writer.write("<li><a href=\"#topics\">Help Topics</a><pre>");
        char i = 'A';
        int j = 0;
        while (i <= 'Z') {
            block16: {
                if ((i - 65) % 7 == 0) {
                    writer.println();
                }
                writer.print(' ');
                while (j < packageTopics.size()) {
                    char c;
                    RHelpTopicEntry topic = packageTopics.get(j);
                    if (topic.getTopic().length() > 0 && (c = Character.toUpperCase(topic.getTopic().charAt(0))) >= 'A' && c <= 'Z') {
                        if (c > i) break;
                        if (c == i && (showInternal || !topic.getPage().isInternal())) {
                            writer.write("<a href=\"#idx");
                            writer.print((char)(32 + c));
                            writer.write("\" class=\"mnemonic\">");
                            writer.print(c);
                            writer.write("</a>");
                            break block16;
                        }
                    }
                    ++j;
                }
                writer.print(i);
            }
            ++i;
        }
        writer.println("</pre></li>");
        if (!vignettes.isEmpty()) {
            writer.println("<li><a href=\"#vignettes\">Other Documentation</a></li>");
        }
        writer.println("<li><a href=\"#about\">About</a></li>");
        writer.println("</ul></div>");
        writer.write("<h2>");
        HtmlUtils.writeContent((PrintWriter)writer, (String)pkgHelp.getTitle());
        writer.write("</h2>");
        if (pkgDescription != null && (description = pkgDescription.getDescription()).length() > 0) {
            writer.write("<h3 id=\"description\">Description</h3>");
            writer.write("<p>");
            HtmlUtils.writeContent((PrintWriter)writer, (String)description);
            if (description.charAt(description.length() - 1) != '.') {
                writer.print('.');
            }
            writer.write("</p>");
        }
        writer.write("<h3 id=\"topics\">Help Topics</h3>");
        writer.write("<table>");
        String baseTopicsPath = "html/";
        String baseImagesPath = "../../../images/";
        char lastChar = '\u0000';
        for (RHelpTopicEntry topic : packageTopics) {
            char c;
            RHelpPage page = topic.getPage();
            if (!showInternal && page.isInternal()) continue;
            String alias = topic.getTopic();
            writer.write("<tr><td class=\"li\" style=\"white-space: nowrap;\">");
            writer.write("<a href=\"");
            writer.write("html/");
            writer.write(page.getName());
            writer.write(".html");
            writer.write(34);
            if (alias.length() > 0 && (c = Character.toUpperCase(alias.charAt(0))) >= 'A' && c <= 'Z' && c > lastChar) {
                lastChar = c;
                writer.write(" id=\"idx");
                writer.print((char)(32 + c));
                writer.print('\"');
            }
            writer.write(" title=\"");
            writer.write(page.getName());
            writer.write(" {");
            writer.write(pkgHelp.getName());
            writer.write("}\n");
            HtmlUtils.writeContent((PrintWriter)writer, (String)page.getTitle());
            writer.write("\">");
            this.printIcon(writer, "../../../images/", page.isInternal() ? RHelpUIResources.RHELP_TOPIC_INTERNAL_ICON : RHelpUIResources.RHELP_TOPIC_ICON);
            writer.write("<code>");
            writer.write(alias);
            writer.write("</code></a>");
            writer.write("</td><td>");
            HtmlUtils.writeContent((PrintWriter)writer, (String)page.getTitle());
            writer.write("</td></tr>");
        }
        writer.write("</table>");
        if (!vignettes.isEmpty()) {
            writer.write("<h3 id=\"vignettes\">Vignettes and Other Documentation</h3>");
        }
        writer.write("<h3 id=\"about\">About</h3>");
        if (pkgDescription != null) {
            ImList urls;
            writer.write("<table>");
            if (pkgDescription.getAuthor() != null && pkgDescription.getAuthor().length() > 0) {
                writer.write("<tr><td>Author(s):</td>");
                writer.write("<td>");
                HtmlUtils.writeContent((PrintWriter)writer, (String)pkgDescription.getAuthor());
                writer.write("</td>");
            }
            if (pkgDescription.getMaintainer() != null && pkgDescription.getMaintainer().length() > 0) {
                writer.write("<tr><td>Maintainer:</td>");
                writer.write("<td>");
                HtmlUtils.writeContent((PrintWriter)writer, (String)pkgDescription.getMaintainer());
                writer.write("</td>");
            }
            if (!(urls = pkgDescription.getUrls()).isEmpty()) {
                writer.write("<tr><td>URL:</td>");
                writer.write("<td>");
                Iterator iter = urls.iterator();
                while (true) {
                    String url = (String)iter.next();
                    writer.write("<a href=\"");
                    HtmlUtils.writeContent((PrintWriter)writer, (String)url);
                    writer.write("\"><code>");
                    HtmlUtils.writeContent((PrintWriter)writer, (String)url);
                    writer.write("</code></a>");
                    if (!iter.hasNext()) break;
                    writer.write(", ");
                }
                writer.write("</td>");
            }
            writer.write("</table>");
        }
        writer.write("<p><a href=\"description\">DESCRIPTION file</a></p>");
        writer.println("</body></html>");
    }

    private ErrorData createPkgIndexNotFound(int problemCode, String pkgName, HttpServletRequest req) throws IOException {
        ErrorData errorData = new ErrorData(problemCode, 404, "Package '" + pkgName + "'");
        errorData.getMessageBuilder().append("The help for the package <code>").appendContent(pkgName).append("</code> could not be found.");
        return errorData;
    }

    private ErrorData createPkgResNotFound(int problemCode, String resourceName, HttpServletRequest req) throws IOException {
        ErrorData errorData = new ErrorData(problemCode, 404, resourceName);
        errorData.getMessageBuilder().append("The requested package resource (").appendContent(resourceName).append(") could not be found.");
        return errorData;
    }

    protected void servePageExamples(RHelpPage page, RunResult result, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String html = result.getHtml();
        if (result.getStatus().getSeverity() == 8 || html == null) {
            resp.setStatus(204);
            resp.setHeader("Cache-Control", CACHE_CONTROL_ACTION);
            return;
        }
        PrintWriter writer = this.createHtmlDoc(String.format("Examples of '%1$s'", page), req, resp);
        writer.println("</head><body>");
        writer.println(html);
        writer.println("</body>");
    }

    protected void sendError(ErrorData errorData, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.enrichErrorData(errorData, req);
        this.serveError(errorData.statusCode, (String)(switch (errorData.statusCode) {
            case 404 -> "[Not Found] ";
            default -> "[Error " + errorData.statusCode + "]";
        }) + errorData.title, errorData, req, resp);
    }

    protected void serveError(int statusCode, String title, ErrorData errorData, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setStatus(statusCode);
        PrintWriter writer = this.createHtmlDoc(title, req, resp);
        writer.write("<!-- HTTP Error");
        writer.write("\n    ");
        writer.write("Status: ");
        writer.write(statusCode);
        writer.write(" - ");
        HtmlUtils.writeContent((PrintWriter)writer, (String)title);
        writer.write("\n    ");
        writer.write("Request: ");
        writer.write(req.getPathInfo());
        writer.write("\n-->\n");
        writer.println("</head><body class=\"error\">");
        String baseImagesPath = RHelpHttpServlet.getBaseImagesPath(req);
        writer.write("<table>\n");
        writer.write("<tr><td>");
        this.printIcon(writer, baseImagesPath, RHelpUIResources.ERROR_ICON);
        writer.write("</td><td>");
        writer.write(errorData.message.toString());
        writer.write("</td></tr>\n");
        if (errorData.fixInfos != null) {
            writer.write("<tr><td><p>");
            this.printIcon(writer, baseImagesPath, RHelpUIResources.FIX_INFO_ICON);
            writer.write("</p></td><td>");
            writer.write(errorData.fixInfos);
            writer.write("</td></tr>\n");
        }
        writer.write("</table>\n");
        writer.write("</body></html>\n");
    }

    protected void enrichErrorData(ErrorData errorData, HttpServletRequest req) throws IOException {
        switch (errorData.getProblemCode()) {
            case 1: {
                return;
            }
            case 2: {
                errorData.getMessageBuilder().append("<p>Caused by: The R library of the R environment '").appendContent(RHelpHttpServlet.getREnv(req).getName()).append("' is not yet indexed.</p>");
                return;
            }
            case 3: {
                errorData.getMessageBuilder().append("<p>Caused by: R doc directory of the R environment could not be not found.</p>");
                return;
            }
        }
    }

    private void printDocTable(PrintWriter writer, List<DocResource> docs, String baseUrl, boolean local) {
        writer.write("<table>");
        for (DocResource doc : docs) {
            writer.write("<tr><td>");
            writer.write("<a href=\"");
            writer.write(baseUrl);
            writer.write(doc.getPath());
            writer.write("\">");
            HtmlUtils.writeContent((PrintWriter)writer, (String)doc.getTitle());
            writer.write("</a>");
            if (doc.getPdfPath() != null) {
                writer.write("&emsp;[&#8239;<a");
                writer.write(" href=\"");
                writer.write(baseUrl);
                writer.write(doc.getPdfPath());
                writer.write("\">PDF</a>");
                if (local && this.canOpenFile("pdf")) {
                    writer.write("&nbsp;<a class=\"action\"");
                    writer.write(" href=\"");
                    writer.write(baseUrl);
                    writer.write(doc.getPdfPath());
                    writer.write("?action=open");
                    writer.write("\" title=\"Open PDF with Eclipse\">(Open)</a>");
                }
                writer.write("&#8239;]");
            }
            writer.write("</td></tr>");
        }
        writer.write("</table>");
    }

    private String getDocResourceName(@Nullable REnvHelp help, String path) {
        if (help != null) {
            for (ImList<DocResource> list : List.of(help.getManuals(), help.getMiscResources())) {
                for (DocResource docResource : list) {
                    if (!path.equals(docResource.getPath()) && !path.equals(docResource.getPdfPath())) continue;
                    return docResource.getTitle();
                }
            }
        }
        return path;
    }

    private void printIcon(PrintWriter writer, String imageBasePath, RHelpUIResources.Image image) {
        if (this.images.isEmpty()) {
            return;
        }
        ImList<RHelpUIResources.PngFile> candidates = image.getPngFiles();
        writer.write("<img class=\"icon\" src=\"");
        writer.write(imageBasePath);
        writer.write(((RHelpUIResources.PngFile)candidates.getFirst()).getName());
        if (candidates.size() > 1) {
            writer.write("\" srcset=\"");
            int i = 1;
            while (true) {
                RHelpUIResources.PngFile file = (RHelpUIResources.PngFile)candidates.get(i);
                writer.write(imageBasePath);
                writer.write(file.getName());
                writer.write(file.getHtmlDescriptor());
                if (++i >= candidates.size()) break;
                writer.write(", ");
            }
        }
        writer.write("\"/>");
    }

    private void customizeExamples(PrintWriter writer, String html) {
        Matcher beginMatcher = HTML_PRE_BEGIN_PATTERN.matcher(html);
        Matcher endMatcher = HTML_PRE_END_PATTERN.matcher(html);
        int idxDone = 0;
        while (idxDone < html.length()) {
            int idx;
            if (!beginMatcher.find(idxDone) || !endMatcher.find(idx = beginMatcher.end())) break;
            writer.write(html, idxDone, idx - idxDone);
            idxDone = idx;
            idx = endMatcher.start();
            this.printRCode(writer, html.substring(idxDone, idx));
            idxDone = idx;
            idx = endMatcher.end();
            writer.write(html, idxDone, idx - idxDone);
            idxDone = idx;
        }
        writer.write(html, idxDone, html.length() - idxDone);
    }

    protected boolean getShowInternal() {
        return true;
    }

    protected void customizeCss(PrintWriter writer) {
    }

    protected void customizePageHtmlHeader(HttpServletRequest req, PrintWriter writer) {
    }

    protected void customizeIndexHtmlHeader(HttpServletRequest req, PrintWriter writer) {
    }

    protected void printRCode(PrintWriter writer, String html) {
        writer.write(html);
    }

    private @Nullable Path checkPath(Path directory, String path) {
        try {
            Path file = directory.resolve(path).toRealPath(LinkOption.NOFOLLOW_LINKS);
            if (file.getNameCount() >= directory.getNameCount() && file.startsWith(directory)) {
                return file;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void serveFileResource(Path file, @Nullable String action, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (action != null && action.equals("open")) {
            this.doOpenFile(file);
            resp.setStatus(204);
            resp.setHeader("Cache-Control", CACHE_CONTROL_ACTION);
            return;
        }
        this.fileResourceHandler.doGet(file, req, resp);
    }

    private void forwardToServer(REnvHelpConfiguration rEnvConfig, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpForwardHandler serverForwardHandler = this.serverForwardHandler;
        if (serverForwardHandler == null) {
            resp.sendError(503);
            return;
        }
        try {
            ServerClientSupport serverSupport = ServerClientSupport.getInstance();
            String localId = RHelpHttpServlet.getREnvId(req);
            URI serverUrl = serverSupport.toServerBrowseUrl(rEnvConfig, req.getPathInfo().substring(localId.length() + 1));
            serverForwardHandler.forward(serverUrl, req, resp);
        }
        catch (URISyntaxException | StatusException e) {
            throw new ServletException(e);
        }
    }

    protected boolean canOpenFile(String ext) {
        return false;
    }

    protected void doOpenFile(Path file) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected boolean canRunExamples() {
        return false;
    }

    protected void doRunExamples(RHelpPage helpPage, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected static final class ErrorData {
        private final int problemCode;
        private final int statusCode;
        private final String title;
        private final HtmlUtils.HtmlStringBuilder message = new HtmlUtils.HtmlStringBuilder(128);
        private @Nullable String fixInfos;

        public ErrorData(int problemCode, int statusCode, String title) {
            this.problemCode = problemCode;
            this.statusCode = statusCode;
            this.title = title;
        }

        public int getProblemCode() {
            return this.problemCode;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public HtmlUtils.HtmlStringBuilder getMessageBuilder() {
            return this.message;
        }

        public void setFixInfos(String info) {
            this.fixInfos = info;
        }
    }
}

