/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import org.eclipse.cdt.debug.core.model.IChangeReverseMethodHandler;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConsoleStreamOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIStreamRecord;

public class CLIInfoRecordInfo
extends MIInfo {
    private IChangeReverseMethodHandler.ReverseDebugMethod fReverseMethod;

    public CLIInfoRecordInfo(MIOutput record) {
        super(record);
        this.parse();
    }

    protected void parse() {
        if (this.isDone()) {
            MIOutput out = this.getMIOutput();
            MIOOBRecord[] records = out.getMIOOBRecords();
            StringBuilder builder = new StringBuilder();
            MIOOBRecord[] mIOOBRecordArray = records;
            int n = records.length;
            int n2 = 0;
            while (n2 < n) {
                MIOOBRecord rec = mIOOBRecordArray[n2];
                if (rec instanceof MIConsoleStreamOutput) {
                    MIStreamRecord o = (MIStreamRecord)rec;
                    builder.append(o.getString());
                }
                ++n2;
            }
            this.parseReverseMethod(builder.toString());
        }
    }

    protected void parseReverseMethod(String output) {
        this.fReverseMethod = output.contains("Processor") ? IChangeReverseMethodHandler.ReverseDebugMethod.PROCESSOR_TRACE : (output.contains("Branch") ? IChangeReverseMethodHandler.ReverseDebugMethod.BRANCH_TRACE : (output.contains("full") ? IChangeReverseMethodHandler.ReverseDebugMethod.SOFTWARE : IChangeReverseMethodHandler.ReverseDebugMethod.OFF));
    }

    public IChangeReverseMethodHandler.ReverseDebugMethod getReverseMethod() {
        return this.fReverseMethod;
    }
}

