/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2Core;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.JdtASTMatcher;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.helper.LambdaQueries;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.QuickAssistProcessorUtil;

public class ConvertLambdaToMethodReferenceFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public ConvertLambdaToMethodReferenceFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation operation) {
        super(name, compilationUnit, operation);
    }

    public static ConvertLambdaToMethodReferenceFixCore createConvertLambdaToMethodReferenceFix(CompilationUnit compilationUnit, ASTNode node) {
        LambdaExpression lambda;
        if (node instanceof LambdaExpression) {
            lambda = (LambdaExpression)node;
        } else if (node.getLocationInParent() == LambdaExpression.BODY_PROPERTY) {
            lambda = (LambdaExpression)node.getParent();
        } else {
            lambda = ASTResolving.findEnclosingLambdaExpression(node);
            if (lambda == null) {
                return null;
            }
        }
        ASTNode lambdaBody = lambda.getBody();
        Expression exprBody = lambdaBody instanceof Block ? LambdaQueries.getSingleExpressionFromLambdaBody((Block)lambdaBody) : (Expression)lambdaBody;
        exprBody = ASTNodes.getUnparenthesedExpression(exprBody);
        if (exprBody == null || !ConvertLambdaToMethodReferenceFixCore.isValidLambdaReferenceToMethod(exprBody)) {
            return null;
        }
        if (!ASTNodes.isParent((ASTNode)exprBody, node) && !ConvertLambdaToMethodReferenceFixCore.representsDefiningNode(node, (ASTNode)exprBody)) {
            return null;
        }
        ArrayList<Expression> lambdaParameters = new ArrayList<Expression>();
        for (VariableDeclaration param : lambda.parameters()) {
            lambdaParameters.add((Expression)param.getName());
        }
        if (exprBody instanceof ClassInstanceCreation) {
            ClassInstanceCreation cic = (ClassInstanceCreation)exprBody;
            if (cic.getExpression() != null || cic.getAnonymousClassDeclaration() != null) {
                return null;
            }
            if (!ConvertLambdaToMethodReferenceFixCore.matches(lambdaParameters, cic.arguments())) {
                return null;
            }
        } else if (exprBody instanceof ArrayCreation) {
            List dimensions = ((ArrayCreation)exprBody).dimensions();
            if (dimensions.size() != 1) {
                return null;
            }
            if (!ConvertLambdaToMethodReferenceFixCore.matches(lambdaParameters, dimensions)) {
                return null;
            }
        } else if (exprBody instanceof SuperMethodInvocation) {
            ITypeBinding invocationTypeBinding;
            SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)exprBody;
            methodBinding = superMethodInvocation.resolveMethodBinding();
            if (methodBinding == null) {
                return null;
            }
            if (Modifier.isStatic((int)methodBinding.getModifiers()) && (invocationTypeBinding = ASTNodes.getInvocationType((ASTNode)superMethodInvocation, methodBinding, (Expression)superMethodInvocation.getQualifier())) == null) {
                return null;
            }
            if (!ConvertLambdaToMethodReferenceFixCore.matches(lambdaParameters, superMethodInvocation.arguments())) {
                return null;
            }
        } else if (exprBody instanceof InstanceofExpression) {
            InstanceofExpression instanceofExpression = (InstanceofExpression)exprBody;
            if (instanceofExpression.getRightOperand().resolveBinding() == null) {
                return null;
            }
            if (!ConvertLambdaToMethodReferenceFixCore.matches(lambdaParameters, List.of(instanceofExpression.getLeftOperand()))) {
                return null;
            }
        } else {
            MethodInvocation methodInvocation = (MethodInvocation)exprBody;
            methodBinding = methodInvocation.resolveMethodBinding();
            if (methodBinding == null) {
                return null;
            }
            Expression invocationExpr = methodInvocation.getExpression();
            if (Modifier.isStatic((int)methodBinding.getModifiers())) {
                ITypeBinding invocationTypeBinding = ASTNodes.getInvocationType((ASTNode)methodInvocation, methodBinding, invocationExpr);
                if (invocationTypeBinding == null) {
                    return null;
                }
                if (!ConvertLambdaToMethodReferenceFixCore.matches(lambdaParameters, methodInvocation.arguments())) {
                    return null;
                }
            } else if (lambda.parameters().size() - methodInvocation.arguments().size() == 1) {
                if (invocationExpr == null) {
                    return null;
                }
                ITypeBinding invocationTypeBinding = invocationExpr.resolveTypeBinding();
                if (invocationTypeBinding == null) {
                    return null;
                }
                IMethodBinding lambdaMethodBinding = lambda.resolveMethodBinding();
                if (lambdaMethodBinding == null) {
                    return null;
                }
                ITypeBinding firstParamType = lambdaMethodBinding.getParameterTypes()[0];
                if (!Bindings.equals((IBinding)invocationTypeBinding, (IBinding)firstParamType) && !Bindings.isSuperType(invocationTypeBinding, firstParamType) || !JdtASTMatcher.doNodesMatch((ASTNode)lambdaParameters.get(0), (ASTNode)invocationExpr) || !ConvertLambdaToMethodReferenceFixCore.matches(lambdaParameters.subList(1, lambdaParameters.size()), methodInvocation.arguments())) {
                    return null;
                }
            } else if (!ConvertLambdaToMethodReferenceFixCore.matches(lambdaParameters, methodInvocation.arguments())) {
                return null;
            }
        }
        String label = CorrectionMessages.QuickAssistProcessor_convert_to_method_reference;
        return new ConvertLambdaToMethodReferenceFixCore(label, compilationUnit, new ConvertLambdaToMethodReferenceProposalOperation(lambda, exprBody));
    }

    public static boolean matches(List<Expression> expected, List<Expression> toMatch) {
        if (toMatch.size() != expected.size()) {
            return false;
        }
        int i = 0;
        while (i < toMatch.size()) {
            if (!JdtASTMatcher.doNodesMatch((ASTNode)expected.get(i), (ASTNode)toMatch.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean representsDefiningNode(ASTNode innerNode, ASTNode definingNode) {
        if (innerNode == definingNode) {
            return true;
        }
        switch (definingNode.getNodeType()) {
            case 14: {
                return ConvertLambdaToMethodReferenceFixCore.representsDefiningNode(innerNode, (ASTNode)((ClassInstanceCreation)definingNode).getType());
            }
            case 3: {
                return ConvertLambdaToMethodReferenceFixCore.representsDefiningNode(innerNode, (ASTNode)((ArrayCreation)definingNode).getType());
            }
            case 48: {
                return innerNode == ((SuperMethodInvocation)definingNode).getName();
            }
            case 32: {
                return innerNode == ((MethodInvocation)definingNode).getName();
            }
            case 88: {
                return innerNode == ((NameQualifiedType)definingNode).getName();
            }
            case 75: {
                return innerNode == ((QualifiedType)definingNode).getName();
            }
            case 43: {
                return innerNode == ((SimpleType)definingNode).getName();
            }
            case 5: {
                return ConvertLambdaToMethodReferenceFixCore.representsDefiningNode(innerNode, (ASTNode)((ArrayType)definingNode).getElementType());
            }
            case 74: {
                return ConvertLambdaToMethodReferenceFixCore.representsDefiningNode(innerNode, (ASTNode)((ParameterizedType)definingNode).getType());
            }
        }
        return false;
    }

    public static boolean isValidLambdaReferenceToMethod(Expression expression) {
        if (expression instanceof ClassInstanceCreation || expression instanceof ArrayCreation || expression instanceof SuperMethodInvocation || expression instanceof InstanceofExpression) {
            return true;
        }
        if (expression instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)expression;
            LambdaExpression lambda = ASTNodes.getFirstAncestorOrNull((ASTNode)expression, LambdaExpression.class);
            if (lambda != null) {
                ITypeBinding typeBinding;
                MethodInvocation outer = ASTNodes.getFirstAncestorOrNull((ASTNode)lambda, MethodInvocation.class);
                if (outer == null) {
                    return true;
                }
                IMethodBinding outerBinding = outer.resolveMethodBinding();
                if (!Modifier.isStatic((int)outerBinding.getModifiers())) {
                    return true;
                }
                IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
                if (methodBinding != null && (typeBinding = methodBinding.getDeclaringClass()) != null) {
                    return !typeBinding.isInterface() || Modifier.isStatic((int)methodBinding.getModifiers());
                }
            }
        }
        return false;
    }

    private static class ConvertLambdaToMethodReferenceProposalOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private LambdaExpression lambda;
        private Expression exprBody;

        public ConvertLambdaToMethodReferenceProposalOperation(LambdaExpression lambda, Expression exprBody) {
            this.lambda = lambda;
            this.exprBody = exprBody;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            CreationReference replacement;
            AST ast = cuRewrite.getAST();
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            if (this.exprBody instanceof ClassInstanceCreation) {
                CreationReference creationReference;
                replacement = creationReference = ast.newCreationReference();
                ClassInstanceCreation cic = (ClassInstanceCreation)this.exprBody;
                Type type = cic.getType();
                if (type.isParameterizedType() && ((ParameterizedType)type).typeArguments().size() == 0) {
                    type = ((ParameterizedType)type).getType();
                }
                creationReference.setType((Type)rewrite.createCopyTarget((ASTNode)type));
                creationReference.typeArguments().addAll(QuickAssistProcessorUtil.getCopiedTypeArguments(rewrite, cic.typeArguments()));
            } else if (this.exprBody instanceof ArrayCreation) {
                CreationReference creationReference = ast.newCreationReference();
                ArrayType arrayType = ((ArrayCreation)this.exprBody).getType();
                Type copiedElementType = (Type)rewrite.createCopyTarget((ASTNode)arrayType.getElementType());
                creationReference.setType((Type)ast.newArrayType(copiedElementType, arrayType.getDimensions()));
                replacement = this.castMethodRefIfNeeded(cuRewrite, ast, (Expression)creationReference);
            } else if (this.exprBody instanceof SuperMethodInvocation) {
                SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)this.exprBody;
                IMethodBinding methodBinding = superMethodInvocation.resolveMethodBinding();
                Name superQualifier = superMethodInvocation.getQualifier();
                if (Modifier.isStatic((int)methodBinding.getModifiers())) {
                    TypeMethodReference typeMethodReference = ast.newTypeMethodReference();
                    typeMethodReference.setName((SimpleName)rewrite.createCopyTarget((ASTNode)superMethodInvocation.getName()));
                    ImportRewrite importRewrite = cuRewrite.getImportRewrite();
                    ITypeBinding invocationTypeBinding = ASTNodes.getInvocationType((ASTNode)superMethodInvocation, methodBinding, (Expression)superQualifier);
                    typeMethodReference.setType(importRewrite.addImport(invocationTypeBinding.getTypeDeclaration().getErasure(), ast));
                    typeMethodReference.typeArguments().addAll(QuickAssistProcessorUtil.getCopiedTypeArguments(rewrite, superMethodInvocation.typeArguments()));
                    replacement = this.castMethodRefIfNeeded(cuRewrite, ast, (Expression)typeMethodReference);
                } else {
                    SuperMethodReference superMethodReference = ast.newSuperMethodReference();
                    if (superQualifier != null) {
                        superMethodReference.setQualifier((Name)rewrite.createCopyTarget((ASTNode)superQualifier));
                    }
                    superMethodReference.setName((SimpleName)rewrite.createCopyTarget((ASTNode)superMethodInvocation.getName()));
                    superMethodReference.typeArguments().addAll(QuickAssistProcessorUtil.getCopiedTypeArguments(rewrite, superMethodInvocation.typeArguments()));
                    replacement = this.castMethodRefIfNeeded(cuRewrite, ast, (Expression)superMethodReference);
                }
            } else if (this.exprBody instanceof InstanceofExpression) {
                InstanceofExpression instanceofExpression = (InstanceofExpression)this.exprBody;
                ExpressionMethodReference expMethodReference = ast.newExpressionMethodReference();
                TypeLiteral typeLiteral = ast.newTypeLiteral();
                ImportRewrite importRewrite = cuRewrite.getImportRewrite();
                ITypeBinding instanceofTypeBinding = instanceofExpression.getRightOperand().resolveBinding();
                typeLiteral.setType(importRewrite.addImport(instanceofTypeBinding.getTypeDeclaration().getErasure(), ast));
                expMethodReference.setName(ast.newSimpleName("isInstance"));
                expMethodReference.setExpression((Expression)typeLiteral);
                replacement = this.castMethodRefIfNeeded(cuRewrite, ast, (Expression)expMethodReference);
            } else {
                boolean isTypeRefToInstanceMethod;
                MethodInvocation methodInvocation = (MethodInvocation)this.exprBody;
                IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
                Expression invocationQualifier = methodInvocation.getExpression();
                boolean isStaticMethod = Modifier.isStatic((int)methodBinding.getModifiers());
                boolean bl = isTypeRefToInstanceMethod = methodInvocation.arguments().size() != this.lambda.parameters().size();
                if (isStaticMethod || isTypeRefToInstanceMethod) {
                    TypeMethodReference typeMethodReference = ast.newTypeMethodReference();
                    typeMethodReference.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodInvocation.getName()));
                    ImportRewrite importRewrite = cuRewrite.getImportRewrite();
                    ITypeBinding invocationTypeBinding = ASTNodes.getInvocationType((ASTNode)methodInvocation, methodBinding, invocationQualifier);
                    invocationTypeBinding = StubUtility2Core.replaceWildcardsAndCaptures(invocationTypeBinding);
                    ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)this.lambda, importRewrite);
                    typeMethodReference.setType(importRewrite.addImport(invocationTypeBinding.getErasure(), ast, (ImportRewrite.ImportRewriteContext)importRewriteContext, ImportRewrite.TypeLocation.OTHER));
                    typeMethodReference.typeArguments().addAll(QuickAssistProcessorUtil.getCopiedTypeArguments(rewrite, methodInvocation.typeArguments()));
                    replacement = this.castMethodRefIfNeeded(cuRewrite, ast, (Expression)typeMethodReference);
                } else {
                    ExpressionMethodReference exprMethodReference = ast.newExpressionMethodReference();
                    exprMethodReference.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodInvocation.getName()));
                    if (invocationQualifier != null) {
                        exprMethodReference.setExpression((Expression)rewrite.createCopyTarget((ASTNode)invocationQualifier));
                    } else {
                        TypeDeclaration lambdaParentType = (TypeDeclaration)ASTResolving.findParentType((ASTNode)this.lambda);
                        ITypeBinding lambdaMethodInvokingClass = lambdaParentType.resolveBinding();
                        ITypeBinding lambdaMethodDeclaringClass = methodBinding.getDeclaringClass();
                        ThisExpression newThisExpression = ast.newThisExpression();
                        ITypeBinding nestedRootClass = ConvertLambdaToMethodReferenceProposalOperation.getNestedRootClass(lambdaMethodInvokingClass);
                        boolean isSuperClass = ConvertLambdaToMethodReferenceProposalOperation.isSuperClass(lambdaMethodDeclaringClass, lambdaMethodInvokingClass);
                        boolean isNestedClass = ConvertLambdaToMethodReferenceProposalOperation.isNestedClass(lambdaMethodDeclaringClass, lambdaMethodInvokingClass);
                        if (lambdaMethodDeclaringClass != lambdaMethodInvokingClass) {
                            if (Modifier.isDefault((int)methodBinding.getModifiers())) {
                                boolean nestedInterfaceClass = ConvertLambdaToMethodReferenceProposalOperation.isNestedInterfaceClass(ast, lambdaMethodDeclaringClass, lambdaMethodInvokingClass);
                                if (!(isNestedClass || nestedInterfaceClass && !isSuperClass || nestedInterfaceClass && nestedRootClass == lambdaMethodInvokingClass)) {
                                    newThisExpression.setQualifier(ast.newName(nestedRootClass.getName()));
                                }
                            } else if (lambdaMethodDeclaringClass.isInterface()) {
                                if (!isSuperClass) {
                                    newThisExpression.setQualifier(ast.newName(nestedRootClass.getName()));
                                }
                            } else if (!isSuperClass) {
                                newThisExpression.setQualifier(ast.newName(nestedRootClass.getName()));
                            }
                        }
                        exprMethodReference.setExpression((Expression)newThisExpression);
                    }
                    exprMethodReference.typeArguments().addAll(QuickAssistProcessorUtil.getCopiedTypeArguments(rewrite, methodInvocation.typeArguments()));
                    replacement = this.castMethodRefIfNeeded(cuRewrite, ast, (Expression)exprMethodReference);
                }
            }
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.lambda, (ASTNode)replacement, null);
        }

        private ASTNode castMethodRefIfNeeded(CompilationUnitRewrite cuRewrite, AST ast, Expression methodRef) {
            boolean needCast = false;
            Expression replacementNode = methodRef;
            if (this.lambda.getLocationInParent() == MethodInvocation.ARGUMENTS_PROPERTY) {
                MethodInvocation parent = (MethodInvocation)this.lambda.getParent();
                List args = parent.arguments();
                IMethodBinding parentBinding = parent.resolveMethodBinding().getMethodDeclaration();
                if (parentBinding != null) {
                    ITypeBinding parentTypeBinding = parentBinding.getDeclaringClass().getErasure();
                    while (parentTypeBinding != null) {
                        IMethodBinding[] parentTypeMethods;
                        IMethodBinding[] iMethodBindingArray = parentTypeMethods = parentTypeBinding.getDeclaredMethods();
                        int n = parentTypeMethods.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMethodBinding parentTypeMethod = iMethodBindingArray[n2];
                            if (parentTypeMethod.getName().equals(parentBinding.getName()) && parentTypeMethod.getParameterTypes().length == args.size() && !parentTypeMethod.isEqualTo((IBinding)parentBinding)) {
                                needCast = true;
                                break;
                            }
                            ++n2;
                        }
                        if (needCast) break;
                        parentTypeBinding = parentTypeBinding.getSuperclass();
                    }
                    if (needCast) {
                        for (Expression arg : args) {
                            if (arg != this.lambda) continue;
                            CastExpression cast = ast.newCastExpression();
                            cast.setExpression(methodRef);
                            ITypeBinding argTypeBinding = arg.resolveTypeBinding();
                            if (argTypeBinding == null) {
                                return replacementNode;
                            }
                            ImportRewrite importRewriter = cuRewrite.getImportRewrite();
                            Type argType = importRewriter.addImport(argTypeBinding, ast);
                            cast.setType(argType);
                            replacementNode = cast;
                        }
                    }
                }
            }
            return replacementNode;
        }

        public static boolean isNestedInterfaceClass(AST ast, ITypeBinding lambdaMethodDeclaringClass, ITypeBinding lambdaMethodInvokingClass) {
            ITypeBinding[] methodNarrowingTypes = ASTResolving.getRelaxingTypes(ast, lambdaMethodDeclaringClass);
            ITypeBinding[] lambdaNarrowingTypes = ASTResolving.getRelaxingTypes(ast, lambdaMethodInvokingClass);
            if (methodNarrowingTypes.length != 1) {
                return false;
            }
            ITypeBinding methodNarrowingType = methodNarrowingTypes[0];
            ITypeBinding[] iTypeBindingArray = lambdaNarrowingTypes;
            int n = lambdaNarrowingTypes.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding lambdaNarrowingType = iTypeBindingArray[n2];
                if (methodNarrowingType == lambdaNarrowingType) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public static boolean isSuperClass(ITypeBinding methodDeclarationType, ITypeBinding lambdaDeclarationType) {
            ITypeBinding parent = lambdaDeclarationType.getSuperclass();
            while (parent != null) {
                if (parent == methodDeclarationType) {
                    return true;
                }
                parent = parent.getSuperclass();
            }
            return false;
        }

        public static boolean isNestedClass(ITypeBinding methodDeclarationType, ITypeBinding lambdaDeclarationType) {
            ITypeBinding parent = lambdaDeclarationType;
            while (parent.isNested()) {
                if ((parent = parent.getDeclaringClass()) != methodDeclarationType) continue;
                return true;
            }
            return false;
        }

        public static ITypeBinding getNestedRootClass(ITypeBinding lambdaDeclarationType) {
            ITypeBinding parent = lambdaDeclarationType;
            while (parent.isNested()) {
                parent = parent.getDeclaringClass();
            }
            return parent;
        }
    }
}

