/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSLine;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSScanner;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.text.edits.TextEditGroup;

public class UnwrapNewArrayOperation
extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
    private final ArrayCreation node;
    private final Expression call;

    public UnwrapNewArrayOperation(ArrayCreation node, Expression call) {
        this.node = node;
        this.call = call;
    }

    @Override
    public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
        ASTRewrite rewrite = cuRewrite.getASTRewrite();
        List expressionsInArray = this.node != null && this.node.getInitializer() != null && this.node.getInitializer().expressions() != null ? this.node.getInitializer().expressions() : Collections.EMPTY_LIST;
        ArrayType arrayType = this.node != null ? this.node.getType() : null;
        ICompilationUnit cu = cuRewrite.getCu();
        CompilationUnit root = cuRewrite.getRoot();
        ImportRemover remover = cuRewrite.getImportRemover();
        boolean tagged = false;
        try {
            NLSLine[] nlsLines = NLSScanner.scan(cu);
            int startLine = root.getLineNumber(this.call.getStartPosition());
            int endLine = root.getLineNumber(this.call.getStartPosition() + this.call.getLength());
            int lineNo = startLine;
            while (lineNo <= endLine) {
                NLSLine[] nLSLineArray = nlsLines;
                int n = nlsLines.length;
                int n2 = 0;
                while (n2 < n) {
                    NLSLine nlsLine = nLSLineArray[n2];
                    if (nlsLine.getLineNumber() == lineNo - 1) {
                        NLSElement[] nLSElementArray = nlsLine.getElements();
                        int n3 = nLSElementArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            NLSElement element = nLSElementArray[n4];
                            if (element.hasTag()) {
                                tagged = true;
                                break;
                            }
                            ++n4;
                        }
                    }
                    if (tagged) break;
                    ++n2;
                }
                if (!tagged) {
                    ++lineNo;
                    continue;
                }
                break;
            }
        }
        catch (Exception nlsLines) {
            // empty catch block
        }
        TextEditGroup group = this.createTextEditGroup(FixMessages.UnusedCodeFix_RemoveUnnecessaryArrayCreation_description, cuRewrite);
        if (!tagged) {
            ListRewrite listRewrite;
            if (this.call instanceof ClassInstanceCreation) {
                listRewrite = rewrite.getListRewrite((ASTNode)this.call, ClassInstanceCreation.ARGUMENTS_PROPERTY);
            } else if (this.call instanceof MethodInvocation) {
                listRewrite = rewrite.getListRewrite((ASTNode)this.call, MethodInvocation.ARGUMENTS_PROPERTY);
            } else if (this.call instanceof SuperMethodInvocation) {
                listRewrite = rewrite.getListRewrite((ASTNode)this.call, SuperMethodInvocation.ARGUMENTS_PROPERTY);
            } else {
                return;
            }
            if (this.node.getInitializer() != null && this.node.getInitializer().expressions() != null) {
                int i = 1;
                while (i < expressionsInArray.size()) {
                    listRewrite.insertLast((ASTNode)ASTNodes.createMoveTarget(rewrite, (Expression)expressionsInArray.get(i)), group);
                    ++i;
                }
                if (expressionsInArray.isEmpty()) {
                    listRewrite.remove((ASTNode)this.node, group);
                } else {
                    listRewrite.replace((ASTNode)this.node, (ASTNode)ASTNodes.createMoveTarget(rewrite, (Expression)expressionsInArray.get(0)), group);
                }
            } else {
                listRewrite.remove((ASTNode)this.node, group);
            }
        } else {
            StringBuilder buf = new StringBuilder();
            CompilationUnit comp = (CompilationUnit)this.call.getRoot();
            int nodeStart = comp.getExtendedStartPosition((ASTNode)this.call);
            int nodeEnd = comp.getExtendedStartPosition((ASTNode)this.call) + comp.getExtendedLength((ASTNode)this.call);
            int arrayStart = this.node.getStartPosition();
            List expressionList = this.node.getInitializer().expressions();
            int arrayExpressionStart = ((Expression)expressionList.get(0)).getStartPosition();
            IBuffer cuBuffer = cu.getBuffer();
            String arrayStartString = cuBuffer.getText(arrayStart, arrayExpressionStart - arrayStart);
            int index = arrayStartString.indexOf(123) + 1;
            while (index < arrayStartString.length() && (arrayStartString.charAt(index) == ' ' || arrayStartString.charAt(index) == '\t')) {
                ++index;
            }
            arrayExpressionStart = arrayStart + index;
            Expression lastExpression = (Expression)expressionList.get(expressionList.size() - 1);
            int arrayExpressionEnd = lastExpression.getStartPosition() + lastExpression.getLength();
            int arrayInitializerEnd = this.node.getInitializer().getStartPosition() + this.node.getInitializer().getLength();
            buf.append(cuBuffer.getText(nodeStart, arrayStart - nodeStart));
            buf.append(cuBuffer.getText(arrayExpressionStart, arrayExpressionEnd - arrayExpressionStart));
            buf.append(cuBuffer.getText(arrayInitializerEnd, nodeEnd - arrayInitializerEnd));
            ASTNode replacementNode = null;
            if (this.call instanceof ClassInstanceCreation) {
                replacementNode = rewrite.createStringPlaceholder(buf.toString(), 14);
            } else if (this.call instanceof MethodInvocation) {
                replacementNode = rewrite.createStringPlaceholder(buf.toString(), 32);
            } else if (this.call instanceof SuperMethodInvocation) {
                replacementNode = rewrite.createStringPlaceholder(buf.toString(), 48);
            } else {
                return;
            }
            rewrite.replace((ASTNode)this.call, replacementNode, group);
        }
        if (arrayType != null) {
            remover.registerRemovedNode((ASTNode)arrayType);
        }
    }
}

