/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.generators;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.lemminx.extensions.generators.Cardinality;

public class ChildrenProperties {
    private List<String> orderedTags;
    private boolean sequenced = true;
    private Map<String, Cardinality> cardinalities = new LinkedHashMap<String, Cardinality>();

    public void addChildHierarchy(List<String> tags) {
        Long count;
        Cardinality cardinality;
        String tag;
        boolean first = this.orderedTags == null;
        Map tagsCount = tags.stream().collect(Collectors.groupingBy(Function.identity(), LinkedHashMap::new, Collectors.counting()));
        LinkedList newOrderedTags = new LinkedList(tagsCount.keySet());
        for (Map.Entry<String, Cardinality> entry : this.cardinalities.entrySet()) {
            tag = entry.getKey();
            cardinality = entry.getValue();
            count = (Long)tagsCount.remove(tag);
            if (count != null) {
                cardinality.update(count);
                continue;
            }
            cardinality.setMin(0L);
        }
        for (Map.Entry<String, Cardinality> entry : tagsCount.entrySet()) {
            tag = entry.getKey();
            cardinality = this.cardinalities.get(tag);
            if (cardinality == null) {
                cardinality = new Cardinality();
                this.cardinalities.put(tag, cardinality);
            }
            count = (Long)tagsCount.get(tag);
            if (first) {
                cardinality.set(count);
                continue;
            }
            cardinality.update(count);
        }
        for (Map.Entry<String, Cardinality> entry : this.cardinalities.entrySet()) {
            tag = entry.getKey();
            cardinality = entry.getValue();
            if (cardinality.getMin() != 0L) continue;
            if (this.orderedTags != null) {
                this.orderedTags.remove(tag);
            }
            newOrderedTags.remove(tag);
        }
        if (this.sequenced && this.orderedTags != null) {
            this.sequenced = this.orderedTags.equals(newOrderedTags);
        }
        this.orderedTags = newOrderedTags;
    }

    public Map<String, Cardinality> getCardinalities() {
        return this.cardinalities;
    }

    public boolean isSequenced() {
        return this.sequenced;
    }
}

