/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.ui;

import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignerState;
import org.eclipse.datatools.connectivity.oda.design.ResourceIdentifiers;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.NewDataSourceWizardBase;
import org.eclipse.datatools.connectivity.ui.PingJob;
import org.eclipse.datatools.connectivity.ui.wizards.ConnectionProfileDetailsPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public abstract class DataSourceWizardPageCore
extends ConnectionProfileDetailsPage {
    private Boolean m_setPingButtonVisible;

    protected abstract DataSourceDesign collectDataSourceDesign(DataSourceDesign var1);

    protected abstract void cleanup();

    protected abstract void refresh();

    protected DataSourceWizardPageCore(String name) {
        super(name);
    }

    protected DataSourceWizardPageCore(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public IWizardPage getNextPage() {
        NewDataSourceWizardBase wizard = this.getOdaWizard();
        return wizard != null && wizard.isInOdaDesignSession() ? null : super.getNextPage();
    }

    public boolean isPageComplete() {
        return this.isControlCreated() && super.isPageComplete();
    }

    protected NewDataSourceWizardBase getOdaWizard() {
        if (this.getWizard() instanceof NewDataSourceWizardBase) {
            return (NewDataSourceWizardBase)this.getWizard();
        }
        return null;
    }

    protected String getOdaDataSourceId() {
        return this.getOdaWizard().getOdaDataSourceId();
    }

    protected String getOdaDesignerId() {
        return this.getOdaWizard().getOdaDesignerId();
    }

    protected ResourceIdentifiers getHostResourceIdentifiers() {
        NewDataSourceWizardBase wizard = this.getOdaWizard();
        return wizard != null ? wizard.getHostResourceIdentifiers() : null;
    }

    public DataSourceDesign finishDataSourceDesign(DataSourceDesign design) throws OdaException {
        return this.collectDataSourceDesign(design);
    }

    protected void setResponseDesignerState(DesignerState customDesignerState) {
        NewDataSourceWizardBase wizard = this.getOdaWizard();
        if (wizard != null) {
            wizard.setResponseDesignerState(customDesignerState);
        }
    }

    public void dispose() {
        this.cleanup();
        super.dispose();
    }

    protected void setPingButtonVisible(boolean visible) {
        this.m_setPingButtonVisible = null;
        if (this.btnPing == null) {
            this.m_setPingButtonVisible = visible;
        } else {
            super.setPingButtonVisible(visible);
        }
    }

    public void createControl(Composite parent) {
        this.setAutoConnectOnFinishDefault(false);
        this.setShowAutoConnectOnFinish(false);
        this.setShowAutoConnect(false);
        super.createControl(parent);
        if (this.m_setPingButtonVisible != null) {
            super.setPingButtonVisible(this.m_setPingButtonVisible.booleanValue());
        }
    }

    protected Runnable createTestConnectionRunnable(final IConnectionProfile profile) {
        return new Runnable(){

            @Override
            public void run() {
                IConnection conn = PingJob.createTestConnection((IConnectionProfile)profile);
                Throwable exception = PingJob.getTestConnectionException((IConnection)conn);
                if (conn != null) {
                    conn.close();
                }
                PingJob.PingUIJob.showTestConnectionMessage((Shell)DataSourceWizardPageCore.this.getShell(), (Throwable)exception);
            }
        };
    }

    protected boolean isSessionEditable() {
        NewDataSourceWizardBase wizard = this.getOdaWizard();
        if (wizard == null) {
            return true;
        }
        return wizard.isSessionEditable();
    }
}

