/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.IOException;
import java.io.RandomAccessFile;

public class RAStreamBuffer {
    private RandomAccessFile randomFile;
    private byte[] buf;
    private long offset;
    private int bufLen;
    private int bufCur;

    public RAStreamBuffer(RandomAccessFile randomFile) {
        this.randomFile = randomFile;
        this.buf = new byte[8192];
    }

    public void resetBuffer(long offset) throws IOException {
        this.offset = offset;
        this.randomFile.seek(offset);
        this.bufLen = this.read(this.buf, 0, 8192);
        this.bufCur = 0;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setBufCur(int bufCur) {
        this.bufCur = bufCur;
    }

    public int getBufCur() {
        return this.bufCur;
    }

    public void flushBuffer() throws IOException {
        if (this.bufLen > 0) {
            this.randomFile.seek(this.offset);
            this.randomFile.write(this.buf, 0, this.bufLen);
            this.bufLen = 0;
        }
    }

    public int write(byte[] b, int off, int len) {
        int availableSize = 8192 - this.bufCur;
        if (len > availableSize) {
            len = availableSize;
        }
        System.arraycopy(b, off, this.buf, this.bufCur, len);
        this.bufCur += len;
        if (this.bufLen < this.bufCur) {
            this.bufLen = this.bufCur;
        }
        return len;
    }

    private int read(byte[] b, int off, int len) throws IOException {
        int count;
        int n = 0;
        do {
            if ((count = this.randomFile.read(b, off + n, len - n)) >= 0) continue;
            return n;
        } while ((n += count) < len);
        return n;
    }
}

