/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.CompareAction;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.ResourceCompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.attributes.Filtering;
import org.eclipse.egit.core.internal.CompareCoreUtils;
import org.eclipse.egit.core.internal.efs.HiddenResources;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.egit.core.internal.storage.WorkingTreeFileRevision;
import org.eclipse.egit.core.internal.storage.WorkspaceFileRevision;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.core.util.RevCommitUtils;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.ToolsUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.diffmerge.DiffMergeSettings;
import org.eclipse.egit.ui.internal.merge.GitCompareEditorInput;
import org.eclipse.egit.ui.internal.revision.EditableRevision;
import org.eclipse.egit.ui.internal.revision.FileRevisionTypedElement;
import org.eclipse.egit.ui.internal.revision.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.synchronize.DefaultGitSynchronizer;
import org.eclipse.egit.ui.internal.synchronize.GitSynchronizer;
import org.eclipse.egit.ui.internal.synchronize.ModelAwareGitSynchronizer;
import org.eclipse.egit.ui.internal.synchronize.compare.LocalNonWorkspaceTypedElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.diff.DiffConfig;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.internal.diffmergetool.DiffTools;
import org.eclipse.jgit.internal.diffmergetool.ExternalDiffTool;
import org.eclipse.jgit.internal.diffmergetool.FileElement;
import org.eclipse.jgit.internal.diffmergetool.PromptContinueHandler;
import org.eclipse.jgit.internal.diffmergetool.ToolException;
import org.eclipse.jgit.internal.diffmergetool.UserDefinedDiffTool;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.internal.BooleanTriState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.NotIgnoredFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.io.EolStreamTypeUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorPart;

public class CompareUtils {
    private static final String REUSE_COMPARE_EDITOR_PREFID = "org.eclipse.team.ui.reuse_open_compare_editors";
    private static final String TEAM_UI_PLUGIN = "org.eclipse.team.ui";

    public static ITypedElement getFileRevisionTypedElement(String gitPath, RevCommit commit, Repository db) {
        return CompareUtils.getFileRevisionTypedElement(gitPath, commit, db, null);
    }

    public static ITypedElement getFileRevisionTypedElement(String gitPath, RevCommit commit, Repository db, ObjectId blobId) {
        Object right = new GitCompareFileRevisionEditorInput.EmptyTypedElement(NLS.bind((String)UIText.GitHistoryPage_FileNotInCommit, (Object)CompareUtils.getName(gitPath), (Object)CompareUtils.truncatedRevision(commit.name())));
        try {
            IFileRevision nextFile = CompareUtils.getFileRevision(gitPath, commit, db, blobId);
            if (nextFile != null) {
                String encoding = CompareCoreUtils.getResourceEncoding((Repository)db, (String)gitPath);
                right = new FileRevisionTypedElement(nextFile, encoding);
            }
        }
        catch (IOException e) {
            Activator.error(NLS.bind((String)UIText.GitHistoryPage_errorLookingUpPath, (Object)gitPath, (Object)commit.getId()), e);
        }
        return right;
    }

    private static String getName(String gitPath) {
        int last = gitPath.lastIndexOf(47);
        return last >= 0 ? gitPath.substring(last + 1) : gitPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IFileRevision getFileRevision(String gitPath, RevCommit commit, Repository db, ObjectId blobId) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (TreeWalk w = TreeWalk.forPath((Repository)db, (String)gitPath, (RevTree)commit.getTree());){
            if (w == null) {
                return null;
            }
            DirCacheCheckout.CheckoutMetadata metadata = new DirCacheCheckout.CheckoutMetadata(w.getEolStreamType(TreeWalk.OperationType.CHECKOUT_OP), w.getFilterCommand("smudge"));
            if (blobId != null) return GitFileRevision.inCommit((Repository)db, (RevCommit)commit, (String)gitPath, (ObjectId)blobId, (DirCacheCheckout.CheckoutMetadata)metadata);
            blobId = w.getObjectId(0);
            return GitFileRevision.inCommit((Repository)db, (RevCommit)commit, (String)gitPath, (ObjectId)blobId, (DirCacheCheckout.CheckoutMetadata)metadata);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    public static ITypedElement getFileRevisionTypedElementForCommonAncestor(String gitPath, ObjectId commit1, ObjectId commit2, Repository db) {
        ITypedElement ancestor = null;
        RevCommit commonAncestor = null;
        try {
            commonAncestor = RevCommitUtils.getCommonAncestor((Repository)db, (AnyObjectId)commit1, (AnyObjectId)commit2);
        }
        catch (IOException e) {
            Activator.logError(NLS.bind((String)UIText.CompareUtils_errorCommonAncestor, (Object)commit1.getName(), (Object)commit2.getName()), e);
        }
        if (commonAncestor != null) {
            if (commit1.equals((AnyObjectId)commonAncestor.getId()) || commit2.equals((AnyObjectId)commonAncestor.getId())) {
                return null;
            }
            ITypedElement ancestorCandidate = CompareUtils.getFileRevisionTypedElement(gitPath, commonAncestor, db);
            if (!(ancestorCandidate instanceof GitCompareFileRevisionEditorInput.EmptyTypedElement)) {
                ancestor = ancestorCandidate;
            }
        }
        return ancestor;
    }

    public static String truncatedRevision(String ci) {
        if (ObjectId.isId((String)ci)) {
            return ci.substring(0, 7);
        }
        return ci;
    }

    public static void openInCompare(RevCommit commit1, RevCommit commit2, String commit1Path, String commit2Path, Repository repository, IWorkbenchPage workbenchPage) {
        ITypedElement base = CompareUtils.getFileRevisionTypedElement(commit1Path, commit1, repository);
        ITypedElement next = CompareUtils.getFileRevisionTypedElement(commit2Path, commit2, repository);
        GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput(base, next, null);
        CompareUtils.openInCompare(workbenchPage, repository, (CompareEditorInput)in);
    }

    public static void openInCompare(IWorkbenchPage workbenchPage, Repository repository, CompareEditorInput input) {
        if (DiffMergeSettings.useInternalDiffTool()) {
            CompareUtils.openCompareToolInternal(workbenchPage, input);
        } else {
            CompareUtils.openCompareToolExternal(workbenchPage, repository, input);
        }
    }

    private static void openCompareToolInternal(IWorkbenchPage workbenchPage, CompareEditorInput input) {
        IEditorPart editor = CompareUtils.findReusableCompareEditor(input, workbenchPage);
        if (editor != null) {
            IEditorInput otherInput = editor.getEditorInput();
            if (otherInput.equals(input)) {
                if (OpenStrategy.activateOnOpen()) {
                    workbenchPage.activate((IWorkbenchPart)editor);
                } else {
                    workbenchPage.bringToTop((IWorkbenchPart)editor);
                }
            } else {
                CompareUI.reuseCompareEditor((CompareEditorInput)input, (IReusableEditor)((IReusableEditor)editor));
                if (OpenStrategy.activateOnOpen()) {
                    workbenchPage.activate((IWorkbenchPart)editor);
                } else {
                    workbenchPage.bringToTop((IWorkbenchPart)editor);
                }
            }
        } else {
            CompareUI.openCompareEditor((CompareEditorInput)input);
        }
    }

    private static void openCompareToolExternal(final IWorkbenchPage workbenchPage, final Repository repository, final CompareEditorInput input) {
        Job job = new Job(UIText.CompareUtils_ExecutingExtDiffTool){

            public IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (!(input instanceof GitCompareFileRevisionEditorInput)) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(() -> CompareUtils.openCompareToolInternal(workbenchPage, input));
                    return Status.OK_STATUS;
                }
                GitCompareFileRevisionEditorInput gitCompareInput = (GitCompareFileRevisionEditorInput)input;
                FileRevisionTypedElement leftRevision = gitCompareInput.getLeftRevision();
                FileRevisionTypedElement rightRevision = gitCompareInput.getRightRevision();
                String changedFilePath = CompareUtils.getChangedFilePath(repository, gitCompareInput);
                try {
                    FileElement.Type typeRemote;
                    FileElement.Type typeLocal;
                    Optional<String> toolName = DiffMergeSettings.getDiffToolName(repository, changedFilePath);
                    String preferencesCommand = null;
                    if (changedFilePath != null) {
                        preferencesCommand = DiffMergeSettings.getDiffToolCommandFromPreferences(changedFilePath);
                    }
                    if (!toolName.isPresent() && StringUtils.isEmptyOrNull((String)preferencesCommand)) {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> CompareUtils.openCompareToolInternal(workbenchPage, input));
                        return Status.OK_STATUS;
                    }
                    FileNamePromptContinueHandler promptContinueHandler = new FileNamePromptContinueHandler(changedFilePath);
                    boolean swapSides = CompareUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.compare.Swapped");
                    if (swapSides) {
                        typeLocal = FileElement.Type.REMOTE;
                        typeRemote = FileElement.Type.LOCAL;
                    } else {
                        typeLocal = FileElement.Type.LOCAL;
                        typeRemote = FileElement.Type.REMOTE;
                    }
                    FileElement local = null;
                    local = leftRevision != null ? new FileElement(changedFilePath, typeLocal, repository.getWorkTree(), leftRevision.getContents()) : new FileElement(changedFilePath, typeLocal, repository.getWorkTree());
                    FileElement remote = null;
                    remote = rightRevision != null ? new FileElement(changedFilePath, typeRemote, repository.getWorkTree(), rightRevision.getContents()) : new FileElement(changedFilePath, typeRemote, repository.getWorkTree());
                    boolean gui = false;
                    BooleanTriState trustExitCode = BooleanTriState.UNSET;
                    BooleanTriState prompt = BooleanTriState.FALSE;
                    DiffTools diffToolMgr = new DiffTools(repository);
                    if (preferencesCommand != null) {
                        String customToolName = "custom_tool_" + DiffMergeSettings.getFileExtension(changedFilePath);
                        UserDefinedDiffTool tool = new UserDefinedDiffTool(customToolName, "", preferencesCommand);
                        diffToolMgr.compare(local, remote, (ExternalDiffTool)tool, true);
                    } else {
                        diffToolMgr.compare(local, remote, toolName, prompt, gui, trustExitCode, (PromptContinueHandler)promptContinueHandler, tools -> ToolsUtils.informUser(UIText.CompareUtils_NoDiffToolsDefined, UIText.CompareUtils_NoDiffToolSpecified));
                    }
                }
                catch (ToolException e) {
                    return Activator.createErrorStatus(NLS.bind((String)UIText.CompareUtils_ExternalDiffToolDied, (Object)changedFilePath), e);
                }
                catch (CoreException e) {
                    return Activator.createErrorStatus(NLS.bind((String)UIText.CompareUtils_DiffToolExecutionFailed, (Object)changedFilePath), e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private static String getChangedFilePath(Repository repository, GitCompareFileRevisionEditorInput gitCompareInput) {
        FileRevisionTypedElement rightRevision;
        FileRevisionTypedElement leftRevision = gitCompareInput.getLeftRevision();
        IFile leftResource = gitCompareInput.getAdapter(IFile.class);
        String changedFilePath = null;
        if (leftResource != null) {
            changedFilePath = repository.getWorkTree().toPath().relativize(leftResource.getRawLocation().toFile().toPath()).toString();
        } else if (leftRevision != null) {
            changedFilePath = leftRevision.getPath();
        }
        if (changedFilePath == null && (rightRevision = gitCompareInput.getRightRevision()) != null) {
            changedFilePath = rightRevision.getPath();
        }
        return changedFilePath;
    }

    private static IEditorPart findReusableCompareEditor(CompareEditorInput input, IWorkbenchPage page) {
        IEditorPart part;
        IEditorReference editorRef;
        IEditorReference[] editorRefs;
        IEditorReference[] iEditorReferenceArray = editorRefs = page.getEditorReferences();
        int n = editorRefs.length;
        int n2 = 0;
        while (n2 < n) {
            editorRef = iEditorReferenceArray[n2];
            part = editorRef.getEditor(false);
            if (part != null && (part.getEditorInput() instanceof GitCompareFileRevisionEditorInput || part.getEditorInput() instanceof GitCompareEditorInput) && part instanceof IReusableEditor && part.getEditorInput().equals(input)) {
                return part;
            }
            ++n2;
        }
        if (CompareUtils.isReuseOpenEditor()) {
            iEditorReferenceArray = editorRefs;
            n = editorRefs.length;
            n2 = 0;
            while (n2 < n) {
                editorRef = iEditorReferenceArray[n2];
                part = editorRef.getEditor(false);
                if (part != null && part.getEditorInput() instanceof SaveableCompareEditorInput && part instanceof IReusableEditor && !part.isDirty()) {
                    return part;
                }
                ++n2;
            }
        }
        return null;
    }

    private static boolean isReuseOpenEditor() {
        boolean defaultReuse = DefaultScope.INSTANCE.getNode(TEAM_UI_PLUGIN).getBoolean(REUSE_COMPARE_EDITOR_PREFID, false);
        return InstanceScope.INSTANCE.getNode(TEAM_UI_PLUGIN).getBoolean(REUSE_COMPARE_EDITOR_PREFID, defaultReuse);
    }

    private static void setReuseOpenEditor(boolean value) {
        InstanceScope.INSTANCE.getNode(TEAM_UI_PLUGIN).putBoolean(REUSE_COMPARE_EDITOR_PREFID, value);
    }

    public static void compareHeadWithWorkspace(Repository repository, @NonNull IFile file) {
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)file);
        if (mapping == null) {
            Activator.error(NLS.bind((String)UIText.GitHistoryPage_errorLookingUpPath, (Object)file.getLocation(), (Object)repository), new IOException(NLS.bind((String)UIText.CompareUtils_errorNotShared, (Object)file.getFullPath(), (Object)file.getProject().getName())));
            return;
        }
        String path = mapping.getRepoRelativePath((IResource)file);
        ITypedElement base = CompareUtils.getHeadTypedElement(repository, path);
        if (base == null) {
            return;
        }
        WorkspaceFileRevision nextFile = new WorkspaceFileRevision(repository, path, (IResource)file);
        String encoding = null;
        try {
            encoding = file.getCharset();
        }
        catch (CoreException e) {
            Activator.handleError(UIText.CompareUtils_errorGettingEncoding, e, true);
        }
        FileRevisionTypedElement next = new FileRevisionTypedElement((IFileRevision)nextFile, encoding);
        GitCompareFileRevisionEditorInput input = new GitCompareFileRevisionEditorInput(next, base, null);
        CompareUI.openCompareDialog((CompareEditorInput)input);
    }

    public static void compareWorkspaceWithRef(final @NonNull Repository repository, final IResource file, final String refName, final IWorkbenchPage page) {
        if (file == null) {
            return;
        }
        final IPath location = file.getLocation();
        if (location == null) {
            return;
        }
        Job job = new Job(UIText.CompareUtils_jobName){

            public IStatus run(IProgressMonitor monitor) {
                CompareEditorInput in;
                LocalNonWorkspaceTypedElement base;
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)file);
                if (mapping == null) {
                    return Activator.createErrorStatus(NLS.bind((String)UIText.GitHistoryPage_errorLookingUpPath, (Object)location, (Object)repository), new IOException(NLS.bind((String)UIText.CompareUtils_errorNotShared, (Object)file.getFullPath(), (Object)file.getProject().getName())));
                }
                if (Files.isSymbolicLink(location.toFile().toPath())) {
                    base = new LocalNonWorkspaceTypedElement(repository, location);
                } else if (file instanceof IFile) {
                    base = SaveableCompareEditorInput.createFileElement((IFile)((IFile)file));
                } else {
                    return Activator.createErrorStatus(NLS.bind((String)UIText.CompareUtils_wrongResourceArgument, (Object)file));
                }
                String gitPath = mapping.getRepoRelativePath(file);
                try {
                    in = CompareUtils.prepareCompareInput(repository, gitPath, (ITypedElement)base, refName);
                }
                catch (IOException e) {
                    return Activator.createErrorStatus(UIText.CompareWithRefAction_errorOnSynchronize, e);
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                CompareUtils.openCompareEditorRunnable(page, repository, in);
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private static void openCompareEditorRunnable(final IWorkbenchPage page, final Repository repository, final CompareEditorInput in) {
        if (Display.getCurrent() == null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CompareUtils.openCompareEditorRunnable(page, repository, in);
                }
            });
            return;
        }
        if (page != null) {
            CompareUtils.openInCompare(page, repository, in);
        } else {
            CompareUI.openCompareEditor((CompareEditorInput)in);
        }
    }

    private static void compareLocalWithRef(final @NonNull Repository repository, final @NonNull IPath location, final String refName, final IWorkbenchPage page) {
        Job job = new Job(UIText.CompareUtils_jobName){

            public IStatus run(IProgressMonitor monitor) {
                CompareEditorInput in;
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                String gitPath = CompareUtils.getRepoRelativePath(location, repository);
                LocalNonWorkspaceTypedElement base = new LocalNonWorkspaceTypedElement(repository, location);
                try {
                    in = CompareUtils.prepareCompareInput(repository, gitPath, (ITypedElement)base, refName);
                }
                catch (IOException e) {
                    return Activator.createErrorStatus(UIText.CompareWithRefAction_errorOnSynchronize, e);
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                CompareUtils.openCompareEditorRunnable(page, repository, in);
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private static CompareEditorInput prepareCompareInput(Repository repository, String gitPath, ITypedElement base, String refName) throws IOException {
        ITypedElement destCommit;
        ITypedElement commonAncestor = null;
        if ("Index".equals(refName)) {
            destCommit = CompareUtils.getIndexTypedElement(repository, gitPath);
        } else if ("HEAD".equals(refName)) {
            destCommit = CompareUtils.getHeadTypedElement(repository, gitPath);
        } else {
            ObjectId destCommitId = repository.resolve(refName);
            Throwable throwable = null;
            Object var8_9 = null;
            try (RevWalk rw = new RevWalk(repository);){
                RevCommit commit = rw.parseCommit((AnyObjectId)destCommitId);
                destCommit = CompareUtils.getFileRevisionTypedElement(gitPath, commit, repository);
                if (base != null) {
                    ObjectId headCommitId = repository.resolve("HEAD");
                    commonAncestor = CompareUtils.getFileRevisionTypedElementForCommonAncestor(gitPath, headCommitId, destCommitId, repository);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput(base, destCommit, commonAncestor, null);
        in.getCompareConfiguration().setRightLabel(refName);
        return in;
    }

    public static void compare(@NonNull IResource[] resources, @NonNull Repository repository, String leftRev, String rightRev, boolean includeLocal, IWorkbenchPage page) throws IOException {
        CompareUtils.getSynchronizer().compare(resources, repository, leftRev, rightRev, includeLocal, page);
    }

    public static void compare(@NonNull IFile file, @NonNull Repository repository, String leftPath, String rightPath, String leftRev, String rightRev, boolean includeLocal, IWorkbenchPage page) throws IOException {
        CompareUtils.getSynchronizer().compare(file, repository, leftPath, rightPath, leftRev, rightRev, includeLocal, page);
    }

    private static GitSynchronizer getSynchronizer() {
        if (Activator.getDefault().getPreferenceStore().getBoolean("enable_logical_model")) {
            return new ModelAwareGitSynchronizer();
        }
        return new DefaultGitSynchronizer();
    }

    public static void compare(@NonNull IPath location, @NonNull Repository repository, String leftRev, String rightRev, boolean includeLocal, IWorkbenchPage page) {
        if (includeLocal) {
            CompareUtils.compareLocalWithRef(repository, location, rightRev, page);
        } else {
            String gitPath = CompareUtils.getRepoRelativePath(location, repository);
            CompareUtils.compareBetween(repository, gitPath, leftRev, rightRev, page);
        }
    }

    public static void compareBetween(Repository repository, String gitPath, String leftRev, String rightRev, IWorkbenchPage page) {
        CompareUtils.compareBetween(repository, gitPath, null, leftRev, rightRev, page);
    }

    private static String findRename(Repository repository, String newRev, String oldRev, String gitPath, IProgressMonitor progress) {
        block29: {
            try {
                DirCacheIterator newTree = null;
                RevCommit newCommit = null;
                DirCache index = null;
                if ("Index".equals(newRev)) {
                    index = repository.readDirCache();
                    newTree = new DirCacheIterator(index);
                } else {
                    ObjectId newOid = repository.resolve(newRev);
                    if (newOid == null) {
                        return gitPath;
                    }
                    newCommit = repository.parseCommit((AnyObjectId)newOid);
                }
                DirCacheIterator oldTree = null;
                RevCommit oldCommit = null;
                if ("Index".equals(oldRev)) {
                    if (index == null) {
                        index = repository.readDirCache();
                    }
                    oldTree = new DirCacheIterator(index);
                } else {
                    ObjectId oldId = repository.resolve(oldRev);
                    if (oldId == null) {
                        return gitPath;
                    }
                    oldCommit = repository.parseCommit((AnyObjectId)oldId);
                }
                if ((!"Index".equals(newRev) || !"HEAD".equals(oldRev)) && !CompareUtils.isParent(oldCommit, newCommit)) break block29;
                Throwable throwable = null;
                Object var11_14 = null;
                try (TreeWalk walk = new TreeWalk(repository);){
                    walk.setFilter(PathFilterGroup.createFromStrings((String[])new String[]{gitPath}));
                    walk.setRecursive(true);
                    if (oldCommit != null) {
                        walk.addTree((AnyObjectId)oldCommit.getTree());
                    } else {
                        walk.addTree((AbstractTreeIterator)oldTree);
                    }
                    if (walk.next()) {
                        return gitPath;
                    }
                    walk.reset();
                    walk.setFilter(TreeFilter.ANY_DIFF);
                    if (oldCommit != null) {
                        walk.addTree((AnyObjectId)oldCommit.getTree());
                    } else {
                        walk.addTree((AbstractTreeIterator)oldTree);
                    }
                    if (newCommit != null) {
                        walk.addTree((AnyObjectId)newCommit.getTree());
                    } else {
                        walk.addTree((AbstractTreeIterator)newTree);
                    }
                    walk.setRecursive(true);
                    List diffs = DiffEntry.scan((TreeWalk)walk);
                    RenameDetector renameDetector = new RenameDetector(walk.getObjectReader(), (DiffConfig)repository.getConfig().get(DiffConfig.KEY));
                    List filtered = diffs.stream().map(d -> {
                        switch (d.getChangeType()) {
                            case ADD: {
                                if (!d.getNewPath().equals(gitPath)) break;
                                return d;
                            }
                            case DELETE: {
                                return d;
                            }
                            case MODIFY: {
                                return new DeleteView((DiffEntry)d);
                            }
                        }
                        return null;
                    }).filter(Objects::nonNull).collect(Collectors.toList());
                    renameDetector.reset();
                    renameDetector.addAll(filtered);
                    EclipseGitProgressTransformer monitor = new EclipseGitProgressTransformer(progress);
                    List renamed = renameDetector.compute((ProgressMonitor)monitor);
                    for (DiffEntry ent : renamed) {
                        if (!CompareUtils.isRename(ent) || !ent.getNewPath().equals(gitPath)) continue;
                        return ent.getOldPath();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (CanceledException newTree) {
            }
            catch (IOException e) {
                Activator.logError(NLS.bind((String)UIText.CompareUtils_errorRenameDetection, (Object)gitPath), e);
            }
        }
        return gitPath;
    }

    private static boolean isParent(RevCommit old, RevCommit newCommit) {
        if (old == null || newCommit == null) {
            return false;
        }
        return Stream.of(newCommit.getParents()).anyMatch(p -> p.equals((AnyObjectId)old));
    }

    private static boolean isRename(DiffEntry ent) {
        return DiffEntry.ChangeType.RENAME.equals((Object)ent.getChangeType()) || DiffEntry.ChangeType.COPY.equals((Object)ent.getChangeType());
    }

    public static void compareBetween(final Repository repository, final String leftGitPath, final String rightGitPath, final String leftRev, final String rightRev, final IWorkbenchPage page) {
        Job job = new Job(UIText.CompareUtils_jobName){

            public IStatus run(IProgressMonitor monitor) {
                ITypedElement right;
                ITypedElement left;
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                String rightPath = rightGitPath;
                if (rightGitPath == null) {
                    rightPath = CompareUtils.findRename(repository, leftRev, rightRev, leftGitPath, monitor);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                }
                try {
                    left = CompareUtils.getTypedElementFor(repository, leftGitPath, leftRev);
                    right = CompareUtils.getTypedElementFor(repository, rightPath, rightRev);
                }
                catch (IOException e) {
                    return Activator.createErrorStatus(UIText.CompareWithRefAction_errorOnSynchronize, e);
                }
                ITypedElement commonAncestor = left != null && right != null && !"Index".equals(leftRev) && !"Index".equals(rightRev) ? CompareUtils.getTypedElementForCommonAncestor(repository, rightPath, leftRev, rightRev) : null;
                GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput(left, right, commonAncestor, null);
                in.getCompareConfiguration().setLeftLabel(leftRev);
                in.getCompareConfiguration().setRightLabel(rightRev);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                CompareUtils.openCompareEditorRunnable(page, repository, (CompareEditorInput)in);
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public static void compareFiles(IFile aFile, IFile bFile, File a, File b, IWorkbenchPart sourcePart) {
        ArrayList<IFile> toDelete = new ArrayList<IFile>();
        IFile aTmp = aFile;
        IFile bTmp = bFile;
        try {
            if (aTmp == null) {
                aTmp = HiddenResources.INSTANCE.createFile(a.toURI(), a.getName(), null, null);
                toDelete.add(aTmp);
            }
            if (bTmp == null) {
                bTmp = HiddenResources.INSTANCE.createFile(b.toURI(), b.getName(), null, null);
                toDelete.add(bTmp);
            }
        }
        catch (CoreException e) {
            Activator.logError(UIText.CompareUtils_errorHiddenResourceCreate, e);
            CompareUtils.cleanHiddenResources(toDelete);
            return;
        }
        class CompareWithEachOther
        extends CompareAction {
            private final /* synthetic */ List val$toDelete;

            CompareWithEachOther(List list) {
                this.val$toDelete = list;
            }

            public void run(ISelection selection) {
                if (this.isEnabled(selection)) {
                    if (!this.val$toDelete.isEmpty()) {
                        ResourceCompareInput input = this.fInput;
                        this.fWorkbenchPage.addPartListener(new IPartListener((CompareEditorInput)input, this.val$toDelete){
                            private final IWorkbenchPage page;
                            private IWorkbenchPart compareEditor;
                            private final /* synthetic */ CompareEditorInput val$input;
                            private final /* synthetic */ List val$toDelete;
                            {
                                this.val$input = compareEditorInput;
                                this.val$toDelete = list;
                                this.page = fWorkbenchPage;
                            }

                            public void partActivated(IWorkbenchPart part) {
                                if (part instanceof EditorPart && ((EditorPart)part).getEditorInput() == this.val$input) {
                                    this.compareEditor = part;
                                }
                            }

                            public void partBroughtToTop(IWorkbenchPart part) {
                            }

                            public void partClosed(IWorkbenchPart part) {
                                if (part != null && part == this.compareEditor) {
                                    CompareUtils.cleanHiddenResources(this.val$toDelete);
                                    this.page.removePartListener((IPartListener)this);
                                }
                            }

                            public void partDeactivated(IWorkbenchPart part) {
                            }

                            public void partOpened(IWorkbenchPart part) {
                            }
                        });
                    }
                    super.run(selection);
                } else {
                    CompareUtils.cleanHiddenResources(this.val$toDelete);
                }
            }

            public void setActivePart(IAction action, IWorkbenchPart targetPart) {
                super.setActivePart(action, targetPart);
            }
        }
        CompareWithEachOther compare = new CompareWithEachOther(toDelete);
        compare.setActivePart(null, sourcePart);
        StructuredSelection selection = new StructuredSelection(List.of(aTmp, bTmp));
        compare.run((ISelection)selection);
    }

    public static void cleanHiddenResources(final Collection<IFile> toClean) {
        if (toClean == null || toClean.isEmpty()) {
            return;
        }
        Job job = new Job(UIText.CompareUtils_ResourceCleanupJobName){

            public boolean shouldSchedule() {
                return super.shouldSchedule() && !PlatformUI.getWorkbench().isClosing();
            }

            public boolean shouldRun() {
                return super.shouldRun() && !PlatformUI.getWorkbench().isClosing();
            }

            protected IStatus run(IProgressMonitor monitor) {
                IWorkspaceRunnable remove = m -> {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)m, (int)toClean.size());
                    for (IFile tmp : toClean) {
                        if (PlatformUI.getWorkbench().isClosing()) {
                            return;
                        }
                        try {
                            tmp.delete(true, (IProgressMonitor)progress.newChild(1));
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                };
                try {
                    ResourcesPlugin.getWorkspace().run(remove, null, 1, monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setUser(false);
        job.schedule();
    }

    private static String getRepoRelativePath(@NonNull IPath location, @NonNull Repository repository) {
        Path repoRoot = new Path(repository.getWorkTree().getPath());
        String gitPath = location.makeRelativeTo((IPath)repoRoot).toString();
        return gitPath;
    }

    private static ITypedElement getTypedElementFor(Repository repository, String gitPath, String rev) throws IOException {
        ITypedElement typedElement;
        if ("Index".equals(rev)) {
            typedElement = CompareUtils.getIndexTypedElement(repository, gitPath);
        } else if ("HEAD".equals(rev)) {
            typedElement = CompareUtils.getHeadTypedElement(repository, gitPath);
        } else {
            ObjectId id = repository.resolve(rev);
            Throwable throwable = null;
            Object var6_7 = null;
            try (RevWalk rw = new RevWalk(repository);){
                RevCommit revCommit = rw.parseCommit((AnyObjectId)id);
                typedElement = CompareUtils.getFileRevisionTypedElement(gitPath, revCommit, repository);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return typedElement;
    }

    private static ITypedElement getTypedElementForCommonAncestor(Repository repository, String gitPath, String srcRev, String dstRev) {
        ITypedElement ancestor = null;
        try {
            ObjectId srcID = repository.resolve(srcRev);
            ObjectId dstID = repository.resolve(dstRev);
            if (srcID != null && dstID != null) {
                ancestor = CompareUtils.getFileRevisionTypedElementForCommonAncestor(gitPath, srcID, dstID, repository);
            }
        }
        catch (IOException e) {
            Activator.logError(NLS.bind((String)UIText.CompareUtils_errorCommonAncestor, (Object)srcRev, (Object)dstRev), e);
        }
        return ancestor;
    }

    public static void compareHeadWithWorkingTree(Repository repository, String path) {
        ITypedElement base = CompareUtils.getHeadTypedElement(repository, path);
        if (base == null) {
            return;
        }
        WorkingTreeFileRevision nextFile = new WorkingTreeFileRevision(repository, path);
        String encoding = ResourcesPlugin.getEncoding();
        FileRevisionTypedElement next = new FileRevisionTypedElement((IFileRevision)nextFile, encoding);
        GitCompareFileRevisionEditorInput input = new GitCompareFileRevisionEditorInput(next, base, null);
        CompareUI.openCompareDialog((CompareEditorInput)input);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ITypedElement getHeadTypedElement(Repository repository, String repoRelativePath) {
        try {
            Ref head = repository.exactRef("HEAD");
            if (head == null) return new GitCompareFileRevisionEditorInput.EmptyTypedElement("");
            if (head.getObjectId() == null) {
                return new GitCompareFileRevisionEditorInput.EmptyTypedElement("");
            }
            Throwable throwable = null;
            Object var5_6 = null;
            try (RevWalk rw = new RevWalk(repository);){
                RevCommit headCommit = rw.parseCommit((AnyObjectId)head.getObjectId());
                Throwable throwable2 = null;
                Object var9_12 = null;
                try {
                    TreeWalk tw;
                    block18: {
                        GitCompareFileRevisionEditorInput.EmptyTypedElement emptyTypedElement;
                        tw = TreeWalk.forPath((Repository)repository, (String)repoRelativePath, (RevTree)headCommit.getTree());
                        try {
                            if (tw != null) break block18;
                            emptyTypedElement = new GitCompareFileRevisionEditorInput.EmptyTypedElement(NLS.bind((String)UIText.GitHistoryPage_FileNotInCommit, (Object)CompareUtils.getName(repoRelativePath), (Object)"HEAD"));
                            if (tw == null) return emptyTypedElement;
                        }
                        catch (Throwable throwable3) {
                            if (tw == null) throw throwable3;
                            tw.close();
                            throw throwable3;
                        }
                        tw.close();
                        return emptyTypedElement;
                    }
                    if (tw != null) {
                        tw.close();
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                        throw throwable2;
                    }
                    if (throwable2 == throwable4) throw throwable2;
                    throwable2.addSuppressed(throwable4);
                    throw throwable2;
                }
                rw.markStart(headCommit);
                rw.setTreeFilter(AndTreeFilter.create((TreeFilter)PathFilterGroup.createFromStrings((String[])new String[]{repoRelativePath}), (TreeFilter)TreeFilter.ANY_DIFF));
                rw.setRewriteParents(false);
                RevCommit latestFileCommit = rw.next();
                if (latestFileCommit != null) return CompareUtils.getFileRevisionTypedElement(repoRelativePath, latestFileCommit, repository);
                latestFileCommit = headCommit;
                return CompareUtils.getFileRevisionTypedElement(repoRelativePath, latestFileCommit, repository);
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.handleError(UIText.CompareUtils_errorGettingHeadCommit, e, true);
            return null;
        }
    }

    public static ITypedElement getIndexTypedElement(@NonNull IFile baseFile) throws IOException {
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)baseFile);
        if (mapping == null) {
            Activator.error(NLS.bind((String)UIText.GitHistoryPage_errorLookingUpPath, (Object)baseFile.getLocation(), null), null);
            return null;
        }
        Repository repository = mapping.getRepository();
        String gitPath = mapping.getRepoRelativePath((IResource)baseFile);
        String encoding = CompareCoreUtils.getResourceEncoding((IResource)baseFile);
        return CompareUtils.getIndexTypedElement(repository, gitPath, encoding);
    }

    public static ITypedElement getIndexTypedElement(Repository repository, String repoRelativePath) throws IOException {
        String encoding = CompareCoreUtils.getResourceEncoding((Repository)repository, (String)repoRelativePath);
        return CompareUtils.getIndexTypedElement(repository, repoRelativePath, encoding);
    }

    private static ITypedElement getIndexTypedElement(final Repository repository, final String gitPath, String encoding) {
        GitFileRevision nextFile = GitFileRevision.inIndex((Repository)repository, (String)gitPath);
        final EditableRevision next = new EditableRevision((IFileRevision)nextFile, encoding);
        IContentChangeListener listener = new IContentChangeListener(){

            public void contentChanged(IContentChangeNotifier source) {
                byte[] newContent = next.getModifiedContent();
                CompareUtils.setIndexEntryContents(repository, gitPath, newContent);
            }
        };
        next.addContentChangeListener(listener);
        return next;
    }

    private static void setIndexEntryContents(Repository repository, String gitPath, byte[] newContent) {
        DirCache cache = null;
        try {
            try {
                cache = repository.lockDirCache();
                DirCacheEditor editor = cache.editor();
                if (newContent.length == 0) {
                    editor.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeletePath(gitPath));
                } else {
                    CoreConfig.EolStreamType streamType = null;
                    String command = null;
                    Throwable throwable = null;
                    Object var8_11 = null;
                    try (TreeWalk walk = new TreeWalk(repository);){
                        walk.setOperationType(TreeWalk.OperationType.CHECKIN_OP);
                        walk.addTree((AbstractTreeIterator)new DirCacheIterator(cache));
                        FileTreeIterator files = new FileTreeIterator(repository);
                        files.setDirCacheIterator(walk, 0);
                        walk.addTree((AbstractTreeIterator)files);
                        walk.setFilter(AndTreeFilter.create((TreeFilter)PathFilterGroup.createFromStrings((String[])new String[]{gitPath}), (TreeFilter)new NotIgnoredFilter(1)));
                        walk.setRecursive(true);
                        if (walk.next()) {
                            streamType = walk.getEolStreamType(TreeWalk.OperationType.CHECKIN_OP);
                            command = walk.getFilterCommand("clean");
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    InputStream filtered = Filtering.filter((Repository)repository, (String)gitPath, (InputStream)new ByteArrayInputStream(newContent), (String)command);
                    if (streamType == null) {
                        WorkingTreeOptions workingTreeOptions = (WorkingTreeOptions)repository.getConfig().get(WorkingTreeOptions.KEY);
                        streamType = workingTreeOptions.getAutoCRLF() == CoreConfig.AutoCRLF.FALSE ? CoreConfig.EolStreamType.DIRECT : CoreConfig.EolStreamType.AUTO_LF;
                    }
                    ByteBuffer content = IO.readWholeStream((InputStream)EolStreamTypeUtil.wrapInputStream((InputStream)filtered, (CoreConfig.EolStreamType)streamType), (int)newContent.length);
                    editor.add((DirCacheEditor.PathEdit)new DirCacheEntryEditor(gitPath, repository, content));
                }
                try {
                    editor.commit();
                }
                catch (RuntimeException e) {
                    if (e.getCause() instanceof IOException) {
                        throw (IOException)e.getCause();
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                Activator.handleError(UIText.CompareWithIndexAction_errorOnAddToIndex, e, true);
                if (cache != null) {
                    cache.unlock();
                }
            }
        }
        finally {
            if (cache != null) {
                cache.unlock();
            }
        }
    }

    private static class DeleteView
    extends DiffEntry {
        private static final AbbreviatedObjectId A_ZERO = AbbreviatedObjectId.fromObjectId((AnyObjectId)ObjectId.zeroId());

        public DeleteView(DiffEntry modify) {
            this.changeType = DiffEntry.ChangeType.DELETE;
            this.diffAttribute = modify.getDiffAttribute();
            this.newId = A_ZERO;
            this.newPath = "/dev/null";
            this.newMode = FileMode.MISSING;
            this.oldId = modify.getOldId();
            this.oldPath = modify.getOldPath();
            this.oldMode = modify.getOldMode();
        }
    }

    private static class DirCacheEntryEditor
    extends DirCacheEditor.PathEdit {
        private final Repository repo;
        private final ByteBuffer content;

        public DirCacheEntryEditor(String path, Repository repo, ByteBuffer content) {
            super(path);
            this.repo = repo;
            this.content = content;
        }

        public void apply(DirCacheEntry ent) {
            ObjectInserter inserter = this.repo.newObjectInserter();
            if ((ent.getRawMode() & 0xF000) != 32768) {
                ent.setFileMode(FileMode.REGULAR_FILE);
            }
            ent.setLength(this.content.limit());
            ent.setLastModified(Instant.now());
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(this.content.array(), 0, this.content.limit());
                ent.setObjectId((AnyObjectId)inserter.insert(3, (long)this.content.limit(), (InputStream)in));
                inserter.flush();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static class FileNamePromptContinueHandler
    implements PromptContinueHandler {
        private final String fileName;

        public FileNamePromptContinueHandler(String fileName) {
            this.fileName = fileName;
        }

        public boolean prompt(String toolName) {
            int response = ToolsUtils.askUserAboutToolExecution("difftool", "Comparing file: " + this.fileName + "\n\nLaunch '" + toolName + "' ?");
            return response == 64;
        }
    }

    public static class ReuseCompareEditorAction
    extends Action
    implements IEclipsePreferences.IPreferenceChangeListener,
    ActionFactory.IWorkbenchAction {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.team.ui");

        public ReuseCompareEditorAction() {
            this.node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            this.setText(UIText.GitHistoryPage_ReuseCompareEditorMenuLabel);
            this.setChecked(CompareUtils.isReuseOpenEditor());
        }

        public void run() {
            CompareUtils.setReuseOpenEditor(this.isChecked());
        }

        public void dispose() {
            this.node.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            this.setChecked(CompareUtils.isReuseOpenEditor());
        }
    }
}

