/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.mylyn.context.core.IInteractionContextScaling;
import org.eclipse.mylyn.monitor.core.InteractionEvent;

public class InteractionContextScaling
implements IInteractionContextScaling {
    private static final float DEFAULT_INTERESTING = 0.0f;
    private static final float DEFAULT_EVENT = 1.0f;
    private static final float DEFAULT_EVENT_EDIT = 0.7f;
    private static final float DEFAULT_DECAY = 0.017f;
    private static final float DEFAULT_LANDMARK = 30.0f;
    private static final float DEFAULT_FORCED_LANDMARK = 210.0f;
    private final Map<InteractionEvent.Kind, Float> interactionScalingFactors = new HashMap<InteractionEvent.Kind, Float>();
    private float interesting = 0.0f;
    private float landmark = 30.0f;
    private float forcedLandmark = 210.0f;
    private float decay = 0.017f;
    @Deprecated
    private final float errorInterest = 0.3f;
    @Deprecated
    private final int maxNumInterestingErrors = 20;

    public InteractionContextScaling() {
        this.interactionScalingFactors.put(InteractionEvent.Kind.EDIT, Float.valueOf(0.7f));
    }

    @Override
    public float get(InteractionEvent.Kind kind) {
        if (this.interactionScalingFactors.containsKey(kind)) {
            return this.interactionScalingFactors.get(kind).floatValue();
        }
        return 1.0f;
    }

    public void set(InteractionEvent.Kind kind, float value) {
        this.interactionScalingFactors.put(kind, Float.valueOf(value));
    }

    @Override
    public float getDecay() {
        return this.decay;
    }

    public void setDecay(float decay) {
        this.decay = decay;
    }

    @Override
    public float getInteresting() {
        return this.interesting;
    }

    public void setInteresting(float interesting) {
        this.interesting = interesting;
    }

    @Override
    public float getLandmark() {
        return this.landmark;
    }

    public void setLandmark(float landmark) {
        this.landmark = landmark;
    }

    @Deprecated
    public float getErrorInterest() {
        return 0.3f;
    }

    @Deprecated
    public int getMaxNumInterestingErrors() {
        return 20;
    }

    @Override
    public float getForcedLandmark() {
        return this.forcedLandmark;
    }

    public void setForcedLandmark(float userLandmark) {
        this.forcedLandmark = userLandmark;
    }
}

