/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.jmdns;

import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.provider.IContainerInstantiator;
import org.eclipse.ecf.core.util.AdapterManagerTracker;
import org.eclipse.ecf.core.util.ExtensionRegistryRunnable;
import org.eclipse.ecf.core.util.SystemLogService;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.discovery.IDiscoveryAdvertiser;
import org.eclipse.ecf.discovery.IDiscoveryLocator;
import org.eclipse.ecf.discovery.service.IDiscoveryService;
import org.eclipse.ecf.internal.provider.jmdns.JMDNSDebugOptions;
import org.eclipse.ecf.provider.jmdns.container.ContainerInstantiator;
import org.eclipse.ecf.provider.jmdns.container.JMDNSDiscoveryContainer;
import org.eclipse.ecf.provider.jmdns.identity.JMDNSNamespace;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class JMDNSPlugin
implements BundleActivator {
    public static final String NAME = "ecf.discovery.jmdns";
    private static JMDNSPlugin plugin;
    private BundleContext context = null;
    public static final String PLUGIN_ID = "org.eclipse.ecf.provider.jmdns";
    private AdapterManagerTracker adapterManagerTracker = null;
    private ServiceRegistration serviceRegistration;
    private ServiceTracker logServiceTracker = null;
    private LogService logService = null;
    private final DiscoveryServiceFactory serviceFactory = new DiscoveryServiceFactory();

    public JMDNSPlugin() {
        plugin = this;
    }

    public IAdapterManager getAdapterManager() {
        if (this.adapterManagerTracker == null) {
            this.adapterManagerTracker = new AdapterManagerTracker(this.context);
            this.adapterManagerTracker.open();
        }
        return this.adapterManagerTracker.getAdapterManager();
    }

    public void start(final BundleContext ctxt) throws Exception {
        this.context = ctxt;
        Properties props = new Properties();
        props.put("org.eclipse.ecf.discovery.containerName", NAME);
        props.put("service.ranking", (Object)750);
        String[] clazzes = new String[]{IDiscoveryService.class.getName(), IDiscoveryLocator.class.getName(), IDiscoveryAdvertiser.class.getName()};
        this.serviceRegistration = this.context.registerService(clazzes, (Object)this.serviceFactory, (Dictionary)props);
        SafeRunner.run((ISafeRunnable)new ExtensionRegistryRunnable(ctxt){

            protected void runWithoutRegistry() throws Exception {
                ctxt.registerService(Namespace.class, (Object)new JMDNSNamespace("JMDNS Discovery Namespace"), null);
                ctxt.registerService(ContainerTypeDescription.class, (Object)new ContainerTypeDescription("ecf.container.jmdns", (IContainerInstantiator)new ContainerInstantiator(), "JMDNS Discovery Container", true, false), null);
                ctxt.registerService(ContainerTypeDescription.class, (Object)new ContainerTypeDescription("ecf.container.jmdns.locator", (IContainerInstantiator)new ContainerInstantiator(), "JMDNS Discovery Locator"), null);
                ctxt.registerService(ContainerTypeDescription.class, (Object)new ContainerTypeDescription("ecf.container.jmdns.advertiser", (IContainerInstantiator)new ContainerInstantiator(), "JMDNS Discovery Advertiser"), null);
            }
        });
    }

    protected Bundle getBundle() {
        if (this.context == null) {
            return null;
        }
        return this.context.getBundle();
    }

    public void stop(BundleContext ctxt) throws Exception {
        if (this.serviceRegistration != null && this.serviceFactory.isActive()) {
            ServiceReference reference = this.serviceRegistration.getReference();
            IDiscoveryLocator aLocator = (IDiscoveryLocator)ctxt.getService(reference);
            this.serviceRegistration.unregister();
            IContainer container = (IContainer)aLocator.getAdapter(IContainer.class);
            container.disconnect();
            container.dispose();
            this.serviceRegistration = null;
        }
        if (this.adapterManagerTracker != null) {
            this.adapterManagerTracker.close();
            this.adapterManagerTracker = null;
        }
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
            this.logServiceTracker = null;
            this.logService = null;
        }
        this.context = ctxt;
        plugin = null;
    }

    public static synchronized JMDNSPlugin getDefault() {
        return plugin;
    }

    public void logException(String string, Throwable t) {
        this.getLogService();
        if (this.logService != null) {
            this.logService.log(1, string, t);
        }
    }

    public void logInfo(String string, Throwable t) {
        this.getLogService();
        if (this.logService != null) {
            this.logService.log(3, string, t);
        }
    }

    protected LogService getLogService() {
        if (this.logServiceTracker == null) {
            this.logServiceTracker = new ServiceTracker(this.context, LogService.class.getName(), null);
            this.logServiceTracker.open();
        }
        this.logService = (LogService)this.logServiceTracker.getService();
        if (this.logService == null) {
            this.logService = new SystemLogService(PLUGIN_ID);
        }
        return this.logService;
    }

    public void logError(String errorString) {
        this.getLogService();
        if (this.logService != null) {
            this.logService.log(1, errorString);
        }
    }

    class DiscoveryServiceFactory
    implements ServiceFactory {
        private volatile JMDNSDiscoveryContainer jdc;

        DiscoveryServiceFactory() {
        }

        public Object getService(Bundle bundle, ServiceRegistration registration) {
            if (this.jdc == null) {
                try {
                    this.jdc = new JMDNSDiscoveryContainer();
                    this.jdc.connect(null, null);
                }
                catch (IDCreateException e) {
                    Trace.catching((String)JMDNSPlugin.PLUGIN_ID, (String)JMDNSDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"getService(Bundle, ServiceRegistration)", (Throwable)e);
                }
                catch (ContainerConnectException e) {
                    Trace.catching((String)JMDNSPlugin.PLUGIN_ID, (String)JMDNSDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"getService(Bundle, ServiceRegistration)", (Throwable)e);
                    this.jdc = null;
                }
            }
            return this.jdc;
        }

        public boolean isActive() {
            return this.jdc != null;
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        }
    }
}

